window.startCharCounter = (options={}) ->
  timeoutSet = (tm, fnc) -> setTimeout fnc, tm
  intervalSet = (tm, fnc) -> setInterval fnc, tm
  
  # Return if there is no fast reply or full post form on the page
  if $$("#fast_reply_wrapper").length is 0 and $$("#postingform").length is 0
    return false
  
  # Default configuration options
  config = (
    defaultLimit: 100
    customLimits:
      "17":0 # Moderation discussion
      "54":0 # Staff discussion
      "28":0 # March 2012 Survey
      "8":0 # Colosseum
      "7": 10 # Feedback 
      "43":0 # Forum Games
      "44":0 # Ask a Pony
      "46":0 # General Silliness
      "22":200 # Roleplays
      "38":200 # Life Advice
      "23":75 # OOC
      "55": 800 # Advanced RP games
      "49": 0 # Commissions
      "2": 50 # Welcome area
    customFilters: {}
    message: "Your post is too short. It does not contain enough characters!"
    whiteTextMessage: "Invisible text does not count towards the limit."
    messageStyle: "width: 80%; margin: 0 auto; margin-top: 8px; margin-bottom: 8px;"
    counterBoxStyle: "float: right; margin-right:40px;"
    minCounterStyle: "color: red;"
    maxCounterStyle: "color: green;"
    warningID: "tmp_err_msg"
    warningClass: "message error"
  )
  
  # Override the limits in the configuration on a item by item basis
  if options.customLimits 
    (config.customLimits[i] = options.customLimits[i] for i of options.customLimits)
    options.customLimits = undefined
  
  # Now, override the remaining defaults
  (config[i]=options[i] for i of options)
  
  class Counter
    getEditorText: () ->
      @editorTmp.innerHTML = CKEDITOR.instances[@editorId].document.getBody().getHtml()
        .replace(/\[quote[\s\S]*?\]([\s\S])*?\[\/quote\]/gi, "")

      for quote in @editorTmp.select("blockquote")
        quote.remove()
        #text = text.replace(quote.innerHTML.stripTags()," #{quote.innerHTML.stripTags()} ")
        
      text = (i.innerHTML.stripTags() for i in @editorTmp.children).join("\n")
      
      for link in @editorTmp.select("a")
        text = text.replace(link.innerHTML.stripTags()," #{link.innerHTML.stripTags()} ")
        
      for span in @editorTmp.select("span")
        if span.hasAttribute("style")
          if span.readAttribute("style").match(new RegExp("##{@wtre}", "gi"))?
            @whiteText = true
            text = text.replace(span.innerHTML.stripTags(),"")
      
      return text
    
    getText: () ->
      ta = "#cke_contents_#{@editorId} textarea"
      if @editorId? and $$("#cke_contents_#{@editorId} iframe").length == 1
        text = @getEditorText()
      else if @editorId? and $$(ta).length == 1
        text = $$(ta)[0].getValue()
      else
        text = $(@target).getValue()
      
      wt = new RegExp("\\[color[\\s\\S]*?#(?:#{@wtre})[\\s\\S]*?\\]([\\s\\S])*?\\[\/color\\]", "gi")
      # Exclude quotes before we check for white text
      text = text.replace /\[quote[\s\S]*?\]([\s\S])*?\[\/quote\]/gi, ""
      
      if text.match(wt)?
        @whiteText = true
        
      if @whiteText
        @showWarning(@config.whiteTextMessage)
        @whiteText = false
      else
        if @warningVisible
          $(@config.warningID+@target).remove()
          @warningVisible = false
        
      text=text.replace(new RegExp(u, "gi"), "") for u in @unicode
      
      if @config.customFilters[@forum]?
        for re in @config.customFilters[@forum]
          text = text.replace re[0], re[1]
      
      text = text
        .replace(/&amp;/gi, "&")
        # Exclude special HTML characters
        .replace(/&\w{2,4};/gi, " ")
        # Exclude urls
        .replace(/\[url[\s\S]*?\]([\s\S])*?\[\/url\]/gi," $1 ")
        # Exclude all bb code tags
        .replace(/\[\/?(?:b|i|u|spoiler|code|img|sub|color|size|font|s|sup|list|twitter|xml|acronym|background|da|hr|html|br|media|member|page|php|post|prefix|sql|topic)*?.*?\]/ig, "")
        # Trim urls
        .replace(/https?:\/\/[a-z0-9\-\.]+\.[a-z]{2,3}(?:\/[-+=&;%@.,#\w_|?]+)*[^\[\.\,\)\(\s]/gi, "")
        .replace(/\S{30,}/gi, "")
        .replace(/%u[A-Za-z0-9]{4}/gi, "")
        .replace(/[^A-Za-z0-9]/gi, "")
        .strip()
      return text
    
    getCount: () ->
      return @getText().length
      
    setUnicode: () ->
      @unicode = ["\u206F","\u206E","\u206D","\u206B","\u206A",
        "\u2000", "\u2001", "\u2002", "\u2003", "\u2004", "\u2005", 
        "\u2006", "\u2007", "\u2008", "\u2009", "\u200A", "\u200B", 
        "\u200C", "\u200D", "\u200E", "\u200F", "\u202A", "\u202B", 
        "\u202C", "\u202D", "\u202E", "\u202F", "\uFFFC",
        "\u2063", "\u200B", "\u2060", "\u200C", "\u00AD",
        "\u2060", "\u200D", "\u200E", "\u2061"]
        
    setMinimum: () ->
      @minimum = parseFloat($("charmin_recommendation").innerText)
      if isNaN(@minimum)
        @minimum = 10
    
    setEditor: () ->
      @editorId = null
      @editor = null  
      if @type is 0 or @type is 1
        for instance of CKEDITOR.instances
          # Skip editors that are not the primary editor
          unless instance.match(/^editor_/)? then continue
          @editorId = instance
          @editor = CKEDITOR.instances[instance]
          break
      else
        @editorId = @target
        @editor = CKEDITOR.instances[@target]
        
      if @editor?
        tmp = "tmp#{@target}"
        $$("body")[0].insert("<div id=\"#{tmp}\" style=\"display:none;\"></div>")
        @editorTmp = $(tmp)
        @editor.on "key", () => @updateCounter()
        @editor.on "saveSnapshot", () => @updateCounter()
        @editor.getCommand('undo').on "afterUndo", () => @updateCounter()
        @editor.getCommand('redo').on "afterRedo", () => @updateCounter()
        @editor.on 'afterCommandExec', (e) =>  
          if e.data.command.canUndo != false then @updateCounter()
      else
        @editorId = null
        $(@target).observe 'keydown', () => @updateCounter()
      
    setElements: () ->
      if @type is 0
        @form = $$("#ips_fastReplyForm")[0]
        @submit = $$("#submit_post")[0]
        @alt = $$("#full_compose")[0]
        @fieldset = $$("#fast_reply_controls")[0]
      else if @type is 1
        @form = $$("#postingform")[0]
        @submit = $$(".input_submit[name=dosubmit]")[0]
        @alt = $$(".input_submit[name=preview]")[0]
        @fieldset = $$("fieldset.submit.clear")[0]
      else 
        id = @target.split("-")[1]
        @form = null
        @submit = $$("#edit_save_e#{id}")[0]
        @alt = $$("#edit_switch_e#{id}")[0]
        @fieldset = $$("#editor_e#{id} fieldset")[0]
    
    constructor: (@type,@config,@target="primary") ->
      @wtre = "FFFFFF|FFFFCC|FFFF99|FFCCFF|FFCCCC|CCFFFF|CCFFCC|CCFF99|B4CDCD|BCD2EE|C0C0C0|C6E2FF|C1CDC1|CAFF70|C1CDCD|CAE1FF|CDC5BF|CDCDB4|D3D3D3|DCDCDC|E0FFFF|CDCDC1|E6E6FA|CDC9C0|D1EEEE|E0EEE0|E0EEEE|EED5D2|EEE5DE|F0F8FF|F5F5DC|FAFAD2|EED8AE|EEE685|EEEED1|F0FFF0|F5F5F5|FDF5E6|EEDC82|EEE8AA|EEEEE0|F0FFFF|F5FFFA|EEE8CD|F8F8FF|EEDFCC|EEE0E5|EEE9BF|EEE9E9|FAEBD7|FAF0E6|FFE1FF|FFE4B5|FFE4E1|FFE7BA|FFEC8B|FFEFD5|FFEFDB|FFEBCD|FFE4C4|FFF0F5|FFF5EE|FFF68F|FFF8DC|FFFACD|FFFAF0|FFFAFA|FFFFE0|FFFFF0"
      @ipsHandler = null
      @warningVisible = false
      @whiteText = false
      @checkDisabled = false
      @counterId = "counter#{@target}"
      @setUnicode()
      
      @setMinimum()
      @setEditor()
      @setElements()
      
      @submit.counter = @
      @initializeCounter()
      
    initializeCounter: () ->
      if @editorId?
        $("cke_bottom_"+@editorId).insert(@counterTemplate())
      else
        @fieldset.insert(@counterTemplate())
        
      @counterElement = $(@counterId)
      @updateCounter()
    
    showWarning: (msg) ->
      unless @warningVisible
        @fieldset.insert
          before: @warningTemplate(msg)
        @warningVisible = true
      else
        $("wrntext#{@target}").update(msg)
        
    counterTemplate: () ->
      tmpl = """
        <div style=\"#{@config.counterBoxStyle}\" class=\"cke_path\">
          <p id=\"#{@counterId}\"></p>
        </div>"""
      return tmpl
          
    warningTemplate: (msg) ->
      tmpl = """
        <div id=\"#{@config.warningID+@target}\" style="#{@config.messageStyle}">
          <p class=\"#{@config.warningClass}\" id=\"wrntext#{@target}\">#{msg}</p>
          <br>
        </div>
        """
      return tmpl
      
    updateCounter: () ->
      timeoutSet 50, () =>
        count = @getCount()
        @counterElement.update("#{count} characters (at least #{@minimum} is recommended)")
        if count < @minimum
          @counterElement.setAttribute("style", @config.minCounterStyle)
        else
          if @warningVisible
            $(@config.warningID+@target).remove()
            @warningVisible = false
          @counterElement.setAttribute("style", @config.maxCounterStyle)
  
  if $$("#ips_fastReplyForm").length != 0
    counter = new Counter(0,config)
  else
    counter = new Counter(1,config)
  
  CKEDITOR.on "instanceReady", (e) ->
    target = e.editor.name
    counter = new Counter(2,config,target)
  
  $$(".edit_post").each (el) ->
    target = el.readAttribute("id").split("_")
    console.log target
    target = target[0] + "-" + target[2]
    active = false
    inv = null
    el.observe "click", (e) =>
      createCounter = (fails, wait) =>
        if fails >= 10
          return false
        if CKEDITOR?
          if not CKEDITOR.instances[target]?
            timeoutSet wait, () -> createCounter(fails+1, wait*2)
          else
            counter = new Counter(2,config,target)
        else
          counter = new Counter(2,config,target)
      createCounter(0, 500)