window.startCharCounter = (options={}) ->
  timeoutSet = (tm, fnc) -> setTimeout fnc, tm
  if $$(".ipsEditor_textarea.input_text").length == 0 then return false
  if $$("#msgForm").length != 0 then return false
  
  # Default configuration options
  config = (
    defaultLimit: 100
    customLimits:
      "17":0 # Moderation discussion
      "54":0 # Staff discussion
      "28":0 # March 2012 Survey
      "8":0 # Colosseum
      "7": 10 # Feedback 
      "43":0 # Forum Games
      "44":0 # Ask a Pony
      "46":0 # General Silliness
      "22":200 # Roleplays
      "38":200 # Life Advice
      "23":75 # OOC
      "55": 800 # Advanced RP games
      "49": 0 # Commissions
      "2": 50 # Welcome area
    message: "Your post is too short. It does not contain enough characters!"
    whiteTextMessage: "Invisible text does not count towards the limit."
  )
  
  # Override the limits in the configuration on a item by item basis
  if options.customLimits 
    (config.customLimits[i] = options.customLimits[i] for i of options.customLimits)
    options.customLimits = undefined
  
  # Now, override the remaining defaults
  (config[i]=options[i] for i of options)
  
  class Counter
    getText: () ->
      # Exclude quotes before we check for anything else
      text = @el.getValue()
        .replace(/\[quote[\s\S]*?\]([\s\S])*?\[\/quote\]/gi,"")
      
      wt = /\[color[\s\S]*?#(?:FFFFFF|FFFFCC|FFFF99|FFCCFF|FFCCCC|CCFFFF|CCFFCC|CCFF99|B4CDCD|BCD2EE|C0C0C0|C6E2FF|C1CDC1|CAFF70|C1CDCD|CAE1FF|CDC5BF|CDCDB4|D3D3D3|DCDCDC|E0FFFF|CDCDC1|E6E6FA|CDC9C0|D1EEEE|E0EEE0|E0EEEE|EED5D2|EEE5DE|F0F8FF|F5F5DC|FAFAD2|EED8AE|EEE685|EEEED1|F0FFF0|F5F5F5|FDF5E6|EEDC82|EEE8AA|EEEEE0|F0FFFF|F5FFFA|EEE8CD|F8F8FF|EEDFCC|EEE0E5|EEE9BF|EEE9E9|FAEBD7|FAF0E6|FFE1FF|FFE4B5|FFE4E1|FFE7BA|FFEC8B|FFEFD5|FFEFDB|FFEBCD|FFE4C4|FFF0F5|FFF5EE|FFF68F|FFF8DC|FFFACD|FFFAF0|FFFAFA|FFFFE0|FFFFF0)[\s\S]*?\]([\s\S])*?\[\/color\]/gi
      if text.match(wt)?
        @whiteText = true
      else
        @whiteText = false
        
      text=text.replace(new RegExp(u, "gi"), "") for u in @unicode
      
      text = text
        .replace(/&amp;/gi, "&")
        # Exclude special HTML characters
        .replace(/&\w{2,4};/gi, " ")
        # Exclude urls
        .replace(/\[url[\s\S]*?\]([\s\S])*?\[\/url\]/gi," $1 ")
        # Exclude all bb code tags
        .replace(/\[\/?(?:b|i|u|spoiler|code|img|sub|color|size|font|s|sup|list|twitter|xml|acronym|background|da|hr|html|br|media|member|page|php|post|prefix|sql|topic)*?.*?\]/ig, "")
        # Trim urls
        .replace(/https?:\/\/[a-z0-9\-\.]+\.[a-z]{2,3}(?:\/[-+=&;%@.,#\w_|?]+)*[^\[\.\,\)\(\s]/gi, "")
        .replace(/\S{30,}/gi, "")
        .replace(/%u[A-Za-z0-9]{4}/gi, "")
        .replace(/[^A-Za-z0-9]/gi, "")
        .strip()
      return text
    
    getCount: () ->
      return @getText().length
      
    setUnicode: () ->
      @unicode = ["\u206F","\u206E","\u206D","\u206B","\u206A",
        "\u2000", "\u2001", "\u2002", "\u2003", "\u2004", "\u2005", 
        "\u2006", "\u2007", "\u2008", "\u2009", "\u200A", "\u200B", 
        "\u200C", "\u200D", "\u200E", "\u200F", "\u202A", "\u202B", 
        "\u202C", "\u202D", "\u202E", "\u202F", "\uFFFC",
        "\u2063", "\u200B", "\u2060", "\u200C", "\u00AD",
        "\u2060", "\u200D", "\u200E", "\u2061"]
        
    setMinimum: () ->
      url = $$("#secondary_navigation a")[0].readAttribute("href")
      @forum = url.split("-")[0].split("/").splice(-1,1)[0]
      @minimum = if @config.customLimits[@forum]? then @config.customLimits[@forum] else @config.defaultLimit
    
    setEditor: () ->
      @el.observe 'keydown', () => @updateCounter()
      
    setElements: () ->
      @el = $$(".ipsEditor_textarea.input_text").splice(-1,1)[0]
      @form = $$("form").splice(-1,1)[0]
      if @type is 0
        @submit = $$(".button[name=dosubmit]").splice(-1,1)[0]
        @messageTarget = @form
      else if @type is 1
        @submit = $$(".button[name=submit]").splice(-1,1)[0]
        @messageTarget = $$(".row").splice(-1,1)[0]
        
    constructor: (@type,@config,@target="primary") ->
      @messageVisible = false
      @whiteText = false
      @counterId = "counter#{@target}"
      @setUnicode()
      
      @setMinimum()
      @setElements()
      @setEditor()
      @submit.counter = @
      @updateCounter()
    
    showMessage: (msg, warn=false) ->
      unless @messageVisible
        @messageTarget.insert
          before: @messageTemplate(msg)
        @messageVisible = true
      w = $("wrntext#{@target}")
      w.update(msg)
      if warn then w.addClassName("error") else w.removeClassName("error")
          
    messageTemplate: (msg) ->
      tmpl = """
          <p class=\"message\" id=\"wrntext#{@target}\">#{msg}</p>
        """
      return tmpl
      
    updateCounter: () ->
      timeoutSet 30, () =>
        count = @getCount()
        msg = "#{count} characters (#{@minimum} is the minimum)"
        if count < @minimum
          if @whiteText
            @showMessage("#{msg}<br>#{@config.whiteTextMessage}", true)
          else
            @showMessage(msg, true)
        else
          @showMessage(msg, false)
  
  if $$(".button[name=dosubmit]").length != 0 # Full reply
    counter = new Counter(0,config)
  else # Fast response
    counter = new Counter(1,config)