﻿Imports System.Runtime.InteropServices

Module DetectFulLScreen_m

    'Converted to vb.net from http://www.richard-banks.org/2007/09/how-to-detect-if-another-application-is.html 

    Structure RECT
        Dim Left As Integer
        Dim Top As Integer
        Dim Right As Integer
        Dim Bottom As Integer
    End Structure

    <DllImport("user32.dll")> _
    Friend Function GetForegroundWindow() As IntPtr
    End Function
    <DllImport("user32.dll")> _
    Friend Function GetDesktopWindow() As IntPtr
    End Function
    <DllImport("user32.dll")> _
    Friend Function GetShellWindow() As IntPtr
    End Function
    <DllImport("user32.dll", SetLastError:=True)> _
    Friend Function GetWindowRect(hwnd As IntPtr, ByRef rc As RECT) As Integer
    End Function

    Friend Function DetectFullScreenApp() As Boolean

   
        'Detect if the current app is running in full screen
        Dim appBounds As RECT
        Dim screenBounds As Rectangle
        Dim hWnd As IntPtr

        'get the dimensions of the active window
        hWnd = GetForegroundWindow()

        For Each ponyform As PonyGraphicsForm In My.Forms.Main.PonyForms
            If ponyform.Handle = hWnd Then
                Return False
            End If
        Next

        If Not IsNothing(hWnd) AndAlso Not hWnd.Equals(IntPtr.Zero) Then
            'Check we haven't picked up the desktop or the shell
            If Not (hWnd.Equals(My.Forms.Main.DesktopHandle) OrElse hWnd.Equals(My.Forms.Main.ShellHandle)) Then
                GetWindowRect(hWnd, appBounds)
                'determine if window is fullscreen
                screenBounds = Screen.FromHandle(hWnd).Bounds
                If (appBounds.Bottom - appBounds.Top) = screenBounds.Height AndAlso (appBounds.Right - appBounds.Left) = screenBounds.Width Then
                    Return True
                End If
            End If
        End If

        Return False

    End Function

End Module
