﻿Public Class HouseOptions_Form

    Dim house As Pony.House
  
    Dim house_image As Image
    Dim graphics As Graphics

    Dim door_point As New Point()


    Private Sub Image_Centers_Form_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Me.Text = house.name & " Options"

        House_ImageBox.Image = New Bitmap(House_ImageBox.Width, House_ImageBox.Height)

        graphics = graphics.FromImage(House_ImageBox.Image)

        Redraw_Marker()

    End Sub


    Sub Redraw_Marker()
        If Not IsNothing(graphics) Then

            graphics.Clear(Color.Black)

            graphics.DrawImage(house_image, New Point(0, 0))

            
            graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                      New Point(door_point.X - 5, door_point.Y - 5), _
                                      New Point(door_point.X + 5, door_point.Y + 5))
            graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                       New Point(door_point.X + 5, door_point.Y - 5), _
                                       New Point(door_point.X - 5, door_point.Y + 5))

        House_ImageBox.Invalidate()

            DoorPoint_Label.Text = door_point.ToString()
  
        End If
    End Sub

    Private Sub Left_ImageBox_Click(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles House_ImageBox.Click

        door_point = e.Location
        Redraw_Marker()

    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Save_Settings() = False Then Exit Sub

        Me.Close()
    End Sub


    Friend Sub EditHouse(_house As Pony.House)

        house = _house
        door_point = _house.Door
        Cycle_Counter.Value = _house.timer

        Try
            house_image = Image.FromFile(_house.left_image_path)
        Catch ex As Exception
            MsgBox("Couldn't open file: " & _house.left_image_path)
            Exit Sub
        End Try

        Visitors_CheckedListBox.Items.Clear()
        For Each SelectablePony In My.Forms.Main.Selectable_Ponies
            Visitors_CheckedListBox.Items.Add(SelectablePony.Name)
        Next

        Dim ponies_to_check As New List(Of Integer)

        For Each Pony In _house.visitors

            Dim index = 0

            If LCase(Pony) = "all" Then

                For i = 0 To Visitors_CheckedListBox.Items.Count - 1
                    Visitors_CheckedListBox.SetItemChecked(i, True)
                Next

                Exit For

            End If

            For Each item In Visitors_CheckedListBox.Items

                If LCase(item) = LCase(Pony) Then
                    ponies_to_check.Add(index)
                End If
                index += 1
            Next

        Next

        For Each index In ponies_to_check
            Visitors_CheckedListBox.SetItemChecked(index, True)
        Next

        Me.ShowDialog()

    End Sub


    Function Save_Settings() As Boolean

        house.timer = Cycle_Counter.Value
        house.Door = door_point

        If Visitors_CheckedListBox.CheckedItems.Count = 0 Then
            MsgBox("You must select at least one visitor!")
            Return False
        End If

        house.visitors.Clear()

        For Each entry In Visitors_CheckedListBox.CheckedItems

            house.visitors.Add(entry)

        Next

        Return True

    End Function

    Private Sub Save_Button_Click(sender As System.Object, e As System.EventArgs) Handles Save_Button.Click

        If Save_Settings() = False Then Exit Sub

        Try

            Dim comments As New List(Of String)
            Dim ini_file_path = house.File_path & System.IO.Path.DirectorySeparatorChar & "house.ini"
            If My.Computer.FileSystem.FileExists(ini_file_path) Then
                Dim existing_ini As New System.IO.StreamReader(ini_file_path)

                Do Until existing_ini.EndOfStream
                    Dim line = existing_ini.ReadLine()
                    If Mid(line, 1, 1) = "'" Then
                        comments.Add(line)
                    End If
                    line = Nothing
                Loop
                existing_ini.Close()
            End If

            Dim new_ini As New System.IO.StreamWriter(ini_file_path, False, System.Text.Encoding.UTF8)

            For Each line In comments
                new_ini.WriteLine(line)
            Next

            new_ini.WriteLine("name," & house.name)

            Dim cma = ","

            new_ini.WriteLine("image," & house.ImageFileName)

            new_ini.WriteLine("door," & house.Door.X & cma & house.Door.Y)

            new_ini.WriteLine("cycletime," & house.timer)

            For Each entry In house.visitors
                new_ini.WriteLine(entry)
            Next

            new_ini.Close()


        Catch ex As Exception
            MsgBox("Unable to save house file! Details: " & ControlChars.NewLine & ex.Message)
            Exit Sub
        End Try

        MsgBox("Save completed!")


    End Sub

    Private Sub ClearVisitors_Button_Click(sender As System.Object, e As System.EventArgs) Handles ClearVisitors_Button.Click

        If Visitors_CheckedListBox.Items.Count = 0 Then Exit Sub

        Dim status = Visitors_CheckedListBox.CheckedItems.Count <> 0

        For i = 0 To Visitors_CheckedListBox.Items.Count - 1
            Visitors_CheckedListBox.SetItemChecked(i, Not status)
        Next

    End Sub

    Private Sub Cancel_Button_Click(sender As System.Object, e As System.EventArgs) Handles Cancel_Button.Click
        Me.Close()
    End Sub
End Class