﻿'This is the Main form that handles startup and pony selection.


Public Class Main

    'record our own PID, needed for window detection.
    Friend process_id = 0

    Friend DesktopHandle As IntPtr
    Friend ShellHandle As IntPtr

    Dim Suspended_For_FullScreenApp As Boolean = False

    'All ponies are drawn on this main form.
    Friend PonyForms As New List(Of PonyGraphicsForm)

    'The list of displayed ponies.
    Friend Active_Ponies As New List(Of Pony)
    'list all ponies that show up in the menu.
    '"Active" ponies are cloned (.duplicate()) from these master copies.
    Friend Selectable_Ponies As New List(Of Pony)

    'A list of all currently active (displayed) effects for all ponies.
    'Each pony keeps a separate list of their active effects.
    Friend Active_Effects As New List(Of Pony.Behavior.effect)
    Friend Dead_Effects As New List(Of Pony.Behavior.effect)

    Friend Active_Sounds As New List(Of Object)

    'Houses are effects that ponies can "enter" or "leave" (dissapear on or start at)
    'This is a prop to allow the cycling of ponies on a timer.
    Friend Houses As New List(Of Pony.House)

    ' Friend Install_Location As String = System.AppDomain.CurrentDomain.BaseDirectory
    Friend Install_Location As String = System.IO.Path.GetDirectoryName(Application.ExecutablePath)

    'Variables used for displaying the pony selection menu
    Dim Last_Pony_Picture As PictureBox
    Dim Total_Picture_Height = 0
    Dim Last_X_Pos = 0
    Friend Tallest_Pony = 0

    'How big the area around the cursor used for cursor detection should be, in pixels.
    Friend cursor_zone_size As Integer = 100

    Friend PonyScale As Double = 1

    'A list of monitors the user has selected to use, from the options screen.
    Friend screens_to_use As New List(Of System.Windows.Forms.Screen)

    'The options form is loaded and ready.
    Friend Options_Is_Created = False

    'Are ponies currenly walking around the desktop?
    Friend Ponies_Have_Launched As Boolean = False

    'Does any pony have its right click menu open?
    Friend Right_Click_Menu_Active As Boolean = False

    'Is any pony being dragged by the mouse?
    Friend Dragging As Boolean = False

    Friend Audio_Last_Played As DateTime = Now()
    Friend Last_Audio_Length As Integer = 0 'milliseconds

    Friend controlled_pony = ""

    'Used in the editor.
    Friend Preview_Mode As Boolean = False

    'Were we told to auto-start from the command line?
    Friend auto_started As Boolean = False

    Friend screen_saver_mode As Boolean = False
    Friend screen_saver_path As String = ""
    Dim screensaver_settings_file_path As String = System.IO.Path.GetTempPath & System.IO.Path.DirectorySeparatorChar & "DesktopPonies_ScreenSaver_Settings.ini"

    'used to tell when we should come out of screensaver mode
    Dim cursor_position As New Point

    Friend games As New List(Of Object)
    Friend current_game As Game = Nothing

    'the following are used when in manual control mode
    Friend PonyUp As Boolean = False
    Friend PonyDown As Boolean = False
    Friend PonyLeft As Boolean = False
    Friend PonyRight As Boolean = False
    Friend PonySpeed As Boolean = False 'shift key is being pressed, so go faster.
    Friend PonyAction As Boolean = False

    'Keys for player 2
    Friend PonyUp_2 As Boolean = False
    Friend PonyDown_2 As Boolean = False
    Friend PonyLeft_2 As Boolean = False
    Friend PonyRight_2 As Boolean = False
    Friend PonySpeed_2 As Boolean = False 'shift key is being pressed, so go faster.
    Friend PonyAction_2 As Boolean = False

    ' Counters for keeping track of frame times, and total time.
    Friend frameTimesInMs As Integer() = New Integer(29) {}
    Friend frameTimesMarker As Integer = 0
    Friend loopStartTime As DateTime
    Friend loopEndTime As DateTime
    Friend formStartTime As DateTime
    Friend totalElaspedTime As TimeSpan

    Friend NoRandomDuplicates_Option As New CheckBox

    Friend DisableSoundsDueToDirectXFailure As Boolean = False

    Friend PonyComparer_Height As New Pony.PonyComparer_ScreenHeight
    Friend PonyComparer_Name As New Pony.PonyComparer_Name

    Dim all_sleeping As Boolean = False

    Friend Audio_Error_Shown As Boolean = False

    Friend manager As ImageManager = New ImageManager(True, True, True)

    Dim PonySearchIndex As New List(Of String)

    'XP doesn't support transparency as easily as windows 7 does.  
    'We have to use a bit of a hack to get it to work on older OS versions.
    'We detect the OS version on startup.
    Friend OS_Is_Old As Boolean = False

    'A temporary list of selected filter settings.
    Dim Temp_Filters As New List(Of String)

    Dim TimeTrack_Start As DateTime

    Enum behavior_options

        name = 1
        probability = 2
        max_duration = 3
        min_duration = 4
        speed = 5 'specified in pixels per tick of the timer
        right_image_path = 6
        left_image_path = 7
        movement_type = 8
        linked_behavior = 9
        speaking_start = 10
        speaking_end = 11
        skip = 12 'Should we skip this behavior when considering ones to randomly choose (part of an interaction/chain?)
        xcoord = 13  'used when following/moving to a point on the screen.
        ycoord = 14
        object_to_follow = 15
        auto_select_images = 16
        follow_stopped_behavior = 17
        follow_moving_behavior = 18
        right_image_center = 19
        left_image_center = 20
        dont_repeat_image_animations = 21
        group = 22

    End Enum


    Private Sub Go_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Go_Button.Click

#If Not Debug Then
        Try
#End If

        Dim number_of_ponies As New List(Of Integer)
        Dim pony_names As New List(Of String)

        Dim Total_Ponies As Integer = 0

        Dim random_ponies As Integer = 0

        'Go through each of the textboxes in the menu and record their names and the number of them wanted.

        For Each PonyPanel In SplitContainer1.Panel1.Controls
            If PonyPanel.GetType Is GetType(Panel) Then

                Dim textbox As TextBox = Nothing
                Dim label As Label = Nothing

                For Each Control In PonyPanel.Controls

                    If Control.GetType Is GetType(Label) Then
                        If Control.Text <> "How many?" Then
                            label = Control
                        End If
                    End If

                    If Control.GetType Is GetType(TextBox) Then
                        textbox = Control
                    End If
                Next

                Try
                    If IsNumeric(textbox.Text) AndAlso CInt(textbox.Text) > 0 Then
                        If label.Text = "Random Pony" Then
                            random_ponies = textbox.Text
                        End If

                        pony_names.Add(label.Text)
                        number_of_ponies.Add(textbox.Text)
                        Total_Ponies += textbox.Text
                    Else
                        pony_names.Add(label.Text)
                        number_of_ponies.Add(0)
                    End If
                Catch ex As Exception
                    MsgBox("Error: Too much pony!" & ControlChars.NewLine & _
                           "Details: You entered something crazy in one of the boxes." & ControlChars.NewLine & _
                           "Real Details: " & ex.Message)
                    Exit Sub
                End Try

            End If
        Next

        If Total_Ponies = 0 Then
            If screen_saver_mode Then
                Total_Ponies = 1
                random_ponies = 1
            Else
                MsgBox("The total is... no ponies...  That's TOO FEW PONY.")
                Exit Sub
            End If
        End If

        If Total_Ponies > My.Forms.Options.Max_Pony_Counter.Value Then
            MsgBox("Sorry, you selected " & Total_Ponies & " ponies, which is more than the limit specified in the options menu." & ControlChars.NewLine & _
                   "Try less than " & My.Forms.Options.Max_Pony_Counter.Value & " total." & ControlChars.NewLine & _
                   "(Or override this limit in the options window)")
            Exit Sub
        End If

        ProgressBar.Value = 0
        ProgressBar.Maximum = Total_Ponies

        'If Total_Ponies > 100 Then
        '    MsgBox(Total_Ponies & " ponies!?!  I hope you can handle that much pony!  Here we go...")
        'End If


        'Make duplicates of each type of pony, up to the number needed
        For i = 0 To number_of_ponies.Count - 1
            If number_of_ponies(i) > 0 Then

                Dim pony_template = FindPonyByName(pony_names(i))

                If pony_template.Name = "Random Pony" Then
                    Continue For
                End If

                For z = 1 To number_of_ponies(i)
                    Dim new_pony As Pony = pony_template.Duplicate()
                    ProgressBar.Increment(1)
                    Application.DoEvents()
                    Active_Ponies.Add(new_pony)
                Next
            End If
        Next

        'Select random ponies, if necessary
        For i = 1 To random_ponies
            Dim selection = Math.Round(Rnd() * (Selectable_Ponies.Count - 1), 0)

            Dim selected_pony = Selectable_Ponies(selection)

            If Not IsNothing(NoRandomDuplicates_Option) AndAlso NoRandomDuplicates_Option.Checked = True Then

                Dim duplicate As Boolean = False
                Dim still_unique_available As Boolean = False

                For Each Pony In Active_Ponies
                    If Pony.Name = selected_pony.Name Then
                        duplicate = True
                    End If

                    If Active_Ponies.Count + 1 >= Selectable_Ponies.Count Then
                        still_unique_available = False
                    Else
                        still_unique_available = True
                    End If

                    If duplicate AndAlso Not still_unique_available Then Exit For
                Next

                If duplicate AndAlso still_unique_available Then
                    i -= 1
                    Continue For
                End If
            End If


            If selected_pony.Name = "Random Pony" Then
                i -= 1
            Else
                Active_Ponies.Add(Selectable_Ponies(selection).Duplicate)
                ProgressBar.Increment(1)
                Application.DoEvents()
            End If
          
        Next

        Try
            If My.Forms.Options.Interactions_Enabled.Checked Then
                Initialize_Interactions()
            End If
        Catch ex As Exception
            MsgBox("Unable to initialize interactions.  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
        End Try

        Pony_Startup()


#If Not Debug Then


        Catch ex As Exception
            MoveTimer.Stop()
            MsgBox("Error launching ponies... Details: " & ex.Message & ControlChars.NewLine _
                   & ex.StackTrace)
            Me.Close()
        End Try

#End If

    End Sub

    Private Function FindPonyByName(ByVal name As String) As Pony

        For Each Pony As Pony In Selectable_Ponies
            If Pony.Name = name Then
                Return Pony
            End If
        Next

        Throw New Exception("Couldn't find pony by name: " & name)
    End Function

    Friend Sub Pony_Startup()

        'In case the cursor size wasn't set by the options menu, set it to something based on the screen size.
        If cursor_zone_size = Nothing Then
            For Each monitor In Screen.AllScreens
                cursor_zone_size = 0.03 * monitor.WorkingArea.Height
                Exit For
            Next
        End If

        'This should already be set in the options, but in case it isn't, use all monitors.
        If screens_to_use.Count = 0 Then
            For Each monitor In Screen.AllScreens
                screens_to_use.Add(monitor)
                cursor_zone_size = 0.03 * monitor.WorkingArea.Height
            Next
        End If

        'Hide the menu form.
        Me.Visible = False
        Temp_Save_Counts()
        Dispose_Menu()


        Dim monitorcount As Integer = 0
        For Each monitor In Screen.AllScreens
            Dim PonyForm = New PonyGraphicsForm(manager, monitor, monitorcount)
            monitorcount += 1
            PonyForm.setup_addpony_menu()
            PonyForm.Screen = monitor

            'all ponies should be topmost when the editor is running
            If Preview_Mode = True Then
                PonyForm.TopMost = True
            Else
                PonyForm.TopMost = My.Forms.Options.PoniesAlwaysOnTop_Checkbox.Checked
            End If

            PonyForms.Add(PonyForm)
        Next

        'The main timer which causes all pony movement.
        MoveTimer.Enabled = True
        MoveTimer.Start()

        ''Cleans up unused memory every few seconds
        ''This is needed as the automatic garbage collecter
        ''doesn't do a good job of cleaning up unused images
        ''Disable this, and watch the memory use skyrocket!
        CleanupTimer.Enabled = True
        CleanupTimer.Start()

        If screen_saver_mode Then

            If My.Forms.Options.Screensaver_Transparent_Checkbox.Checked = False Then

                For Each monitor In Screen.AllScreens

                    Dim screensaver_background As New Screensaver_Background_Form

                    screensaver_background.Show()

                    If IsNothing(My.Forms.Options.ScreenSaverBackgroundColor) Then
                        screensaver_background.BackColor = Color.Black
                    Else
                        screensaver_background.BackColor = My.Forms.Options.ScreenSaverBackgroundColor
                    End If

                    If My.Forms.Options.ScreenSaverBackgroundImagePath <> "" AndAlso My.Forms.Options.Screensaver_use_bgimage_checkbox.Checked Then
                        Try
                            screensaver_background.BackgroundImage = Image.FromFile(My.Forms.Options.ScreenSaverBackgroundImagePath)
                        Catch ex As Exception
                            'could not load the image
                        End Try
                    End If

                    screensaver_background.Size = monitor.Bounds.Size
                    screensaver_background.Location = New Point(monitor.Bounds.X, monitor.Bounds.Y)
                Next

            End If

            Cursor.Hide()

        End If


        Ponies_Have_Launched = True

    End Sub

    Friend Sub Pony_Shutdown(ClearActive As Boolean)

        MoveTimer.Stop()
        MoveTimer.Enabled = False
        Ponies_Have_Launched = False

    
        If ClearActive Then
            For Each pony As Pony In Active_Ponies
                For Each behavior As Pony.Behavior In pony.Behaviors
                    behavior.UnloadImages()
                    For Each effect As Pony.Behavior.effect In behavior.Effects
                        effect.UnloadImages()
                    Next
                Next
            Next
            Active_Ponies.Clear()
        Else
            'Set each pony to reset the graphics when they next start up again.
            For Each Pony In Active_Ponies
                If Not IsNothing(Pony.current_behavior) Then
                    Pony.current_behavior.CS_choseNewBehaviour = True
                End If
            Next
        End If

        If ClearActive Then
            For Each effect In Active_Effects
                effect.UnloadImages()
            Next
        End If

        Active_Effects.Clear()

        If Not IsNothing(current_game) Then
            current_game.CleanUp()
            current_game = Nothing
        End If

        For Each PonyForm In PonyForms
            PonyForm.Close()
        Next

        For Each House In Houses
            House.Instances.Clear()
            House.Active = False
        Next

        PonyForms.Clear()

    End Sub

    'If we are set to auto-start in the command line, try to hide the menu as soon as possible.
    Private Sub Main_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.VisibleChanged
        If Not auto_started Then
            Me.Opacity = 100
        End If
    End Sub

    'Read all configuration files and pony folders.
    Private Sub Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

#If Not Debug Then
          Try
#End If

        Me.Opacity = 0

        Me.Icon = My.Resources.Twilight

        'Try to determine our dependancies and if all are available on this system.
        'Primarily to check to see if the right version of directx is installed for sounds.
        Dim self As System.Reflection.Assembly = System.Reflection.Assembly.GetEntryAssembly()

        For Each dependency As System.Reflection.AssemblyName In self.GetReferencedAssemblies()

            If InStr(dependency.ToString, "DirectX") <> 0 Then
                Try
                    System.Reflection.Assembly.Load(dependency)
                Catch ex As Exception
                    DisableSoundsDueToDirectXFailure = True
                End Try
            End If
        Next


        DesktopHandle = DetectFulLScreen_m.GetDesktopWindow()
        ShellHandle = DetectFulLScreen_m.GetShellWindow()

        'Unfortunately, some things like tooltips and windows graphics can cause exceptions that are not
        'handled in any try() block.  Catch these and try to show a helpful message to the user.

#If Not Debug Then
             AddHandler AppDomain.CurrentDomain.UnhandledException, AddressOf Unhandled_Exception_Catch
            AddHandler Application.ThreadException, AddressOf ThreadException_Catch
#End If


        'need our own PID for window avoidance (ignoring collisions with other ponies)
        process_id = System.Diagnostics.Process.GetCurrentProcess().Id

        'Fix errors for cultures that don't use , as separator (russian, others).
        Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture

        'We use an alternate graphics method anything older then Vista (XP in particular).
        If CDbl(My.Computer.Info.OSVersion.Substring(0, 3)) < 6 Then
            OS_Is_Old = True
        End If

        Active_Ponies.Clear()
        Active_Effects.Clear()
        Selectable_Ponies.Clear()
        SplitContainer1.Panel1.Controls.Clear()

        GC.Collect()

        Try

            'If we don't do this, our "random" numbers will be the same ones every time!
            Randomize()

            Dim Arguments = My.Application.CommandLineArgs

            If Arguments.Count = 0 Then

                If Environment.GetCommandLineArgs()(0).EndsWith(".scr") Then
                    'for some versions of windows, starting with no parameters is the same as /c (configure)
                    Set_ScreenSaver_Path()
                    Me.Close()
                    Exit Sub
                End If

                Exit Try
            End If

            'handle any comment line arguments
            If Arguments.Count > 0 Then
                Select Case Split(LCase(Trim(Arguments(0))), ":")(0)
                    Case "autostart"
                        auto_started = True
                        Me.ShowInTaskbar = False
                        My.Forms.Options.ShowInTaskbar = False

                        'windows is telling us "start as a screensaver"
                    Case "/s"
                        Get_ScreenSaver_Path()
                        If screen_saver_path = "" Then Me.Close()
                        Install_Location = screen_saver_path
                        screen_saver_mode = True
                        auto_started = True
                        Me.ShowInTaskbar = False
                        My.Forms.Options.ShowInTaskbar = False

                        'windows says: "preview screensaver".  This isn't implemented so just quit
                    Case "/p"
                        Me.Close()
                        Exit Sub
                        'windows says:  "configure screensaver"
                    Case "/c"
                        Set_ScreenSaver_Path()
                        Me.Close()
                        Exit Sub
                    Case Else
                        MsgBox("Invalid command line argument.  Useage: " & ControlChars.NewLine & _
                               "desktop ponies.exe autostart - Automatically start with saved settings (or defaults if no settings are saved)" & ControlChars.NewLine & _
                               "desktop ponies.exe /s - Start in screensaver mode (you need to run /c first to configure the path to the pony files)" & ControlChars.NewLine & _
                               "desktop ponies.exe /c - Configure the path to pony files, only used for ScreenSaver mode." & ControlChars.NewLine & _
                               "desktop ponies.exe /p - Screensaver preview use only.  Not implemented.")
                        Me.Close()
                        Exit Sub
                End Select
            End If

        Catch ex As Exception
            MsgBox("Error processing command line arguments." & ControlChars.NewLine & ex.Message & ControlChars.NewLine & ex.StackTrace)
        End Try

        If auto_started = True Then
            Me.Opacity = 0
        Else
            Me.Opacity = 100
        End If

        'temporarily save filter selections, if any, in the case that we are reloading after making a change in the editor.
        '(Loading options resets the filter, and will cause havok otherwise)
        SaveFilterSelections()

        'the options form is needed now as the preferences are read directly from the controls on that form.
        'we load it invisibly here
        My.Forms.Options.Opacity = 0
        My.Forms.Options.Show()
        My.Forms.Options.Visible = False

        'load the settings from the settings file, if it exists
        My.Forms.Options.Load_Button_Click(Nothing, Nothing, True)

        LoadFilterSelections()

        My.Forms.Options.Opacity = 100

        Dim Install_Folder = My.Computer.FileSystem.GetDirectories(Install_Location)

        Dim skip_loading_errors As Boolean = False

        Dim Ponies_to_add As New List(Of Pony)

        For Each folder In Install_Folder

            Dim fail = False

            If InStr(LCase(folder), "game_") <> 0 Then
                Continue For
            End If

            If InStr(LCase(folder), "house_") <> 0 Then
                skip_loading_errors = load_house(folder, skip_loading_errors)
                Continue For
            End If

            'some languages don't use \ as a separator between folders
            Dim config_file_name = folder & System.IO.Path.DirectorySeparatorChar & "pony.ini"
            Dim config_file As System.IO.StreamReader
            Try
                config_file = New System.IO.StreamReader(config_file_name)
            Catch ex As Exception
                If skip_loading_errors = False Then
                    Select Case MsgBox("Error: No pony.ini configuration file found for folder: " & folder _
                       & ControlChars.NewLine & "Won't load this pony..." & ControlChars.NewLine _
                       & "Do you want to skip seeing these errors?  Press No to see the error for each pony.  Press cancel to quit.", MsgBoxStyle.YesNoCancel)

                        Case DialogResult.Yes
                            skip_loading_errors = True
                        Case DialogResult.No
                            'do nothing
                        Case DialogResult.Cancel
                            Me.Close()

                    End Select
                End If

                Continue For
            End Try

            Dim PonyName = ""
            Dim PonyLines As New List(Of Pony.Behavior.Speaking_Line)
            Dim Tags As New List(Of String)
            Dim BehaviorGroups As New List(Of Pony.BehaviorGroup)
            Dim Behaviors As New List(Of String)
            Dim Effects As New List(Of String)
            Dim Scale As Double = 0

            Do Until config_file.EndOfStream

                Dim line = config_file.ReadLine

                'ignore blank or 'commented out' lines.
                If line = "" OrElse line(0) = "'" Then
                    Continue Do
                End If

                'SplitWithQualifiers is an improved split() that lets use use, as the name says, text qualifiers.
                'This lets you embed two different lists of items, or handle names that contain commas.

                Dim columns = SplitWithQualifiers(line, ",", ControlChars.Quote, ControlChars.Quote, "{", "}")

                If UBound(columns) < 1 Then
                    Continue Do
                End If

                Select Case LCase(columns(0))

                    Case "name"
                        PonyName = columns(1)
                    Case "scale"
                        Scale = columns(1)
                    Case "behaviorgroup"
                        BehaviorGroups.Add(New Pony.BehaviorGroup(columns(2), columns(1)))
                    Case "behavior"
                        Behaviors.Add(line)
                    Case "categories"

                        For Each category In columns

                            Dim tag = LCase(category)

                            If tag = "categories" Then Continue For

                            Dim match_found = False

                            For Each item In PonyFilter_Box.Items
                                If LCase(item) = tag Then
                                    Tags.Add(tag)
                                    match_found = True
                                    Exit For
                                End If
                            Next

                            If match_found = False AndAlso auto_started = False Then
                                '   MsgBox("Warning: Pony " & PonyName & " has an unknown category in their INI file: " & category)
                            End If
                        Next

                    Case "speak"

                        'Speak options can be in THREE forms:
                        '1 line text
                        'OR
                        '1 line name
                        '2 line text
                        '3 line sound file 
                        '4 skip for normal use (used for chains or interactions)
                        'OR
                        '1 line name
                        '2 line text
                        '3 {}'d list of sound files (the first one that works is used - this is to support other ports, like 'Browser Ponies' 
                        '4 skip for normal use (used for chains or interactions)


                        Try

                            Select Case UBound(columns)


                                Case 1
                                    PonyLines.Add(New Pony.Behavior.Speaking_Line(PonyName, "Unnamed", _
                                                       Replace(columns(1), ControlChars.Quote, ""), "", "", False, 0))

                                Case Is >= 4

                                    Dim sound_files_list_column = Replace(Replace(columns(3), "{", ""), "}", "")

                                    Dim sound_files_list = SplitWithQualifiers(sound_files_list_column, ",", ControlChars.Quote)

                                    Dim group As Integer = 0

                                    If UBound(columns) = 5 Then
                                        group = columns(5)
                                    End If

                                    If UBound(sound_files_list) > 0 Then
                                        Dim found_sound = False
                                        For Each soundfile_path In sound_files_list
                                            If My.Computer.FileSystem.FileExists(folder & System.IO.Path.DirectorySeparatorChar & soundfile_path) Then

                                                PonyLines.Add(New Pony.Behavior.Speaking_Line(PonyName, Trim(columns(1)), _
                                                                            Replace(columns(2), ControlChars.Quote, ""), folder & System.IO.Path.DirectorySeparatorChar, Replace(Trim(soundfile_path), _
                                                                          ControlChars.Quote, ""), _
                                                                          Trim(columns(4)), group))
                                                found_sound = True
                                                Exit For
                                            End If
                                        Next

                                        If found_sound = False Then
                                            Throw New Exception("None of the listed sound files could be found.")
                                        End If
                                    Else
                                        PonyLines.Add(New Pony.Behavior.Speaking_Line(PonyName, columns(1), _
                                                             Replace(columns(2), ControlChars.Quote, ""), "", "", Trim(columns(4)), group))
                                    End If

                                Case Else
                                    MsgBox("Invalid 'speak' line in pony.ini file for pony named " & PonyName & ":" & ControlChars.NewLine _
                                                                 & line & ControlChars.NewLine & _
                                                                 "Line must contain a name for the entry, the text to be displayed, optional: soundfile, true if entry is for a specific behavior and should be skipped normally")
                            End Select


                        Catch ex As Exception
                            MsgBox("Invalid 'speak' line in pony.ini file for pony named " & PonyName & ":" & ControlChars.NewLine _
                             & line & ControlChars.NewLine & "Error: " & ex.Message)
                        End Try


                    Case "effect"
                        Effects.Add(line)

                    Case Else
                        MsgBox("Unknown command in pony.ini for pony " & PonyName & ": " & columns(0) _
                               & ControlChars.NewLine & "Skipping line: " & _
                               ControlChars.NewLine & line)
                        Continue For

                End Select
            Loop


            If PonyName = "" Then
                MsgBox("Couldn't find pony name in configuration file, poni.ini.  Skipping " & folder)
                Continue For
            End If

            Dim newPony As New Pony(PonyName, PonyLines, folder, Scale, Selectable_Ponies.Count, BehaviorGroups)
            newPony.Tags = Tags

            'Now that we have a list of all the behaviors, process them
            For Each behavior In Behaviors
                Try

                    Dim columns = SplitWithQualifiers(behavior, ",", ControlChars.Quote)

                    Dim movement As Byte

                    'movements are bytes so that they can be composite:
                    '"diagonal" means verticle AND horizontal at the same time.
                    'See the definition in the pony class for more information.
                    Select Case Trim(LCase(columns(behavior_options.movement_type)))

                        Case "none"
                            movement = CByte(0)

                        Case "horizontal_only"
                            movement = CByte(1)

                        Case "vertical_only"
                            movement = CByte(2)

                        Case "horizontal_vertical"
                            movement = CByte(3)

                        Case "diagonal_only"
                            movement = CByte(4)

                        Case "diagonal_horizontal"
                            movement = CByte(5)

                        Case "diagonal_vertical"
                            movement = CByte(6)

                        Case "all"
                            movement = CByte(7)
                        Case "mouseover"
                            movement = CByte(8)
                        Case "sleep"
                            movement = CByte(16)
                        Case "dragged"
                            movement = CByte(32)

                        Case Else
                            MsgBox("Unknown movement type: " & columns(behavior_options.movement_type) _
                                   & ControlChars.NewLine & "Skipping behavior " & columns(behavior_options.name) & " for " & PonyName)
                            Continue For


                    End Select

                    Dim linked_behavior As String = ""
                    Dim speak_start As String = ""
                    Dim speak_end As String = ""
                    Dim xcoord As Integer = 0
                    Dim ycoord As Integer = 0
                    Dim follow As String = ""
                    Dim follow_stopped_behavior As String = ""
                    Dim follow_moving_behavior As String = ""

                    Dim auto_select_images As Boolean = True
                    Dim skip As Boolean = False

                    Dim right_image_center As New Point
                    Dim left_image_center As New Point
                    Dim dont_repeat_image_animations As Boolean = False
                    Dim group As Integer = 0

                    If UBound(columns) > behavior_options.movement_type Then

                        linked_behavior = Trim(columns(behavior_options.linked_behavior))
                        speak_start = Trim(columns(behavior_options.speaking_start))
                        speak_end = Trim(columns(behavior_options.speaking_end))
                        skip = CBool(Trim(columns(behavior_options.skip)))
                        xcoord = CInt(columns(behavior_options.xcoord))
                        ycoord = CInt(columns(behavior_options.ycoord))
                        follow = LCase(Trim(columns(behavior_options.object_to_follow)))
                        If UBound(columns) >= behavior_options.auto_select_images Then
                            auto_select_images = CBool(Trim(columns(behavior_options.auto_select_images)))
                        End If
                        If UBound(columns) >= behavior_options.follow_stopped_behavior Then
                            follow_stopped_behavior = Trim(columns(behavior_options.follow_stopped_behavior))
                        End If
                        If UBound(columns) >= behavior_options.follow_moving_behavior Then
                            follow_moving_behavior = Trim(columns(behavior_options.follow_moving_behavior))
                        End If
                        If UBound(columns) >= behavior_options.left_image_center Then
                            Dim center = Split(Trim(columns(behavior_options.right_image_center)), ",")
                            right_image_center = New Point(center(0), center(1))
                            center = Split(Trim(columns(behavior_options.left_image_center)), ",")
                            left_image_center = New Point(center(0), center(1))
                        End If

                        If UBound(columns) >= behavior_options.dont_repeat_image_animations Then
                            dont_repeat_image_animations = CBool(Trim(columns(behavior_options.dont_repeat_image_animations)))
                        End If

                        If UBound(columns) >= behavior_options.group Then
                            group = columns(behavior_options.group)
                        End If

                    End If


                    '                    Load images now?,  name,     , Probabiliy, Max_Secs  , Min_Secs  , Speed     , image path, left image path, move_type, Linked behavior, speaking line_start, speaking line_end , skip normally unless processing links, x coord, ycoord, object to follow
                    newPony.Add_Behavior(False, columns(behavior_options.name), columns(behavior_options.probability), columns(behavior_options.max_duration), columns(behavior_options.min_duration), columns(behavior_options.speed), folder & System.IO.Path.DirectorySeparatorChar & Trim(columns(behavior_options.right_image_path)), _
                                         folder & System.IO.Path.DirectorySeparatorChar & Trim(columns(behavior_options.left_image_path)), movement, linked_behavior, speak_start, speak_end, skip, _
                                         xcoord, ycoord, follow, auto_select_images, follow_stopped_behavior, follow_moving_behavior, right_image_center, left_image_center, dont_repeat_image_animations, group)

                Catch ex As Exception

                    fail = True

                    If auto_started = False Then
                        If ex.GetType Is GetType(System.IndexOutOfRangeException) Then
                            MsgBox("Warning:  You are missing a required parameter for pony " & PonyName & " in behvaior:" & ControlChars.NewLine _
                            & behavior)
                        Else
                            MsgBox("Invalid behavior line in configuration file for pony " & PonyName & ":" & ControlChars.NewLine _
                           & behavior & ControlChars.NewLine & _
                           "Details: " & ex.Message)
                        End If
                    End If
                    Exit For

                End Try
            Next

            If fail Then Continue For

            For Each effect In Effects

                Try

                    Dim columns = SplitWithQualifiers(effect, ",", ControlChars.Quote)

                    '1 = effect name
                    '2 = behvaior name
                    '3 = right image
                    '4 = left image
                    '5 = duration
                    '6 = delay before next
                    '7 = location relative to pony, right
                    '8 = center of effect, right
                    '9 = location going left
                    '10 = centering going left
                    '11 = effect follows pony
                    '12 = animations shouldn't repeat

                    Dim found_behavior As Boolean = False
                    For Each behavior In newPony.Behaviors

                        If behavior.Name = Trim(columns(2)) Then

                            Dim direction_right As Integer = 8
                            Dim centering_right As Integer = 8
                            Dim direction_left As Integer = 8
                            Dim centering_left As Integer = 8
                            Dim dont_repeat_image_animations As Boolean = False

                            Try
                                direction_right = GetDirection(Trim(LCase(columns(7))))
                                centering_right = GetDirection(Trim(LCase(columns(8))))
                                direction_left = GetDirection(Trim(LCase(columns(9))))
                                centering_left = GetDirection(Trim(LCase(columns(10))))

                            Catch ex As Exception
                                MsgBox("Invalid placement direction or centering for effect " & columns(1) & " for pony " & PonyName & ":" & ControlChars.NewLine & effect)
                            End Try

                            If UBound(columns) >= 12 Then
                                dont_repeat_image_animations = CBool(Trim(columns(12)))

                            Else
                                dont_repeat_image_animations = False
                            End If


                            Dim right_imagepath = folder & System.IO.Path.DirectorySeparatorChar & Trim(columns(3))
                            Dim left_imagepath = folder & System.IO.Path.DirectorySeparatorChar & Trim(columns(4))

                            behavior.AddEffect(columns(1), right_imagepath, left_imagepath, columns(5), columns(6), _
                                               direction_right, centering_right, direction_left, centering_left, CBool(Trim(columns(11))), _
                                             dont_repeat_image_animations)
                            found_behavior = True
                            Exit For

                        End If

                    Next

                    If Not found_behavior Then
                        MsgBox("Cound not find behavior for effect " & columns(1) & " for pony " & PonyName & ":" & ControlChars.NewLine _
                           & effect)
                    End If

                Catch ex As Exception
                    MsgBox("Invalid effect in configuration file for pony " & PonyName & ":" & ControlChars.NewLine _
                           & effect & ControlChars.NewLine & _
                          "Details: " & ex.Message)
                End Try

            Next

            'Behaviors that "chain" or link to another behavior to be played after they are done need to be set up now that we
            'have a list of all them.
            newPony.Link_Behaviors()

            config_file.Close()

            Ponies_To_Add.add(newPony)

        Next

        Ponies_to_add.Sort(PonyComparer_Name)

        For Each Pony In Ponies_to_add
            Add_to_Menu(Pony, False)
        Next

        If Selectable_Ponies.Count = 0 Then
            MsgBox("Sorry, but you don't seem to have any ponies installed.  There should have at least been a 'Derpy' folder in the same spot as this program.")
            Go_Button.Enabled = False
        End If

        'Load pony counts.
        My.Forms.Options.Load_Button_Click(Nothing, Nothing, True, True)

        'We first load interactions to get a list of names 
        'that each pony should interact with.
        'Latter, we "initialize" interactions to get
        'a list of each pony object.
        Try
            If My.Forms.Options.Interactions_Enabled.Checked Then
                Dim displaywarnings = False
                If My.Forms.Options.Interaction_Errors_Displayed.Checked AndAlso auto_started = False AndAlso screen_saver_mode = False Then
                    displaywarnings = True
                End If
                Load_Interactions(displaywarnings)
            End If
        Catch ex As Exception
            MsgBox("Unable to load interactions.  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
        End Try

        If auto_started = True Then
            Me.Opacity = 0
            Go_Click(Nothing, Nothing)
        Else
            Me.Opacity = 100
        End If

        CountSelectedPonies()

#If Not Debug Then
            Catch ex As Exception
            MsgBox("Error starting up!  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
            Exit Sub
        End Try
#End If

    End Sub

    Sub Get_ScreenSaver_Path()
        Try
            'We can't use isolated storage as windows uses 8 character names when starting as a screensaver for some reason, and then
            'gets confused when it can't find the assembly name "DESKTO~1"...
            'instead, we just place a file in the temporary folder.

            'Dim UserIsolatedStorage = System.IO.IsolatedStorage.IsolatedStorageFile.GetUserStoreForAssembly()
            'Dim UserIsolatedStorageFile = New System.IO.IsolatedStorage.IsolatedStorageFileStream("DesktopPonies_ScreenSaver_Settings.txt", _
            '                                                                      IO.FileMode.Open, IO.FileAccess.Read, UserIsolatedStorage)

            'Dim SettingsFile As New System.IO.StreamReader(UserIsolatedStorageFile)

            If Not My.Computer.FileSystem.FileExists(screensaver_settings_file_path) Then
                Set_ScreenSaver_Path()
            End If

            Dim SettingsFile As New System.IO.StreamReader(screensaver_settings_file_path)

            screen_saver_path = SettingsFile.ReadLine()

            SettingsFile.Close()
            'UserIsolatedStorageFile.Close()
            'UserIsolatedStorage.Close()

            If Not My.Computer.FileSystem.DirectoryExists(screen_saver_path) Then
                MsgBox("ScreenSaver error:  Path to pony files does not exist.  Please update the screensaver settings with the right path. " _
                                    & ControlChars.NewLine & "Tried path: " & screen_saver_path)
                screen_saver_path = ""
                Exit Sub
            End If

        Catch ex As Exception
            MsgBox("Error: You need to set the settings of the screensaver first before using it." & ControlChars.NewLine & _
                   "Unable to read settings file.  ScreenSaver mode will not work.  Details: " & ex.Message)
        End Try
    End Sub

    Sub Set_ScreenSaver_Path()
        Try

            Try
                If My.Computer.FileSystem.FileExists(screensaver_settings_file_path) Then
                    Dim existing_file As New System.IO.StreamReader(screensaver_settings_file_path)
                    screen_saver_path = existing_file.ReadLine()
                    SelectFilesPath_Form.Path_Textbox.Text = screen_saver_path
                    existing_file.Close()
                End If
            Catch ex As Exception
                MsgBox("Error reading current settings: " & ex.Message)
            End Try

            If SelectFilesPath_Form.ShowDialog() <> DialogResult.OK Then
                Exit Sub
            End If

            'Dim UserIsolatedStorage = System.IO.IsolatedStorage.IsolatedStorageFile.GetUserStoreForAssembly()
            'Dim UserIsolatedStorageFile = New System.IO.IsolatedStorage.IsolatedStorageFileStream("DesktopPonies_ScreenSaver_Settings.txt", _
            '                                                                      IO.FileMode.Create, IO.FileAccess.Write, UserIsolatedStorage)

            'Dim SettingsFile As New System.IO.StreamWriter(UserIsolatedStorageFile, System.Text.Encoding.Unicode)

            'we use unicode here, and any time we save a file as other languages can cause problems.
            Dim SettingsFile As New System.IO.StreamWriter(screensaver_settings_file_path, False, System.Text.Encoding.UTF8)

            SettingsFile.WriteLine(screen_saver_path)

            SettingsFile.Close()
            'UserIsolatedStorageFile.Close()
            'UserIsolatedStorage.Close()

        Catch ex As Exception
            MsgBox("Error:  Unable to create settings file.  ScreenSaver mode will not work.  Details: " & ex.Message)
        End Try
    End Sub

    Enum Interaction_Parameters

        Name = 0
        Initiator = 1  'which pony triggers the interaction?
        Probability = 2
        Proximity = 3
        Target_List = 4
        Target_Selection_Option = 5  'do we interact with only the pony we ran into, or all of them on the list (even multiple instances)
        Behavior_List = 6
        Repeat_Delay = 7

    End Enum


    Sub Load_Interactions(Optional ByVal displaywarnings As Boolean = True)


        If Not My.Computer.FileSystem.FileExists(Install_Location & System.IO.Path.DirectorySeparatorChar & "interactions.ini") Then
            My.Forms.Options.Interactions_Disabled_Label.Visible = True
            Exit Sub
        End If


        Dim interactions_file As New System.IO.StreamReader(Install_Location & System.IO.Path.DirectorySeparatorChar & "interactions.ini")

        Do Until interactions_file.EndOfStream

            Dim line = interactions_file.ReadLine

            If InStr(line, "'") = 1 OrElse Trim(line) = "" Then Continue Do

            Dim columns = SplitWithQualifiers(line, ",", "{", "}")

            Dim ponyfound = False

            For Each Pony In Selectable_Ponies
                Try
                    Dim ponyname = SplitWithQualifiers(columns(Interaction_Parameters.Initiator), ",", ControlChars.Quote)(0)

                    If Trim(LCase(Pony.Name)) = Trim(LCase(ponyname)) Then

                        ponyfound = True

                        Dim repeat_delay = 60

                        If UBound(columns) >= Interaction_Parameters.Repeat_Delay Then
                            repeat_delay = columns(Interaction_Parameters.Repeat_Delay)
                        End If

                        Pony.add_Interaction(columns(Interaction_Parameters.Name), _
                                        ponyname, _
                                        columns(Interaction_Parameters.Probability), _
                                        columns(Interaction_Parameters.Proximity), _
                                        columns(Interaction_Parameters.Target_List), _
                                        columns(Interaction_Parameters.Target_Selection_Option), _
                                        columns(Interaction_Parameters.Behavior_List), _
                                        repeat_delay, _
                                        displaywarnings)

                    End If
                Catch ex As Exception
                    If displaywarnings Then
                        MsgBox("Error loading interaction for Pony: " & Pony.Name & _
                         ControlChars.NewLine & line & ControlChars.NewLine & _
                         ex.Message)
                    End If
                End Try
            Next

            If ponyfound = False Then
                If displaywarnings Then
                    MsgBox("Warning:  Interaction specifies a non-existant pony: " & _
                           line)
                End If
            End If

        Loop

    End Sub


    'After all of the ponies, and all of their interactions are loaded, we need to go through and see
    'which interactions can actually be used with which ponies are loaded, and see which ponies each 
    'interaction should interact with.
    Sub Initialize_Interactions()
        For Each Pony In Active_Ponies
            Pony.Initialize_Interactions()
        Next
    End Sub


    Friend Function GetDirection(ByVal setting As String) As Pony.Directions

        Select Case setting

            Case "top"
                Return 0
            Case "bottom"
                Return 1
            Case "left"
                Return 2
            Case "right"
                Return 3
            Case "bottom_right"
                Return 4
            Case "bottom_left"
                Return 5
            Case "top_right"
                Return 6
            Case "top_left"
                Return 7
            Case "center"
                Return 8
            Case "any"
                Return 9
            Case "any-not_center"
                Return 10
            Case Else
                Throw New Exception("Invalid placement direction or centering for effect.")
        End Select

    End Function

    Private Sub Add_to_Menu(ByVal pony As Pony, ByVal redraw As Boolean)

        If redraw = False Then
            Selectable_Ponies.Add(pony)
        End If

        'don't show ponies that don't have at least one of the desired tags in Show Any.. mode
        If ShowAny_Radio.Checked Then
            Dim match = False
            For Each tag_to_show In PonyFilter_Box.CheckedItems
                For Each ponyTag In pony.Tags
                    If LCase(ponyTag) = LCase(tag_to_show) Then
                        match = True
                        Exit For
                    End If
                Next
                If tag_to_show = "Not Tagged" AndAlso pony.Tags.Count = 0 Then
                    match = True
                End If
                If match Then Exit For
            Next
            If match = False Then
                Exit Sub
            End If
        End If

        'don't show ponies that don't have all of the desired tags in Show Exactly.. mode
        If ShowExactly_Radio.Checked Then
            Dim all_match = False
            For Each tag_to_show In PonyFilter_Box.CheckedItems
                Dim match = False
                For Each ponyTag In pony.Tags
                    If LCase(ponyTag) = LCase(tag_to_show) Then
                        match = True
                        all_match = True
                        Exit For
                    End If
                Next
                If tag_to_show = "Not Tagged" AndAlso pony.Tags.Count = 0 Then
                    match = True
                    all_match = True
                End If
                If match = False Then
                    Exit Sub
                End If
            Next
            If all_match = False Then
                Exit Sub
            End If
        End If

        Dim minHeight = 101
        Dim minWidth = 200
        Dim panelHeight = 0
        Dim panelWidth = 0

        ' Pony Image
        Try
            pony.picture = Image.FromFile(pony.Behaviors(0).right_image_path)
        Catch ex As Exception
            MsgBox("Couldn't load image for pony " & pony.Name & ". Details: " & ex.Message)
        End Try

        Dim PonyPicture As New PictureBox
        PonyPicture.Image = pony.picture
        PonyPicture.SizeMode = PictureBoxSizeMode.StretchImage
        PonyPicture.Size = pony.ImageScale(PonyPicture.Image.Size)

        ' Figure out panel Size
        Last_Pony_Picture = PonyPicture

        panelWidth = PonyPicture.Size.Width + 110
        If PonyPicture.Size.Width + 110 < minWidth Then
            panelWidth = minWidth
        End If

        panelHeight = PonyPicture.Size.Height + 5
        If PonyPicture.Size.Height + 5 < minHeight Then
            panelHeight = minHeight
        End If

        ' Set Pony in middle of panel height
        PonyPicture.Location = New Drawing.Point(5, (panelHeight - PonyPicture.Size.Height) / 2)

    

        ' Pony Name
        Dim PonyLabel As New Label
        PonyLabel.Text = pony.Name
        PonyLabel.Location = New Drawing.Point(PonyPicture.Size.Width + 13, 5)

        ' "How Many?"
        Dim PonyCountLabel As New Label
        PonyCountLabel.Text = "How many?"
        PonyCountLabel.Location = New Drawing.Point(PonyPicture.Size.Width + 13, panelHeight - 42)

        ' Pony Count
        Dim PonyCount As New TextBox
        PonyCount.Text = 1
        PonyCount.Size = New Drawing.Size((panelWidth - 11) - (PonyPicture.Size.Width + 11), 20)
        PonyCount.Location = New Drawing.Point(PonyPicture.Size.Width + 15, panelHeight - 27)
        AddHandler PonyCount.TextChanged, AddressOf CountSelectedPonies

        ' Setup Panel to hold Ponys
        Dim PonyPanel As New Panel
        PonyPanel.BorderStyle = BorderStyle.FixedSingle
        PonyPanel.Size = New Drawing.Size(panelWidth, panelHeight)

        ' Setup Positions for next Panel
        If Last_X_Pos + panelWidth >= Me.SplitContainer1.Panel1.Width - 23 Then
            Last_X_Pos = 0
            Total_Picture_Height += Tallest_Pony + 10
            Tallest_Pony = 0
        End If

        If Last_Pony_Picture.Height > Tallest_Pony Then
            Tallest_Pony = Last_Pony_Picture.Height
        End If

        ' Set Pos
        PonyPanel.Location = New Drawing.Point(5 + Last_X_Pos, 5 + Total_Picture_Height)
        Last_X_Pos += (panelWidth + 5)

        'Record at what height the pony's name is at.  This will allow for quick-searching by pressing a key with the menu selected
        PonySearchIndex.Add(pony.Name & "," & PonyPanel.Location.Y)

        If pony.Name = "Random Pony" Then
            Dim random_duplicates_checkbox As CheckBox = NoRandomDuplicates_Option
            random_duplicates_checkbox.Text = "No duplicates"
            random_duplicates_checkbox.Location = New Drawing.Point(PonyPicture.Size.Width + 15, panelHeight - 77)
            PonyPanel.Controls.Add(random_duplicates_checkbox)
        End If

        ' Add Controls
        PonyPanel.Controls.Add(PonyPicture)
        PonyPanel.Controls.Add(PonyLabel)
        PonyPanel.Controls.Add(PonyCount)
        PonyPanel.Controls.Add(PonyCountLabel)
        Me.SplitContainer1.Panel1.Controls.Add(PonyPanel)

        Main_Resize(Nothing, Nothing)

    End Sub

    Private Sub CountSelectedPonies()

        Dim total_ponies As Integer = 0

        For Each PonyPanel In SplitContainer1.Panel1.Controls
            If PonyPanel.GetType Is GetType(Panel) Then

                Dim textbox As TextBox = Nothing
                Dim label As Label = Nothing

                For Each Control In PonyPanel.Controls

                    If Control.GetType Is GetType(Label) Then
                        If Control.Text <> "How many?" Then
                            label = Control
                        End If
                    End If

                    If Control.GetType Is GetType(TextBox) Then
                        textbox = Control
                    End If
                Next

                Try
                    If IsNumeric(textbox.Text) AndAlso CInt(textbox.Text) > 0 Then
                        total_ponies += textbox.Text
                    End If
                Catch ex As Exception
                    Exit Sub
                End Try

            End If
        Next

        PonyCount_Label.Text = total_ponies

    End Sub

    Friend Sub Redraw_Menu()

        Temp_Save_Counts()

        Total_Picture_Height = 0
        Tallest_Pony = 0
        Last_X_Pos = 0

        Dispose_Menu()

        For Each Pony In Selectable_Ponies
            Add_to_Menu(Pony, True)
        Next

        Main_Resize(Nothing, Nothing)

        My.Forms.Options.Load_PonyCounts(My.Forms.Options.ponycounts)

    End Sub

    'Even when it is not visible, animations on the main form still take CPU.  This sub disposes all of the controls 
    'to bring its CPU usage back down to 0.
    Sub Dispose_Menu()

        'keep track of the no duplicate option for the random pony. we need to dispose of the control, then recreate it
        Dim norandom As Boolean = NoRandomDuplicates_Option.Checked

        'IMPORTANT:  We can't just start disposing controls as it modifies the
        'collection of controls for the panel as we are iterating over it!
        'We need to keep track of them in a different list.
        Dim control_list As New List(Of Control)

        For Each Control As Control In Me.SplitContainer1.Panel1.Controls
            control_list.Add(Control)
        Next

        For Each Control As Control In control_list
            If Control.GetType Is GetType(Panel) Then

                Dim panel As Panel = Control

                For Each panel_control In panel.Controls
                    If panel_control.text <> "No duplicates" Then
                        panel_control.dispose()
                    End If
                Next
            End If
            Control.Dispose()
        Next

        For Each Pony As Pony In Selectable_Ponies
            If Not IsNothing(Pony.picture) Then Pony.picture.Dispose()
        Next

        NoRandomDuplicates_Option = New CheckBox
        NoRandomDuplicates_Option.Checked = norandom

        PonySearchIndex.Clear()

    End Sub

    'the main section where all processing is done.
    'the timer is normally set to fire every 30 milliseconds.
    Private Sub Pony_DoAction() Handles MoveTimer.Tick

#If Not Debug Then
           Try
#End If


        If screen_saver_mode Then
            'keep track of the cursor and, if it moves, quit (we are supposed to act like a screensaver)
            If cursor_position = New Point() Then
                cursor_position = Cursor.Position
            End If

            If cursor_position <> Cursor.Position Then
                Me.Close()
            End If
        Else
            If My.Forms.Options.Suspend_on_Fullscreen_Checkbox.Checked Then
                'See if there are any full screen application running.
                'If so, minimize and suspend.

                If DetectFullScreenApp() Then

                    If Suspended_For_FullScreenApp = False Then
                        Suspended_For_FullScreenApp = True

                        MoveTimer.Interval = 1000
                        For Each ponyform As PonyGraphicsForm In PonyForms
                            ponyform.ClearScreen()
                        Next
                    End If

                    Exit Sub

                Else

                    If Suspended_For_FullScreenApp Then
                        Suspended_For_FullScreenApp = False

                        MoveTimer.Interval = 30
                    End If

                End If
            End If
        End If

        Dim ponies_to_remove As New List(Of Pony)

        For Each Pony As Pony In Active_Ponies

            If Pony.AtDestination AndAlso Pony.Going_Home AndAlso Pony.Opening_Door AndAlso Pony.current_behavior.delay <= 0 Then
                ponies_to_remove.Add(Pony)
            End If

            If Pony.initialized = False Then
                Pony.Teleport()
                Pony.initialized = True
            Else
                'paint/move/etc.  Dance, pony, DANCE!
                If IsNothing(current_game) Then
                    Pony.Update(totalElaspedTime)
                End If
            End If

        Next

        For Each Pony In ponies_to_remove
            Active_Ponies.Remove(Pony)
            For Each behavior As Pony.Behavior In Pony.Behaviors
                behavior.UnloadImages()
                For Each effect As Pony.Behavior.effect In behavior.Effects
                    effect.UnloadImages()
                Next
            Next
        Next

        ' Keep track of the time we started the tick.
        Dim thisLoopStartTime As DateTime = DateTime.Now

        For Each ponyform In PonyForms
            ponyform.Update_Graphics()
        Next

        loopStartTime = thisLoopStartTime
        loopEndTime = DateTime.Now
        totalElaspedTime = loopEndTime - formStartTime

        If Not IsNothing(current_game) Then
            current_game.Update()
        End If

        If Active_Ponies.Count = 0 Then
            Me.Close()
        End If

        For Each ponyform As PonyGraphicsForm In PonyForms
            If ponyform.IsDisposed() Then Me.Close()
        Next

        Dim effects_to_remove As New List(Of Pony.Behavior.effect)

        For Each Effect As Pony.Behavior.effect In Active_Effects
            If Effect.end_time.Subtract(Now).TotalMilliseconds <= 0 AndAlso Effect.Pony_Name <> "N/A" Then
                effects_to_remove.Add(Effect)
            End If
        Next

        'We keep track of active_effects in two places:
        '-The pony that created it keeps a list so they can be removed when they should.
        '-If the pony that created it was closed, this loop will clean up the now orphaned effects.
        For Each effect In effects_to_remove
            If Not IsNothing(effect.Owning_Pony) Then
                effect.Owning_Pony.Active_Effects.Remove(effect)
                ' effect.Owning_Pony = Nothing
            End If
            Active_Effects.Remove(effect)
            Dead_Effects.Add(effect)
        Next

        'cleanup dead effects separately - we can't do this immediately as they are needed to clear the graphics they leave behind

        effects_to_remove.Clear()

        For Each effect In Dead_Effects
            If DateDiff(DateInterval.Second, effect.end_time, Now()) > 1 Then
                effects_to_remove.Add(effect)
            End If
        Next

        For Each effect In effects_to_remove
            Dead_Effects.Remove(effect)
        Next


        'Set order for ponies depending on their height position on the screen
        '(Higher ponies are drawn first)
        Active_Ponies.Sort(PonyComparer_Height)

        If DisableSoundsDueToDirectXFailure = False Then
            Cleanup_Sounds()
        End If

        For Each house In Houses
            If house.Active Then
                house.Cycle()
            End If
        Next

#If Not Debug Then
        Catch ex As Exception
            MoveTimer.Stop()
            MsgBox("Error: " & ex.Message & ControlChars.NewLine & _
                   ex.StackTrace)
            Me.Close()
        End Try
#End If


    End Sub

    Private Sub Cleanup_Sounds()

        Dim sounds_to_remove As New List(Of Microsoft.DirectX.AudioVideoPlayback.Audio)

        For Each sound As Microsoft.DirectX.AudioVideoPlayback.Audio In Active_Sounds
            If sound.State = Microsoft.DirectX.AudioVideoPlayback.StateFlags.Paused OrElse sound.Duration = sound.CurrentPosition Then
                sound.Dispose()
                sounds_to_remove.Add(sound)
            End If
        Next

        For Each sound In sounds_to_remove
            Active_Sounds.Remove(sound)
        Next

    End Sub

    Private Sub CleanupTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CleanupTimer.Tick
        'Images that are cloned and discarded are not cleaned up automatically - 
        'causing a memory leak.  This gets rid of them.
        'We can't dispose them manually because there is a chance that they will be used
        'by other window threads - like the speech tooltips, where the tooltip accesses the image position to know where to go.
        GC.Collect()

        'Sometimes, if ponies move too fast or the system lags behind, ghost images can be left of the ponies.
        'Here, every few seconds we force the ponyforms to clear the entire screen.
        For Each ponyform As PonyGraphicsForm In PonyForms
            ponyform.Cleared = False
        Next

    End Sub


    Private Sub Main_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        'Me.Text = Me.Size.ToString
        ' Reset Vars

        If Me.Visible = False Then
            Exit Sub
        End If

        SplitContainer1.Panel1.VerticalScroll.Value = 0
        SplitContainer1.Panel1.HorizontalScroll.Value = 0

        Total_Picture_Height = 0
        Tallest_Pony = 0
        Last_X_Pos = 0

        For Each Control In Me.SplitContainer1.Panel1.Controls
            If Control.GetType Is GetType(Panel) Then
                Dim panel As Panel = Control

                If Last_X_Pos + Control.size.Width >= Me.SplitContainer1.Panel1.Width - 23 Then
                    Last_X_Pos = 0
                    Total_Picture_Height += Tallest_Pony + 5
                    Tallest_Pony = 0
                End If

                If Control.Size.Height > Tallest_Pony Then
                    Tallest_Pony = Control.Size.Height
                End If

                panel.Location = New Drawing.Point(Last_X_Pos + 5, Total_Picture_Height + 5)
                Last_X_Pos += Control.Size.Width + 5
            End If
        Next

        Dim new_height = Me.Height - 200

        If new_height <= 0 Then
            Exit Sub
        Else
            SplitContainer1.SplitterDistance = new_height
        End If



    End Sub


    Private Sub Options_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Options_Button.Click

        If Options_Is_Created = False Then
            Options.Show()
            Options_Is_Created = True
        Else
            Options.Visible = True
        End If

    End Sub

    'Set each pony's count to 0
    Friend Sub Zero_Ponies_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Zero_Ponies_Button.Click
        For Each PonyPanel In SplitContainer1.Panel1.Controls
            If PonyPanel.GetType Is GetType(Panel) Then
                For Each Control In PonyPanel.Controls
                    If Control.GetType Is GetType(TextBox) Then
                        Dim textbox As TextBox = Control

                        textbox.Text = 0

                    End If
                Next
            End If
        Next

    End Sub

    Private Sub Pony_Editor_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Pony_Editor_Button.Click

        Preview_Mode = True
        Me.Visible = False
        Pony_Editor.ShowDialog()

        Pony_Shutdown(True)

        Preview_Mode = False
        If Not Me.IsDisposed Then
            Me.Visible = True
        End If

        Options.Close()

        If My.Forms.Pony_Editor.changes_made Then

            Active_Ponies = New List(Of Pony)

            Dispose_Menu()

            Last_Pony_Picture = Nothing
            Total_Picture_Height = 0

            Last_X_Pos = 0
            Tallest_Pony = 0

            '(We need to reload everything to account for anything changed while in the editor)
            Main_Load(Nothing, Nothing)

        Else
            'if nothing changes, we just need to re_draw the menu.
            Redraw_Menu()
        End If

    End Sub

    Sub SaveFilterSelections()

        Temp_Filters.Clear()
        For Each item As String In PonyFilter_Box.CheckedItems
            Temp_Filters.Add(item)
        Next

    End Sub

    Sub LoadFilterSelections()

        For Each item As String In Temp_Filters
            Try
                PonyFilter_Box.SetItemChecked(PonyFilter_Box.Items.IndexOf(item), True)
            Catch ex As Exception
                'Filter is not valid at time of restoring.  Do nothing
            End Try
        Next

    End Sub

    'Put all ponies to sleep... 
    Friend Sub sleep_all()

        If Not all_sleeping Then

            all_sleeping = True

            For Each Pony In Active_Ponies
                'Pony.sleep()
                Pony.should_be_sleeping = True
            Next

        Else

            all_sleeping = False

            For Each Pony In Active_Ponies
                'Pony.wake_up()
                Pony.should_be_sleeping = False
            Next
        End If

    End Sub

    Sub Unhandled_Exception_Catch(ByVal sender As Object, ByVal e As UnhandledExceptionEventArgs)

        Dim ex As Exception = Nothing

        Try
            ex = e.ExceptionObject
        Catch ex2 As Exception
            '
        End Try

        If Not IsNothing(ex) Then
            MsgBox("An unknown error occured.  Please report this so it can be fixed." _
                   & ControlChars.NewLine & "Error details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
        Else
            MsgBox("Unknown error: " & e.ExceptionObject.ToString)
        End If

        Me.Close()
    End Sub

    Sub ThreadException_Catch(ByVal sender As Object, ByVal e As System.Threading.ThreadExceptionEventArgs)

        MsgBox("An unknown error occured.  Please report this so it can be fixed." _
               & ControlChars.NewLine & "Error details: " & e.Exception.Message & ControlChars.NewLine & e.Exception.StackTrace)

        Me.Close()
    End Sub

    Private Sub Save_Counts_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Save_Counts_Button.Click
        Temp_Save_Counts()
        My.Forms.Options.Save_Button_Click(Nothing, Nothing)
    End Sub

    Private Sub Load_Counts_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Load_Counts_Button.Click
        My.Forms.Options.Load_Button_Click(Nothing, Nothing, False, True)
    End Sub

    Private Sub Reset_Counts_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Reset_Counts_Button.Click
        My.Forms.Options.Reset_Click(Nothing, Nothing, True)
    End Sub

    Private Sub Games_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Games_Button.Click

#If Not Debug Then
          Try
#End If


        If games.Count <> 0 Then
            games.Clear()
        End If

        Dim Install_Folder = My.Computer.FileSystem.GetDirectories(Install_Location)

        For Each folder In Install_Folder

            Try
                If InStr(LCase(folder), "game_") = 0 Then
                    Continue For
                End If

                'some languages don't use \ as a separator between folders
                Dim config_file_name = folder & System.IO.Path.DirectorySeparatorChar & "game.ini"

                Dim new_game As New Game(config_file_name, folder & System.IO.Path.DirectorySeparatorChar)

                games.Add(new_game)

            Catch ex As Exception
                MsgBox("Error loading game: " & folder & ex.Message & ex.StackTrace)
            End Try
        Next

        Me.Visible = False
        If Game_Selection_Form.ShowDialog() = DialogResult.OK Then
            current_game.Setup()
            Pony_Startup()
        Else
            If Me.IsDisposed = False Then
                Me.Visible = True
            End If
        End If

#If Not Debug Then
           Catch ex As Exception
            MsgBox("Error loading games: " & ex.Message & ex.StackTrace)
        End Try
#End If
     

    End Sub

    Function load_house(folder As String, skip_errors As Boolean) As Boolean


        'some languages don't use \ as a separator between folders
        Dim config_file_name = folder & System.IO.Path.DirectorySeparatorChar & "house.ini"
        Dim config_file As System.IO.StreamReader
        Try
            config_file = New System.IO.StreamReader(config_file_name)
        Catch ex As Exception
            If skip_errors = False Then
                Select Case MsgBox("Error: No house.ini configuration file found for folder: " & folder _
                   & ControlChars.NewLine & "Won't load this house/structure..." & ControlChars.NewLine _
                   & "Do you want to skip seeing these errors?  Press No to see the error for each folder.  Press cancel to quit.", MsgBoxStyle.YesNoCancel)

                    Case DialogResult.Yes
                        Return True
                    Case DialogResult.No
                        'do nothing
                    Case DialogResult.Cancel
                        Me.Close()

                End Select
            End If

            Return skip_errors
        End Try


        Dim name As String = ""
        Dim image_path As String = ""
        Dim image_file As String = ""
        Dim door As New Point()
        Dim cycletime As Integer = 300
        Dim pony_list As New List(Of String)

        Do Until config_file.EndOfStream

            Dim line = config_file.ReadLine

            'ignore blank or 'commented out' lines.
            If line = "" OrElse line(0) = "'" Then
                Continue Do
            End If

            'SplitWithQualifiers is an improved split() that lets use use, as the name says, text qualifiers.
            'This lets you embed two different lists of items, or handle names that contain commas.

            Dim columns = SplitWithQualifiers(line, ",", ControlChars.Quote, ControlChars.Quote, "{", "}")

            Select Case LCase(columns(0))

                Case "name"
                    name = columns(1)
                Case "image"
                    image_path = folder & System.IO.Path.DirectorySeparatorChar & columns(1)
                    image_file = columns(1)
                    If Not System.IO.File.Exists(image_path) Then
                        MsgBox("Error:  Image does not exist: " & image_path)
                        Return skip_errors
                    End If
                Case "door"
                    door = New Point(columns(1), columns(2))
                Case "cycletime"
                    cycletime = columns(1)
                Case Else
                    pony_list.Add(Trim(line))
            End Select
        Loop

        config_file.Close()

        If name = "" OrElse image_path = "" OrElse image_file = "" OrElse pony_list.Count = 0 Then
            If skip_errors = False Then
                MsgBox("Unable to load 'House' at: " & folder & ".  INI file does not contain all necessary parameters: " & ControlChars.NewLine & _
                       "name, image, and at least one pony's name")
                Return skip_errors
            End If
        End If

        Dim new_house As New Pony.House(name, folder, image_file, image_path, door, cycletime, pony_list, False)

        Houses.Add(new_house)

        Return skip_errors

    End Function


    Private Sub ShowAny_Radio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowAny_Radio.CheckedChanged

        If ShowAny_Radio.Checked Then
            PonyFilter_Box.Enabled = True
            Redraw_Menu()
        End If

    End Sub

    Private Sub ShowExactly_Radio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowExactly_Radio.CheckedChanged

        If ShowExactly_Radio.Checked Then
            PonyFilter_Box.Enabled = True
            Redraw_Menu()
        End If

    End Sub

    Private Sub ShowAll_Radio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowAll_Radio.CheckedChanged
        If ShowAll_Radio.Checked AndAlso Me.Visible Then
            PonyFilter_Box.Enabled = False
            Redraw_Menu()
        End If
    End Sub

    Private Sub PonyFilter_Box_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PonyFilter_Box.SelectedValueChanged
        Redraw_Menu()
    End Sub


    'Save ponycounts so they are preserved through clicking on and off filters.
    Friend Sub Temp_Save_Counts()

        If SplitContainer1.Panel1.Controls.Count = 0 Then Exit Sub

        My.Forms.Options.ponycounts.Clear()

        For Each PonyPanel In SplitContainer1.Panel1.Controls
            If PonyPanel.GetType Is GetType(Panel) Then

                Dim textbox As TextBox = Nothing
                Dim label As Label = Nothing

                For Each Control In PonyPanel.Controls

                    If Control.GetType Is GetType(Label) Then
                        If Control.Text <> "How many?" Then
                            label = Control
                        End If
                    End If

                    If Control.GetType Is GetType(TextBox) Then
                        textbox = Control
                    End If
                Next

                Try
                    If IsNumeric(textbox.Text) Then
                        Dim ponycount(2) As String
                        ponycount(1) = label.Text
                        ponycount(2) = CInt(textbox.Text)
                        My.Forms.Options.ponycounts.Add(ponycount)
                    End If
                Catch ex As Exception
                    Dim ponycount(2) As String
                    ponycount(1) = label.Text
                    ponycount(2) = 0
                    My.Forms.Options.ponycounts.Add(ponycount)
                End Try

            End If
        Next
    End Sub

    Private Sub SplitContainer1_Panel1_Paint(sender As System.Object, e As System.Windows.Forms.KeyEventArgs) Handles SplitContainer1.KeyDown

        For Each entry In PonySearchIndex

            Dim columns = Split(entry, ",")

            If UCase(e.KeyCode.ToString) = UCase(columns(0)(0)) Then
                SplitContainer1.Panel1.VerticalScroll.Value = columns(1)
                Exit Sub
            End If

        Next


    End Sub
End Class
