﻿Class Pony

    'Functions for detecting other windows - thankts to WindowPonies for this.
    Declare Function WindowFromPoint Lib "user32.dll" (ByVal point As Point) As IntPtr
    Public Declare Auto Function GetWindowThreadProcessId Lib "user32.dll" (ByVal hWnd As IntPtr, Optional ByRef processId As Integer = 0) As Integer
    Declare Function GetWindowRect Lib "user32.dll" (ByVal hwnd As IntPtr, ByRef lpRect As RECT) As Integer

    'the windows apis need this silly "rect" structure, instead of a rectangle class
    Public Structure RECT
        Dim Left As Integer 'X
        Dim Top As Integer  'Y
        Dim Right As Integer
        Dim Bottom As Integer
        'height: Bottom - Top
        'width: Right - Left
    End Structure


    Friend Name As String = ""
    Friend ID As Integer
    Friend picture As Image = Nothing
    Friend Tags As New List(Of String)
    Friend PonyScale As Double = 1
    Friend Current_BehaviorGroup As Integer = -1 '-1 is invalid and will be changed on first SelectBehavior(), 0 = use any group
    Friend BehaviorGroups As New List(Of BehaviorGroup)

    Const Oversize_Factor_For_Clipping = 0.4 'fast moving ponies sometimes get their images clipped off, having the clipping boarders be larger fixes this.
    Friend PonyForm As PonyGraphicsForm
    Friend initialized As Boolean = False
    Friend current_image_center As New Point
    Friend Path_to_Files As String = ""
    Friend Behaviors As New List(Of Behavior)
    Friend Interactions As New List(Of Interaction)

    Friend Interaction_Active As Boolean = False
    Dim Current_Interaction As Interaction = Nothing
    Dim Is_Interaction_Initiator As Boolean = False

    Dim Is_Interacting As Boolean = False

    Friend Playing_Game As Boolean = False
    Friend Position As Object = Nothing

    'time until interactions should be disabled
    'Stops interactions from repeating too soon after one another.
    'Only affects the triggering pony and not targets
    Dim Interaction_Delay_Until As DateTime = Now()

    'The largest dimention that any of the pony's images uses
    Friend Largest_Size_X = 0
    Friend Largest_Size_Y = 0

    Friend current_bitmap As Bitmap

    Friend current_behavior As Behavior

    'Only used when temporarily pausing, like when the mouse hovers over us.
    Dim previous_behavior As Behavior

    Friend Current_Screen As Screen = Nothing
    Dim Moving_Onscreen As Boolean = False
    'Used when going back "in" houses.
    Friend Going_Home As Boolean = False
    'Used when a pony has been recalled and is just about to "enter" a house
    Friend Opening_Door As Boolean = False


    'Should we stop because the cursor is hovered over?
    Dim Cursor_Halt = False
    'Are we actually halted now?
    Dim Is_cursor_halted = False
    Dim Cursor_Immunity As Integer = 0

    Dim Destination As Point = New Point()
    Friend AtDestination As Boolean = False

    'Used in the Paint() sub to help stop flickering between left and right images 
    'under certain circumstances.
    Dim Paint_stop As Boolean = False


    'The location on the screen.  Remember to also set precise_X/Y_Location if changing this directly!
    Friend location As New Point

    'higher precision location so we can move at small angles
    'we convert this to the true location in pony.move()
    Friend Precise_X_Location As Double = 0
    Friend Precise_Y_Location As Double = 0

    'The location relative to the PonyForm.  Automatically updated when drawn.
    Friend Translated_Location As New Point()

    'Used for predicting furture movement (just more of what we last did)
    Dim Last_X_Movement As Double = 0
    Dim Last_Y_Movement As Double = 0

    Friend Active_Effects As New List(Of Behavior.effect)

    Friend Speaking_Lines As New List(Of Behavior.Speaking_Line)

    Friend should_be_sleeping As Boolean = False
    Friend sleeping As Boolean = False
    Friend dragging As Boolean = False

    'User has the option of limiting songs to one-total at a time, or one-per-pony at a time.
    'thess two options are used for the one-per-pony option.
    Dim Audio_Last_Played As Date = Now()
    Dim Last_Audio_Length As Integer = 0

    Dim LastSpoke As DateTime = Now()

    Dim Lines_Random As New List(Of Pony.Behavior.Speaking_Line)
    Dim Lines_Specific As New List(Of Pony.Behavior.Speaking_Line)

    Friend ActionStartTime As TimeSpan
    Friend MovingLeft As Boolean
    Friend BeingDragged As Boolean

    Friend PreUpdate_DrawAreas As Region() = New Region(Screen.AllScreens.Count - 1) {}
    Friend PostUpdate_DrawAreas As Region() = New Region(Screen.AllScreens.Count - 1) {}

    Friend ManualControl_P1 = False
    Friend ManualControl_P2 = False


    'Movements are bytes - each bit determines if that particular mode is available
    'Bit position:			7	6	5	4	3	2	1	0
    'No movement										0
    'Horizontal only									1
    'Vertical Only									1	0
    'Horizonal+Vertical								1	1
    'Diagonal only								1	0	0
    'Diagonal+Horizontal						1	0	1
    'Diagonal+Vertical							1	1	0
    'All										1	1	1
    'MouseOver								1	0	0	0
    'Sleep								1	0	0	0	0
    'Being Dragged                   1  0   0   0   0   0

    'Note that we use binary operations elsewhere to determine if a movement has a certain component.
    'For example:
    '  If (current_behavior.Allowed_Movement And Allowed_Moves.Vertical_Only) = Allowed_Moves.Vertical_Only Then
    'Means:  "Does the movement of the current behavior have a vertical component?

    Friend Enum Allowed_Moves

        None = CByte(0)
        Horizontal_Only = CByte(1)
        Vertical_Only = CByte(2)
        Horizontal_Vertical = CByte(3)
        Diagonal_Only = CByte(4)
        Diagonal_Horizontal = CByte(5)
        Diagonal_Vertical = CByte(6)
        All = CByte(7)
        MouseOver = CByte(8)
        Sleep = CByte(16)
        Dragged = CByte(32)

    End Enum

    Friend Enum Directions

        top = 0
        bottom = 1
        left = 2
        right = 3
        bottom_right = 4
        bottom_left = 5
        top_right = 6
        top_left = 7
        center = 8
        random = 9
        random_not_center = 10

    End Enum


    Sub New(ByVal _name As String, ByVal Lines As List(Of Pony.Behavior.Speaking_Line), ByVal path As String, ByVal scale As Double, _ID As Integer, _behaviorgroups As List(Of BehaviorGroup))
        Name = _name
        ID = _ID
        Path_to_Files = path
        PonyScale = scale
        Speaking_Lines = Lines

        BehaviorGroups = _behaviorgroups

        BeingDragged = False

        For monitornumber = 0 To Screen.AllScreens.Count - 1
            PreUpdate_DrawAreas(monitornumber) = New Region()
            PostUpdate_DrawAreas(monitornumber) = New Region()
        Next

    End Sub


    Friend Function Draw(ByVal g As Graphics, ByVal elaspedTime As TimeSpan, ponyform As PonyGraphicsForm, MonitorNumber As Integer) As Boolean

        If IsNothing(current_behavior) Then Return False

        If Not My.Forms.Main.Preview_Mode AndAlso Not IsPonyOnScreen(location, ponyform.Screen) Then
            Return False
        End If

        Me.PonyForm = ponyform

        Translated_Location = Translate_Current_Location(location, ponyform)

        Activate_Effects(Translated_Location, MonitorNumber)

        For Each effect In Me.Active_Effects

            effect.PreUpdate_DrawAreas(MonitorNumber) = New Region(New Rectangle(Translate_Current_Location(effect.location, ponyform), ImageScale(effect.current_image.Size)))

            If effect.follow Then
                effect.location = GetEffectLocation(ImageScale(effect.current_image.Size),
                    effect.direction, location, ImageScale(current_behavior.current_image.Size()), effect.centering)
            End If

            effect.translated_location = Translate_Current_Location(effect.location, ponyform)
            effect.PostUpdate_DrawAreas(MonitorNumber) = New Region(New Rectangle(Translate_Current_Location(effect.location, ponyform), ImageScale(effect.current_image.Size)))

            effect.Draw(g, elaspedTime, GetScale)
        Next

        'the update size is 50% larger than the normal size, to account for clipping when the pony is moving fast
        Dim update_size = ImageScale(current_behavior.current_image.Size, True)

        'The update area is the oversized 'update_size', at the pony's location moved back to account for the larger size)
        PostUpdate_DrawAreas(MonitorNumber) = New Region(New Rectangle(Translate_Current_Location(location, ponyform, True, ImageScale(current_behavior.current_image.Size)), update_size))

        Me.current_bitmap = current_behavior.Draw(g, Translated_Location.X, Translated_Location.Y, elaspedTime - ActionStartTime, MovingLeft, GetScale(), ponyform)

        'If we just changed behaviors, the chosenewbehavior flag will be set for the first update.
        'Use the previous drawarea as if we recalculate it now, it will be wrong and me might
        'end up with junk on the screen.

        If current_behavior.CS_choseNewBehaviour = False Then
            update_size = ImageScale(current_behavior.current_image.Size, True)
            PreUpdate_DrawAreas(MonitorNumber) = New Region(New Rectangle(Translate_Current_Location(location, ponyform, True, ImageScale(current_behavior.current_image.Size)), update_size))
        End If

        Return True
    End Function


    Friend Shared Function Translate_Current_Location(location As Point, ponyform As PonyGraphicsForm, Optional Oversized As Boolean = False, Optional oversized_size As Size = Nothing) As Point

        If IsNothing(ponyform) Then Return New Point()

        If Oversized = False Then
            Return New Point(location.X - ponyform.Screen_to_Form_Translation.X, location.Y - ponyform.Screen_to_Form_Translation.Y)
        Else
            Return New Point(location.X - ponyform.Screen_to_Form_Translation.X - ((Oversize_Factor_For_Clipping * 0.5) * oversized_size.Width), _
                             location.Y - ponyform.Screen_to_Form_Translation.Y - ((Oversize_Factor_For_Clipping * 0.5) * oversized_size.Height))
        End If


    End Function

    Friend Function Get_Translated_Center(ponyform As PonyGraphicsForm)

        If IsNothing(ponyform) Then Return New Point()

        Dim my_center = GetImageCenter()

        Return New Point(location.X - ponyform.Screen_to_Form_Translation.X + my_center.X, location.Y - ponyform.Screen_to_Form_Translation.Y + my_center.Y)

    End Function

    Friend Sub SetLocationFromTranslated(mouse_location As Point, ponyform As PonyGraphicsForm)

        'When dragging, we want the pony's center to be at the mouse cursor (which is given in form-coordinates.
        'We need to translate back to screen coordinates here.

        Dim real_location = New Point(mouse_location.X + ponyform.Screen_to_Form_Translation.X, _
                            mouse_location.Y + ponyform.Screen_to_Form_Translation.Y)

        Dim current_center = Center()

        Dim x_difference As Integer = real_location.X - current_center.X
        Dim y_difference As Integer = real_location.Y - current_center.Y

        location = New Point(location.X + x_difference, location.Y + y_difference)

        Precise_X_Location = location.X
        Precise_Y_Location = location.Y

        Translated_Location = Translate_Current_Location(location, ponyform)

    End Sub

    Friend Sub Pony_Speak(Optional ByVal line As Pony.Behavior.Speaking_Line = Nothing)

        If IsNothing(PonyForm) Then Exit Sub

        'When hovering over with the mouse, don't talk more than once every x seconds.
        If IsNothing(line) AndAlso DateDiff(DateInterval.Second, LastSpoke, Now()) < 15 Then
            Exit Sub
        End If

        'don't speak when someone's right click menu is active - it would steal focus and close the menu.
        If My.Forms.Main.Right_Click_Menu_Active = True Then Exit Sub
        If My.Forms.Main.Dragging Then Exit Sub

        Dim selection = 0
        Dim line_to_speak As String = ""

        If Not IsNothing(line) Then
            line_to_speak = line.Text
            If line.SoundFile <> "" AndAlso Not My.Forms.Main.DisableSoundsDueToDirectXFailure Then
                Pony_PlaySound(line.SoundFile)
            End If
        Else
            If Lines_Random.Count = 0 Then
                Exit Sub
            Else
                selection = Math.Round(Rnd() * (Lines_Random.Count - 1), 0)
                line_to_speak = Lines_Random(selection).Text
                If Lines_Random(selection).SoundFile <> "" AndAlso Not My.Forms.Main.DisableSoundsDueToDirectXFailure Then
                    Pony_PlaySound(Lines_Random(selection).SoundFile)
                End If
            End If
        End If

        If My.Forms.Options.Disable_Speech.Checked = False Then

            ''we can't activate the tooltip unless we have focus.
            'Me.Focus()
            PonyForm.PonySpeak(Me.Name & ": " & ControlChars.Quote & line_to_speak & ControlChars.Quote, Me.Translated_Location)
            LastSpoke = Now()

        End If

    End Sub

    Private Sub Pony_PlaySound(ByVal filename As String)


        If My.Computer.FileSystem.FileExists(filename) Then

            If My.Forms.Options.Sounds_Enabled.Checked = False Then Exit Sub

            If My.Forms.Main.screen_saver_mode AndAlso My.Forms.Options.ScreenSaver_Sounds_Checkbox.Checked = False Then
                Exit Sub
            End If

            'don't play sounds over other ones - wait until they finish.

            If My.Forms.Options.Sounds_Per_Pony_Radio.Checked Then
                If Now.Subtract(Me.Audio_Last_Played).TotalMilliseconds <= Me.Last_Audio_Length Then Exit Sub
            Else
                If Now.Subtract(My.Forms.Main.Audio_Last_Played).TotalMilliseconds <= My.Forms.Main.Last_Audio_Length Then Exit Sub
            End If

            Try

                'If you get a MDA warning about loader locking - you'll just have to disable that exception message.  
                'Apparently it is a bug with DirectX that only occurs with Visual Studio...
                'We use DirectX now so that we can use MP3 instead of WAV files
                Dim audio As New Microsoft.DirectX.AudioVideoPlayback.Audio(filename)

                'volume is between -10000 and 0, with 0 being the loudest.
                audio.Volume = My.Forms.Options.Sound_Volume

                My.Forms.Main.Active_Sounds.Add(audio)

                audio.Play()

                If My.Forms.Options.Sounds_Per_Pony_Radio.Checked Then
                    Me.Last_Audio_Length = audio.Duration * 1000
                    Me.Audio_Last_Played = Now()
                Else
                    My.Forms.Main.Last_Audio_Length = audio.Duration * 1000 'to milliseconds
                    My.Forms.Main.Audio_Last_Played = Now()
                End If

            Catch ex As Exception
                If My.Forms.Main.Audio_Error_Shown = False AndAlso My.Forms.Main.screen_saver_mode = False Then
                    My.Forms.Main.Audio_Error_Shown = True
                    MsgBox("Error playing sound " & filename & " for " & Me.Name & ControlChars.NewLine _
                           & "Further sound errors will be suppressed." & ControlChars.NewLine & ex.Message)
                End If
            End Try

        End If
    End Sub

    Friend Sub Activate_Effects(translated_Location As Point, monitor_number As Integer)

        If My.Forms.Options.Effects_Enabled.Checked = True AndAlso My.Forms.Main.Right_Click_Menu_Active = False AndAlso sleeping = False _
          AndAlso My.Forms.Main.Dragging = False AndAlso Moving_Onscreen = False Then

            For Each effect In current_behavior.Effects

                If Now.Subtract(effect.last_used).TotalMilliseconds >= effect.Repeat_Delay * 1000 Then

                    If effect.Repeat_Delay = 0 Then
                        If effect.already_played_for_currentbehavior = True Then Continue For
                    End If

                    effect.already_played_for_currentbehavior = True

                    Dim new_effect As Behavior.effect = effect.duplicate()

                    If new_effect.Duration <> 0 Then
                        new_effect.end_time = Now.AddSeconds(new_effect.Duration)
                        new_effect.Close_On_New_Behavior = False
                    Else
                        If Me.Is_cursor_halted Then
                            new_effect.end_time = Now.AddSeconds(current_behavior.MaxDuration)
                        Else
                            new_effect.end_time = current_behavior.end_time
                        End If
                        new_effect.Close_On_New_Behavior = True
                    End If

                    'new_effect.Text = Name & "'s " & new_effect.name

                    If current_behavior.right Then
                        new_effect.direction = new_effect.placement_direction_right
                        new_effect.centering = new_effect.centering_right
                        new_effect.current_image = new_effect.Rightanimatedimage
                    Else
                        new_effect.direction = new_effect.placement_direction_left
                        new_effect.centering = new_effect.centering_left
                        new_effect.current_image = new_effect.Leftanimatedimage
                    End If

                    If new_effect.direction = Directions.random Then
                        new_effect.direction = Math.Round(Rnd() * ([Enum].GetValues(GetType(Directions)).Length - 2), 0)
                    End If
                    If new_effect.centering = Directions.random Then
                        new_effect.centering = Math.Round(Rnd() * ([Enum].GetValues(GetType(Directions)).Length - 2), 0)
                    End If

                    If new_effect.direction = Directions.random_not_center Then
                        new_effect.direction = Math.Round(Rnd() * ([Enum].GetValues(GetType(Directions)).Length - 3), 0)
                    End If
                    If new_effect.centering = Directions.random_not_center Then
                        new_effect.centering = Math.Round(Rnd() * ([Enum].GetValues(GetType(Directions)).Length - 3), 0)
                    End If

                    If (current_behavior.right) Then
                        new_effect.Facing_Left = False
                    Else
                        new_effect.Facing_Left = True
                    End If

                    new_effect.location = GetEffectLocation(new_effect.current_image.Size,
                     new_effect.direction, location, current_behavior.current_image.Size, new_effect.centering)
                    new_effect.PreUpdate_DrawAreas(monitor_number) = New Region(New Rectangle(Translate_Current_Location(new_effect.location, PonyForm), new_effect.current_image.Size))
                    new_effect.PostUpdate_DrawAreas(monitor_number) = New Region(New Rectangle(Translate_Current_Location(new_effect.location, PonyForm), new_effect.current_image.Size))

                    new_effect.behavior_name = current_behavior.Name

                    new_effect.Owning_Pony = Me

                    My.Forms.Main.Active_Effects.Add(new_effect)
                    Me.Active_Effects.Add(new_effect)

                    new_effect.start_time = My.Forms.Main.totalElaspedTime

                    'the following is NOT "new_effect" because the value is preserved in the original.
                    effect.last_used = Now()

                End If
            Next
        End If

    End Sub

    Overloads Sub Add_Behavior(ByVal Load_Images As Boolean, ByVal name As String, ByVal chance As Double, ByVal max_duration As Double, ByVal min_duration As Double, ByVal speed As Double, _
                     ByVal right_image_path As String, ByVal left_image_path As String, ByVal Allowed_Moves As Byte, _
                     ByVal _Linked_Behavior As String, ByVal _Startline As String, ByVal _Endline As String, Optional ByVal _skip As Boolean = False, _
                     Optional ByVal _xcoord As Integer = Nothing, Optional ByVal _ycoord As Integer = Nothing, Optional ByVal _object_to_follow As String = "", Optional ByVal _auto_select_images_on_follow As Boolean = True, _
                     Optional ByVal _follow_stopped_behavior As String = "", Optional ByVal _follow_moving_behavior As String = "", Optional ByVal right_image_center As Point = Nothing, Optional ByVal left_image_center As Point = Nothing, _
                     Optional _dont_repeat_image_animations As Boolean = False, Optional _group As Integer = 0)

        Dim new_behavior As New Behavior

        If Not My.Computer.FileSystem.FileExists(right_image_path) Then
            Throw New Exception("Image file does not exists for behavior " & name & " for pony " & Me.Name & ". Path: " & right_image_path)
        End If

        If Not My.Computer.FileSystem.FileExists(left_image_path) Then
            Throw New Exception("Image file does not exists for behavior " & name & " for pony " & Me.Name & ". Path: " & left_image_path)
        End If

        new_behavior.Name = Trim(name)
        new_behavior.Pony_Name = Me.Name
        new_behavior.chance_of_occurance = chance
        new_behavior.MaxDuration = max_duration
        new_behavior.MinDuration = min_duration
        new_behavior.Speed = speed
        new_behavior.original_speed = speed
        new_behavior.Allowed_Movement = Allowed_Moves
        new_behavior.dont_repeat_image_animations = _dont_repeat_image_animations
        new_behavior.Start_Line_Name = _Startline
        new_behavior.End_Line_Name = _Endline
        new_behavior.group = _group
        new_behavior.Skip = _skip

        'These cooridinates are either a position on the screen to go to, if no object to follow is specified,
        'or, the offset from the center of the object to go to (upper left, below, etc)
        new_behavior.destination_xcoord = _xcoord
        new_behavior.destination_ycoord = _ycoord

        new_behavior.follow_object_name = _object_to_follow
        new_behavior.Auto_Select_Images_On_Follow = _auto_select_images_on_follow

        'When the pony if offscreen we overwrite the follow parameters to get them onscreen again.
        'we save the original parameters here.
        new_behavior.original_destination_xcoord = _xcoord
        new_behavior.original_destination_ycoord = _ycoord
        new_behavior.original_follow_object_name = _object_to_follow

        new_behavior.follow_moving_behavior_name = _follow_moving_behavior
        new_behavior.follow_stopped_Behavior_name = _follow_stopped_behavior

        If _Linked_Behavior <> "" Then
            'We just record the name of the linked behavior for now
            'Later, when we call "Link_Behaviors()" from the main form, we 
            'will get references to the actual behaviors.
            new_behavior.Linked_Behavior_Name = _Linked_Behavior
        End If

        Dim new_images As New List(Of Image)
        Dim image_paths As New List(Of String)
        image_paths.Add(right_image_path)
        image_paths.Add(left_image_path)

        new_behavior.right_image_path = right_image_path
        new_behavior.left_image_path = left_image_path

        If Not IsNothing(right_image_center) AndAlso Not IsNothing(left_image_center) Then
            new_behavior.right_image_center = right_image_center
            new_behavior.left_image_center = left_image_center
        End If

        'if Load_Images = false then we delay loading them to memory until we are duplicated()
        If Load_Images = True Then

            Dim AlreadyLoaded = False

            For Each otherpony In My.Forms.Main.Active_Ponies
                If otherpony.Name = Me.Name Then
                    For Each otherponybehavior In otherpony.Behaviors
                        If otherponybehavior.Name = new_behavior.Name Then
                            If otherponybehavior.ImagesLoaded = True Then
                                new_behavior.Manager = otherponybehavior.Manager
                                new_behavior.RightImage = otherponybehavior.RightImage
                                new_behavior.LeftImage = otherponybehavior.LeftImage
                                AlreadyLoaded = True
                                Exit For
                            End If
                        End If
                    Next
                End If
                If AlreadyLoaded = True Then Exit For
            Next

            If AlreadyLoaded = False Then
                new_behavior.Manager = My.Forms.Main.manager
                new_behavior.LoadImages()
            End If

            new_behavior.current_image = new_behavior.RightImage

        End If

        Behaviors.Add(new_behavior)

    End Sub

    'This overload is in case the editor happens upon a very incomplete pony that has no behaviors (wasn't created by the editor).
    Overloads Sub Add_Behavior(ByVal name As String, ByVal chance As Double, ByVal max_duration As Double, ByVal min_duration As Double, ByVal speed As Double, _
                   ByVal right_image As Image, ByVal left_image As Image, ByVal Allowed_Moves As Byte, _
                   ByVal _Linked_Behavior As String, ByVal _Startline As String, ByVal _Endline As String)

        Dim new_behavior As New Behavior

        new_behavior.Name = Trim(name)
        new_behavior.Pony_Name = Me.Name
        new_behavior.chance_of_occurance = chance
        new_behavior.MaxDuration = max_duration
        new_behavior.MinDuration = min_duration
        new_behavior.speed = speed
        new_behavior.Allowed_Movement = Allowed_Moves

        new_behavior.Start_Line_Name = _Startline
        new_behavior.End_Line_Name = _Endline

        If _Linked_Behavior <> "" Then
            'We just record the name of the linked behavior for now
            'Later, when we call "Link_Behaviors()" from the main form, we 
            'will get references to the actual behaviors.
            new_behavior.Linked_Behavior_Name = _Linked_Behavior
        End If

        new_behavior.right_image_path = ""
        new_behavior.left_image_path = ""

        Behaviors.Add(new_behavior)

    End Sub

    'Find out if the linked behaviors actually exist, and get references to them.
    Friend Sub Link_Behaviors()

        For Each Behavior In Behaviors

            If Behavior.Linked_Behavior_Name = "" OrElse Behavior.Linked_Behavior_Name = "None" Then
                Behavior.Linked_Behavior = Nothing
            Else
                For Each other_Behavior As Behavior In Behaviors
                    If LCase(Behavior.Linked_Behavior_Name) = LCase(other_Behavior.Name) Then
                        Behavior.Linked_Behavior = other_Behavior
                        Exit For
                    End If
                Next
            End If


            If Behavior.End_Line_Name <> "" Then
                For Each line In Speaking_Lines
                    If LCase(Trim(line.Name)) = LCase(Trim(Behavior.End_Line_Name)) Then
                        Behavior.End_Line = line
                    End If
                Next
            End If

            If Behavior.Start_Line_Name <> "" Then
                For Each line In Speaking_Lines
                    If LCase(Trim(line.Name)) = LCase(Trim(Behavior.Start_Line_Name)) Then
                        Behavior.Start_Line = line
                    End If
                Next
            End If

            'link follow_behaviors
            If Behavior.follow_stopped_Behavior_name <> "" Then
                For Each other_Behavior As Behavior In Behaviors
                    If LCase(Behavior.follow_stopped_Behavior_name) = LCase(other_Behavior.Name) Then
                        Behavior.follow_stopped_Behavior = other_Behavior
                        Exit For
                    End If
                Next
            End If

            If Behavior.follow_moving_behavior_name <> "" Then
                For Each other_Behavior As Behavior In Behaviors
                    If LCase(Behavior.follow_moving_behavior_name) = LCase(other_Behavior.Name) Then
                        Behavior.follow_moving_behavior = other_Behavior
                        Exit For
                    End If
                Next
            End If

        Next

    End Sub

    'Decide what to do, move, and redraw our image.  The main loop.
    Friend Sub Update(ByVal elaspedTime As TimeSpan)

        If Behaviors.Count = 0 Then
            Exit Sub
        End If

        If should_be_sleeping Then

            If sleeping Then
                If BeingDragged Then

                    Dim center = current_image_center
                    Dim scale = GetScale()
                    If current_image_center = New Point Then
                        location = Cursor.Position - New Point(scale * (current_behavior.current_image.Size.Width) / 2, scale * (current_behavior.current_image.Size.Height) / 2)
                        Precise_X_Location = Cursor.Position.X - scale * (current_behavior.current_image.Size.Width) / 2
                        Precise_Y_Location = Cursor.Position.Y - scale * (current_behavior.current_image.Size.Height) / 2
                    Else
                        location = Cursor.Position - current_image_center
                        Precise_X_Location = Cursor.Position.X - current_image_center.X
                        Precise_Y_Location = Cursor.Position.Y - current_image_center.Y
                    End If

                End If
                Exit Sub
            Else
                sleep()
                Exit Sub
            End If

        Else
            If sleeping Then
                wake_up()
            End If
        End If

        If Moving_Onscreen AndAlso IsNothing(current_behavior) Then
            Moving_Onscreen = False
        End If

        If Not Playing_Game AndAlso Not Moving_Onscreen Then
            'In other parts of the code, setting the current behavior to nothing
            'means that we ran into some problem, and we should pick something else to do.
            If IsNothing(current_behavior) Then
                'For Each effect In Active_Effects
                '    If effect.Close_On_New_Behavior = True Then
                '        'effect.Close()
                '    End If
                'Next
                Cancel_Interaction()
                SelectBehavior()

                'If the time left on the current behavior as expired, and we are not in some special mode, end the behavior.
            ElseIf current_behavior.end_time.Subtract(Now()).TotalMilliseconds <= 0 AndAlso Cursor_Halt = False AndAlso Not ManualControl_P1 AndAlso Not ManualControl_P2 Then
                If Not IsNothing(current_behavior.End_Line) Then
                    Pony_Speak(current_behavior.End_Line)
                End If

                'Move to the next chain if there is one in a set of linked behaviors.
                If Not IsNothing(current_behavior.Linked_Behavior) Then
                    SelectBehavior(current_behavior.Linked_Behavior)
                Else
                    SelectBehavior()
                End If
                'If we are only halted because the cursor if hovering over us, re-play the behavior so that effects can continue if needed
            ElseIf current_behavior.end_time.Subtract(Now()).TotalMilliseconds <= 0 AndAlso Cursor_Halt = True AndAlso Not ManualControl_P1 AndAlso Not ManualControl_P2 Then
                SelectBehavior(current_behavior)
            End If


            'if we should be, or are halted because we are/were in the cursor's way, 
            'either go to mouseover mode, or come out of it.
            If Cursor_Halt OrElse Is_cursor_halted Then
                MouseOver_Mode()
            End If
        End If


        'Decide our next movement, and repaint
        Move()

        'This check ensures that animations restart from the first frame when appropriate.
        If Not IsNothing(current_behavior) AndAlso current_behavior.CS_choseNewBehaviour Then
            ActionStartTime = elaspedTime
            current_behavior.CS_choseNewBehaviour = False
        End If

    End Sub


    Friend Sub SelectBehavior(Optional ByRef Specified_Behavior As Behavior = Nothing)

        'If a pony has not been set in a valid group yet (just created), select a valid group.
        If Current_BehaviorGroup = -1 Then
            Dim groups As New List(Of Integer)

            For Each Behavior In Behaviors
                If Not groups.Contains(Behavior.Group) Then groups.Add(Behavior.Group)
            Next

            'Current_BehaviorGroup = groups(Rnd() * (groups.Count - 1))
            Current_BehaviorGroup = groups(0)
        End If


        'Having no specified behavior when interacting means we've run to the last part of a chain and should end the interaction.
        If Is_Interacting AndAlso Is_Interaction_Initiator AndAlso IsNothing(Specified_Behavior) Then Cancel_Interaction()

        Dim selection = 0

        If IsNothing(Specified_Behavior) Then

            'Pick a random behavior until we get one that works, or we take too long deciding.

            Dim loop_total = 0
            Do Until loop_total > 200
                loop_total += 1

                selection = Math.Round(Rnd() * (Behaviors.Count - 1), 0)

                'only pick a behavior if its chance matches the dice, and is one we can pick randomly.
                If Rnd() <= Behaviors(selection).chance_of_occurance AndAlso Behaviors(selection).Skip = False AndAlso _
                    (Behaviors(selection).Group = Current_BehaviorGroup OrElse Behaviors(selection).Group = 0) Then

                    'See if the behavior specifies that we follow another object
                    Behaviors(selection).follow_object = Nothing

                    If IsNothing(Current_Screen) Then
                        Current_Screen = My.Forms.Main.screens_to_use(0)
                    End If

                    Destination = Behaviors(selection).Get_Destination(Current_Screen, Me) ', Nothing)

                    If Destination = New Point AndAlso Behaviors(selection).follow_object_name <> "" Then
                        'we picked a behavior that is designed to follow other object, but that object doesn't exist.
                        'We can't do this now, so pick another behavior.
                        Continue Do
                    End If

                    'We've decided on a behavior
                    current_behavior = Behaviors(selection)
                    Exit Do
                End If

            Loop

            If loop_total > 200 Then
                'If we couldn't make up our minds and took to long, just pick the first one.
                current_behavior = Behaviors(0)
            End If

            ' Console.WriteLine(loop_total)
        Else
            Destination = Specified_Behavior.Get_Destination(Current_Screen, Me) ', Nothing)

            If Destination = New Point AndAlso Specified_Behavior.follow_object_name <> "" Then
                'We were told to do a specific behavior which follows an object, but that object doesn't exist.
                'Ignore the request, and go with a randomly selected behavior.
                'This will cancel an interaction if we were trying to run it.
                SelectBehavior()
                Exit Sub
            End If
            current_behavior = Specified_Behavior
            Current_BehaviorGroup = current_behavior.Group
            current_behavior.follow_object = Nothing
        End If

        For Each effect In current_behavior.Effects
            effect.already_played_for_currentbehavior = False
        Next

        current_behavior.end_time = Now.AddSeconds((Rnd() * (current_behavior.MaxDuration - current_behavior.MinDuration) + current_behavior.MinDuration))
        'reset animations to frame 0 (otherwise all ponies with the same behavior will be synced up animation wise)
        current_behavior.CS_choseNewBehaviour = True


        'Speak if the behavior says to, or on a random chance otherwise.
        If Not IsNothing(current_behavior.Start_Line) Then
            Pony_Speak(current_behavior.Start_Line)

            'Specified lines from behaviors should take precedence over random lines
            'Don't say a random line if we are following or have an ending line
            'or if we are interacting.
        ElseIf IsNothing(current_behavior.End_Line) AndAlso _
             current_behavior.follow_object_name = "" AndAlso _
             Rnd() <= My.Forms.Options.Pony_Speak_Chance_Counter.Value * 0.01 AndAlso
             Is_Interacting = False Then
            Pony_Speak()
        End If

        If (current_behavior.Allowed_Movement) = Allowed_Moves.None OrElse (current_behavior.Allowed_Movement) = Allowed_Moves.MouseOver _
            OrElse (current_behavior.Allowed_Movement) = Allowed_Moves.Sleep OrElse current_behavior.Allowed_Movement = Allowed_Moves.Dragged Then

            current_behavior.horizontal = False
            current_behavior.vertical = False

            'Do we face right or left?
            If Rnd() >= 0.5 Then
                current_behavior.right = True
            Else
                current_behavior.right = False
            End If
            Exit Sub
        End If

        'The rest of this function decides what direction we can/should go.
        Dim modes As New List(Of Allowed_Moves)
        If (current_behavior.Allowed_Movement And Allowed_Moves.Vertical_Only) = Allowed_Moves.Vertical_Only Then
            modes.Add(Allowed_Moves.Vertical_Only)
        End If
        If (current_behavior.Allowed_Movement And Allowed_Moves.Diagonal_Only) = Allowed_Moves.Diagonal_Only Then
            modes.Add(Allowed_Moves.Diagonal_Only)
        End If
        If (current_behavior.Allowed_Movement And Allowed_Moves.Horizontal_Only) = Allowed_Moves.Horizontal_Only Then
            modes.Add(Allowed_Moves.Horizontal_Only)
        End If

        If modes.Count = 0 Then
            Throw New Exception("Unhandled movement type in SelectBehavior(): " & current_behavior.Allowed_Movement)
        End If

        selection = Math.Round(Rnd() * (modes.Count - 1), 0)
        Dim selected_mode = modes(selection)

        If Rnd() >= 0.5 Then
            current_behavior.up = True
        Else
            current_behavior.up = False
        End If

        If Rnd() >= 0.5 Then
            current_behavior.right = True
        Else
            current_behavior.right = False
        End If

        Select Case selected_mode
            Case Allowed_Moves.Vertical_Only
                current_behavior.horizontal = False
                current_behavior.vertical = True
                current_behavior.diagonal = 0
            Case Allowed_Moves.Diagonal_Only
                current_behavior.horizontal = True
                current_behavior.vertical = True
                '(pick a random angle to go in)
                If current_behavior.up Then
                    current_behavior.diagonal = ((Rnd() * (50 - 15)) + 15) * (Math.PI / 180) ' converted to radians
                Else
                    current_behavior.diagonal = ((Rnd() * (345 - 310)) + 310) * (Math.PI / 180) ' converted to radians
                End If
                If current_behavior.right = False Then
                    current_behavior.diagonal = Math.PI - current_behavior.diagonal
                End If
            Case Allowed_Moves.Horizontal_Only
                current_behavior.horizontal = True
                current_behavior.vertical = False
                current_behavior.diagonal = 0
        End Select

    End Sub

    'Used when the mouse hovers over us.
    Sub MouseOver_Mode()

        'Should be halted, so halting now.
        If Cursor_Halt AndAlso Not Is_cursor_halted Then
            Is_cursor_halted = True

            previous_behavior = current_behavior

            current_behavior = GetAppropriateBehavior(Allowed_Moves.None, False)

            'Select a behavior one that is marked for mouseover mode
            For Each Behavior In Behaviors
                If Behavior.Group <> Current_BehaviorGroup Then Continue For
                If Behavior.Allowed_Movement = Allowed_Moves.MouseOver Then
                    current_behavior = Behavior
                    For Each effect In current_behavior.Effects
                        effect.already_played_for_currentbehavior = False
                    Next
                    Exit For
                End If
            Next

            Paint()

        End If

        'Returning out of being halted
        If Not Cursor_Halt And Is_cursor_halted Then

            current_behavior = previous_behavior
            Is_cursor_halted = False
            Paint()
        End If

    End Sub


    Friend Sub Move()

        If IsNothing(current_behavior) Then Exit Sub

        current_behavior.blocked = False

        If Cursor_Immunity > 0 Then Cursor_Immunity -= 1

        'Preview mode is used in the editor.
        If My.Forms.Main.Preview_Mode Then
            If Me.Name = My.Forms.Pony_Editor.Preview_Pony.Name Then

                My.Forms.Pony_Editor.current_behavior_label.Text = current_behavior.Name
                My.Forms.Pony_Editor.groupID_label.Text = Current_BehaviorGroup & " - " & GetBehaviorGroupName(Current_BehaviorGroup)
                My.Forms.Pony_Editor.current_behavior_timeleft_label.Text = DateDiff(DateInterval.Second, Now(), current_behavior.end_time)
            End If
        End If


        If Moving_Onscreen AndAlso My.Forms.Options.Teleport_Checkbox.Checked = True Then
            Stop_Moving_Onscreen()
            Exit Sub
        End If

        Dim current_location = New Point(Precise_X_Location, Precise_Y_Location)

        Dim speed As Double = current_behavior.Speed * GetScale()

        'If the user selected to "control" us via the right click menu, decide what to do based on keypresses.

        'if there is a game in progress, and it is in "setup", then override the take_control
        If IsNothing(My.Forms.Main.current_game) OrElse (Not IsNothing(My.Forms.Main.current_game) AndAlso My.Forms.Main.current_game.Status <> Game.GameStatus.Setup) Then
            If ManualControl_P1 Then
                current_behavior.diagonal = 0
                With My.Forms.Main

                    If Not Playing_Game AndAlso .PonyAction Then
                        Cursor_Halt = True
                        Paint() 'enable effects on mouseover.
                        Exit Sub
                    Else
                        'if we're not in the cursor's way, but still flagged that we are, exit mouseover mode.
                        If Is_cursor_halted Then
                            Cursor_Halt = False
                            Exit Sub
                        End If
                    End If

                    If Not .PonyUp AndAlso Not .PonyDown AndAlso Not .PonyRight AndAlso Not .PonyLeft Then
                        speed = 0
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.None, .PonySpeed)

                    ElseIf .PonyUp AndAlso .PonyRight Then
                        current_behavior.right = True
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.right = True
                        current_behavior.vertical = True
                        current_behavior.horizontal = True
                        current_behavior.up = True
                    ElseIf .PonyDown AndAlso .PonyRight Then
                        current_behavior.right = True
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.right = True
                        current_behavior.vertical = True
                        current_behavior.horizontal = True
                        current_behavior.up = False
                    ElseIf .PonyDown AndAlso .PonyLeft Then
                        current_behavior.right = False
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.right = False
                        current_behavior.vertical = True
                        current_behavior.horizontal = True
                        current_behavior.up = False
                    ElseIf .PonyUp AndAlso .PonyLeft Then
                        current_behavior.right = False
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.right = False
                        current_behavior.vertical = True
                        current_behavior.horizontal = True
                        current_behavior.up = True
                    ElseIf .PonyUp Then
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Vertical_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.vertical = True
                        current_behavior.horizontal = False
                        current_behavior.up = True
                    ElseIf .PonyDown Then
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Vertical_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.vertical = True
                        current_behavior.horizontal = False
                        current_behavior.up = False
                    ElseIf .PonyRight Then
                        current_behavior.right = True
                        current_behavior.right = True
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Horizontal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.vertical = False
                        current_behavior.horizontal = True
                    ElseIf .PonyLeft Then
                        current_behavior.right = False
                        current_behavior.right = False
                        current_behavior = GetAppropriateBehavior(Allowed_Moves.Horizontal_Only, .PonySpeed)
                        speed = current_behavior.Speed * GetScale()
                        current_behavior.vertical = False
                        current_behavior.horizontal = True
                    End If

                    If .PonySpeed Then
                        speed = current_behavior.Speed * 2 * GetScale()
                    End If

                End With

            Else
                If ManualControl_P2 Then
                    current_behavior.diagonal = 0
                    With My.Forms.Main

                        If Not Playing_Game AndAlso .PonyAction_2 Then
                            Cursor_Halt = True
                            Paint() 'enable effects on mouseover.
                            Exit Sub
                        Else
                            'if we're not in the cursor's way, but still flagged that we are, exit mouseover mode.
                            If Is_cursor_halted Then
                                Cursor_Halt = False
                                Exit Sub
                            End If
                        End If

                        If Not .PonyUp_2 AndAlso Not .PonyDown_2 AndAlso Not .PonyRight_2 AndAlso Not .PonyLeft_2 Then
                            speed = 0
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.None, .PonySpeed)

                        ElseIf .PonyUp_2 AndAlso .PonyRight_2 Then
                            current_behavior.right = True
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.right = True
                            current_behavior.vertical = True
                            current_behavior.horizontal = True
                            current_behavior.up = True
                        ElseIf .PonyDown_2 AndAlso .PonyRight_2 Then
                            current_behavior.right = True
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.right = True
                            current_behavior.vertical = True
                            current_behavior.horizontal = True
                            current_behavior.up = False
                        ElseIf .PonyDown_2 AndAlso .PonyLeft_2 Then
                            current_behavior.right = False
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.right = False
                            current_behavior.vertical = True
                            current_behavior.horizontal = True
                            current_behavior.up = False
                        ElseIf .PonyUp_2 AndAlso .PonyLeft_2 Then
                            current_behavior.right = False
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Diagonal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.right = False
                            current_behavior.vertical = True
                            current_behavior.horizontal = True
                            current_behavior.up = True
                        ElseIf .PonyUp_2 Then
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Vertical_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.vertical = True
                            current_behavior.horizontal = False
                            current_behavior.up = True
                        ElseIf .PonyDown_2 Then
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Vertical_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.vertical = True
                            current_behavior.horizontal = False
                            current_behavior.up = False
                        ElseIf .PonyRight_2 Then
                            current_behavior.right = True
                            current_behavior.right = True
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Horizontal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.vertical = False
                            current_behavior.horizontal = True
                        ElseIf .PonyLeft_2 Then
                            current_behavior.right = False
                            current_behavior.right = False
                            current_behavior = GetAppropriateBehavior(Allowed_Moves.Horizontal_Only, .PonySpeed)
                            speed = current_behavior.Speed * GetScale()
                            current_behavior.vertical = False
                            current_behavior.horizontal = True
                        End If

                        If .PonySpeed_2 Then
                            speed = current_behavior.Speed * 2 * GetScale()
                        End If

                    End With
                End If

            End If
        End If

        'If the behavior specified a follow object, or a point to go to, figure out where that is.
        Destination = current_behavior.Get_Destination(Current_Screen, Me)

        Dim x_movement As Double = 0
        Dim y_movement As Double = 0

        'don't follow a destination if we are under player control
        'unless, there is a game playing and it is in setup mode (the only time in a game we should ignore the player input).
        If (Not Destination = New Point() AndAlso Not ManualControl_P1 AndAlso Not ManualControl_P2) OrElse _
            (Not Destination = New Point() AndAlso Not IsNothing(My.Forms.Main.current_game) AndAlso My.Forms.Main.current_game.Status = Game.GameStatus.Setup) Then

            'We DO have a destination to go to

            'good old Pythagorean theorem
            Dim distance = Math.Sqrt((Center.X - Destination.X) ^ 2 + (Center.Y - Destination.Y) ^ 2)

            'avoid overflows
            If distance = 0 Then distance = 1

            Dim direction As List(Of Directions) = Get_Destination_Direction(Destination)

            If direction(0) = Directions.left Then
                current_behavior.right = False
                x_movement = ((Center.X - Destination.X) / (distance)) * -speed
            Else
                current_behavior.right = True
                x_movement = ((Destination.X - Center.X) / (distance)) * speed
            End If

            y_movement = ((Center.Y - Destination.Y) / (distance)) * -speed

            'we do not want to detect if we are at the destination if we are trying to move onscreen - we might stop at the destination and not
            'get out of the area we want to avoid.
            'However, we DO want to detect if we are extactly at our destination - our speed will go to 0 and we will be forever stuck there.

            If (distance <= 7) OrElse (Moving_Onscreen AndAlso Center() = Destination AndAlso x_movement = 0 AndAlso y_movement = 0) Then
                x_movement = 0
                y_movement = 0

                AtDestination = True
                If Moving_Onscreen Then
                    Stop_Moving_Onscreen()
                    Exit Sub
                End If

                'reached destination.

                If Going_Home Then
                    'don't dissapear immediately when reaching a "house" - wait a bit.
                    If Not Opening_Door Then
                        current_behavior.delay = 90
                        Opening_Door = True
                    Else
                        current_behavior.delay -= 1
                    End If
                Else
                    'If this behavior links to another, we should end this one so we can move on to the next link.
                    If Not IsNothing(current_behavior.Linked_Behavior) AndAlso current_behavior.Speed <> 0 Then
                        current_behavior.end_time = Now()

                        Destination = New Point()
                    End If
                End If

            Else
                'We're not yet at our destination

                'If we were marked as being at our destination in our last move,
                'if means the target moved slightly.  We should pause a bit before continuing to follow.
                If AtDestination = True Then
                    current_behavior.delay = 60
                End If

                'Only continue if the delay has expired.
                If current_behavior.delay > 0 Then
                    AtDestination = False
                    current_behavior.delay -= 1

                    Paint()
                    Exit Sub
                End If

                AtDestination = False

            End If

        Else

            'There is no destination, go whereever.

            If current_behavior.delay > 0 Then
                current_behavior.delay -= 1
                Paint()
                Exit Sub
            End If

            'if moving diagonally
            If current_behavior.diagonal <> 0 Then
                'Opposite = Hypotenuse * cosine of the angle
                x_movement = Math.Sqrt((speed ^ 2) * 2) * Math.Cos(current_behavior.diagonal)
                If x_movement < 0 Then
                    current_behavior.right = False
                Else
                    current_behavior.right = True
                End If
                'Adjacent = Hypotenuse * cosine of the angle
                '(negative because we are using pixel coordinates - down is positive)
                y_movement = -Math.Sqrt((speed ^ 2) * 2) * Math.Sin(current_behavior.diagonal)
            Else
                'if not
                x_movement = speed * Math.Abs(CInt(current_behavior.horizontal))
                y_movement = speed * Math.Abs(CInt(current_behavior.vertical))

                If Not current_behavior.right Then
                    x_movement = -x_movement
                End If

                If current_behavior.up = True Then
                    If y_movement > 0 Then
                        y_movement = -y_movement
                    End If
                Else
                    If y_movement < 0 Then
                        y_movement = -y_movement
                    End If
                End If

            End If


        End If


        Dim new_x_location = Precise_X_Location + x_movement
        Dim new_y_location = Precise_Y_Location + y_movement

        Dim new_location = New Point(new_x_location, new_y_location)

        Dim NearCursor_Now = IsPonyNearMouseCursor(current_location)
        ' Dim NearCursor_Now_all_Forms = IsPonyNearMouseCursor(current_location)
        Dim NearCursor_Future = IsPonyNearMouseCursor(new_location)
        '  Dim NearCursor_Future_All_Forms = IsPonyNearMouseCursor(new_location)

        Dim OnScreen_Now = IsPonyOnScreen(current_location, My.Forms.Main.screens_to_use)
        Dim OnScreen_Future = IsPonyOnScreen(new_location, My.Forms.Main.screens_to_use)

        'Dim Playing_Game_And_OutofBounds = ((Playing_Game AndAlso My.Forms.Main.current_game.Status <> Game.GameStatus.Setup) AndAlso Not IsPonyInBox(new_location, Position.Allowed_Area))
        Dim playing_game_and_outofbounds = False

        Dim EnteringWindow_Now = False
        ' Dim EnteringWindow_Future = False

        If My.Forms.Options.Window_Avoidance_Enabled.Checked AndAlso Moving_Onscreen = False Then
            EnteringWindow_Now = IsPonyEnteringWindow(current_location, new_location, x_movement, y_movement)
        End If

        Dim InAvoidanceZone_Now = IsPonyInAvoidanceArea(current_location)
        Dim InAvoidanceZone_Future = IsPonyInAvoidanceArea(new_location)

        'if we ARE currently in the cursor's zone, then say that we should be halted (cursor_halt), save our current behavior so we 
        'can continue later, and set the current behavior to nothing so it will be changed.
        If NearCursor_Now Then
            Cursor_Halt = True
            If Moving_Onscreen Then
                Stop_Moving_Onscreen() 'clear destination if moving_onscreen, otherwise we will get confused later.
            End If
            Paint() 'enable effects on mouseover.
            Pony_Speak()
            Exit Sub
        Else
            'if we're not in the cursor's way, but still flagged that we are, exit mouseover mode.
            If Is_cursor_halted AndAlso Not NearCursor_Now Then
                Cursor_Halt = False
                Cursor_Immunity = 30
                Exit Sub
            End If
        End If

        ' if we are heading into the cursor, change directions
        If NearCursor_Future Then
            Cursor_Halt = False

            Cursor_Immunity = 60

            'if we are moving to a destination, our path is blocked, and we need to abort the behavior
            'if we are just moving normally, just "bounce" off of the barrier.

            If Destination = New Point() Then
                current_behavior.Bounce(Me, current_location, new_location, x_movement, y_movement, Current_Screen)
            Else
                current_behavior = Nothing
            End If
            Exit Sub
        End If

        ''Check to see that we are moving off the screen, or into a zone we shouldn't (the zone set in the options or outside of our area when playing a game)
        If Moving_Onscreen OrElse (OnScreen_Future AndAlso Not InAvoidanceZone_Future AndAlso Not playing_game_and_outofbounds) Then

            If EnteringWindow_Now Then
                If Destination = New Point() Then
                    current_behavior.Bounce(Me, current_location, new_location, x_movement, y_movement, Current_Screen)
                Else
                    current_behavior = Nothing
                End If
                Exit Sub
            End If

            'everything's cool.  Move and repaint.



            location = new_location
            Precise_X_Location = new_x_location
            Precise_Y_Location = new_y_location
            Last_X_Movement = x_movement
            Last_Y_Movement = y_movement
            Current_Screen = Get_Current_Screen()
            MovingLeft = Not current_behavior.right

            Paint()

            'check to see if we should interact at all

            If My.Forms.Options.Interactions_Enabled.Checked AndAlso Is_Interacting = False AndAlso Moving_Onscreen = False Then
                Dim Interact As Interaction = Is_In_Interaction_Range()

                If Not IsNothing(Interact) Then
                    Start_Interaction(Interact)
                End If
            End If

            'If we were trying to get out of a bad spot, and we find ourselfs in a good area, continue on as normal...
            If Moving_Onscreen AndAlso OnScreen_Now AndAlso Not InAvoidanceZone_Future AndAlso Not playing_game_and_outofbounds Then
                Stop_Moving_Onscreen()
            Else

                'except if the user made changes to the avoidance area to include our current safespot (we were already trying to avoid the area),
                'then get a new safespot.

                If Moving_Onscreen Then
                    If IsPonyInAvoidanceArea(Destination) OrElse Not IsPonyOnScreen(Destination, My.Forms.Main.screens_to_use) Then
                        Dim safespot = FindSafeDestination()
                        current_behavior.destination_xcoord = safespot.X
                        current_behavior.destination_ycoord = safespot.Y
                    End If

                End If
            End If

            'if we were trying to get out of a bad area, but we are not moving, then continue on as normal.
            If Moving_Onscreen AndAlso current_behavior.Speed = 0 Then
                Stop_Moving_Onscreen()
            End If

            'We are done.
            Exit Sub

        Else

            'The new move puts us off screen or into a bad area!
            'Sanity check time - are we even on screen now?
            If InAvoidanceZone_Now OrElse Not OnScreen_Now Then
                'we are no where! Find out where it is safe to be and run!

                If My.Forms.Main.Preview_Mode OrElse My.Forms.Options.Teleport_Checkbox.Checked Then
                    Teleport()
                    Exit Sub
                End If

                Dim safespot = FindSafeDestination()

                Moving_Onscreen = True

                If current_behavior.Speed = 0 Then
                    current_behavior = GetAppropriateBehavior(Allowed_Moves.All, True)
                End If

                current_behavior.follow_object = Nothing
                current_behavior.follow_object_name = ""
                current_behavior.destination_xcoord = safespot.X
                current_behavior.destination_ycoord = safespot.Y

                Paint()

                current_behavior.CS_choseNewBehaviour = True

                Exit Sub
            End If

        End If

        'Nothing to worry about, we are on screen, but our current behavior would take us 
        ' off-screen in the next move.  Just do something else.
        'if we are moving to a destination, our path is blocked: we'll wait for a bit.
        'if we are just moving normally, just "bounce" off of the barrier.

        If Destination = New Point() Then
            current_behavior.Bounce(Me, current_location, new_location, x_movement, y_movement, Current_Screen)
            'we need to paint to reset the image centers
            Paint()
        Else
            If IsNothing(current_behavior.follow_object) Then
                current_behavior = Nothing
            Else
                'do nothing but stare longenly in the direction of the object we want to follow...
                current_behavior.blocked = True
                Paint()
            End If
        End If

    End Sub

    Sub Stop_Moving_Onscreen()
        Moving_Onscreen = False
        current_behavior.destination_xcoord = current_behavior.original_destination_xcoord
        current_behavior.destination_ycoord = current_behavior.original_destination_ycoord
        current_behavior.follow_object_name = current_behavior.original_follow_object_name
        current_behavior.CS_choseNewBehaviour = True
        Paint()
    End Sub

    'only used for debugging
    'Function SetDateAhead(ByRef time As DateTime)
    '    time = DateAdd(DateInterval.Year, 1, time)
    '    Return time
    'End Function

    Friend Function GetBehaviorGroupName(groupnumber As Integer) As String

        If groupnumber = 0 Then
            Return "Any"
        End If

        For Each group In BehaviorGroups
            If group.Number = groupnumber Then
                Return group.Name
            End If
        Next

        Return "Unnamed"

    End Function

    'Return our future location in one second if we go straight in the current direction
    Friend Function Future_Location(Optional ticks As Integer = 1000) As Point

        Dim Number_Of_Interations = ticks / My.Forms.Main.MoveTimer.Interval  'get the # of intervals in one second

        Return New Point(Precise_X_Location + (Last_X_Movement * Number_Of_Interations), Precise_Y_Location + (Last_Y_Movement * Number_Of_Interations))

    End Function

    Friend Sub Paint()

        Dim right_image As AnimatedImage = current_behavior.RightImage
        Dim left_image As AnimatedImage = current_behavior.LeftImage
        Dim right_image_center As Point = current_behavior.right_image_center
        Dim left_image_center As Point = current_behavior.left_image_center
        Dim alternate_left_animatedimage As AnimatedImage = Nothing
        Dim alternate_right_animatedimage As AnimatedImage = Nothing

        'If we are going to a particular point or following something, we need to pick the 
        'appropriate graphics to how we are moving instead of using what the behavior specifies.
        If Not Destination = New Point() AndAlso Not ManualControl_P1 AndAlso Not ManualControl_P2 Then ' AndAlso Not Playing_Game Then

            Dim horizontal = Math.Abs(Destination.X - Center.X)
            Dim vertical = Math.Abs(Destination.Y - Center.Y)
            Dim appropriate_behavior As Behavior = Nothing

            'We are supposed to be following, so say we can move any direction to do that.
            Dim allowed_movement = Allowed_Moves.All

            'if the distance to the destination is mostly horizontal, or mostly vertical, set the movement to either of those
            'This allows pegasi to fly up to reach their target instead of walking straight up.
            'This is weighted more on the vertical side for better effect
            If horizontal * 0.75 > vertical Then
                allowed_movement = allowed_movement And Allowed_Moves.Horizontal_Only
            Else
                allowed_movement = allowed_movement And Allowed_Moves.Vertical_Only
            End If

            Dim paint_stop_now As Boolean = paint_stop

            If AtDestination OrElse current_behavior.blocked OrElse current_behavior.speed = 0 OrElse current_behavior.delay > 0 Then
                allowed_movement = Allowed_Moves.None
                Paint_Stop = True

                'If at our destination, we want to allow one final animation change.  
                'However after that, we want to stop painting as we may be stuck in a left-right loop
                'Detect here if the destination is between the right and left image centers, which would cause flickering between the two.
                If paint_stop_now Then

                    If Destination.X >= left_image_center.X + location.X AndAlso Destination.X <= right_image_center.X + location.X Then
                        '  Console.WriteLine(Me.Name & " paint stopped")
                        Exit Sub
                    End If

                End If

            Else
                paint_stop = False
            End If

            If current_behavior.Auto_Select_Images_On_Follow = True OrElse IsNothing(current_behavior.follow_stopped_Behavior) OrElse IsNothing(current_behavior.follow_moving_behavior) Then
                appropriate_behavior = GetAppropriateBehavior(allowed_movement, True, Nothing)
            Else
                If allowed_movement = Allowed_Moves.None Then
                    appropriate_behavior = current_behavior.follow_stopped_Behavior
                Else
                    appropriate_behavior = current_behavior.follow_moving_behavior
                End If
            End If

            If IsNothing(appropriate_behavior) Then Throw New Exception("Couldn't find appropriate behavior for Paint() method on follow.")

            left_image = appropriate_behavior.LeftImage
            left_image_center = appropriate_behavior.left_image_center
            right_image = appropriate_behavior.RightImage
            right_image_center = appropriate_behavior.right_image_center

            alternate_left_animatedimage = appropriate_behavior.LeftImage
            alternate_right_animatedimage = appropriate_behavior.RightImage

            current_behavior.use_alternate_image = True
        Else
            current_behavior.use_alternate_image = False
            paint_stop = False
        End If

        Dim new_center As New Point

        If current_behavior.right Then
            current_behavior.current_image = right_image
            current_behavior.alternate_image = alternate_right_animatedimage
            new_center = New Point(GetScale() * right_image_center.X, GetScale() * right_image_center.Y)
        Else
            current_behavior.current_image = left_image
            current_behavior.alternate_image = alternate_left_animatedimage
            new_center = New Point(GetScale() * left_image_center.X, GetScale() * left_image_center.Y)
        End If

        If current_image_center = New Point Then
            current_image_center = new_center
        End If

        'reposition the form based on the new image center, if different:
        If Not IsNothing(current_behavior.current_image) AndAlso current_image_center <> New Point AndAlso current_image_center <> new_center Then

            Dim x_difference = new_center.X - current_image_center.X
            Dim y_difference = new_center.Y - current_image_center.Y

            location = New Point(location.X - x_difference, location.Y - y_difference)
            Precise_X_Location -= x_difference
            Precise_Y_Location -= y_difference

            current_image_center = new_center
        End If

        Dim Effects_to_Remove As New List(Of Pony.Behavior.effect)

        For Each effect As Pony.Behavior.effect In Me.Active_Effects
            If effect.Close_On_New_Behavior Then
                If current_behavior.Name <> effect.behavior_name Then
                    Effects_to_Remove.Add(effect)
                End If
            End If
        Next

        For Each effect In Effects_to_Remove
            Me.Active_Effects.Remove(effect)
            My.Forms.Main.Active_Effects.Remove(effect)
            My.Forms.Main.Dead_Effects.Add(effect)
        Next

    End Sub

    Friend Sub sleep()

        'Pick a sleep, mouseover, or 0 movement behavior, in that order.

        Dim sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.Sleep, False)

        If BeingDragged = False Then
            If sleep_behavior.Allowed_Movement <> Pony.Allowed_Moves.Sleep Then
                sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.MouseOver, False)
                If sleep_behavior.Allowed_Movement <> Pony.Allowed_Moves.MouseOver Then
                    sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.None, False)
                End If
            End If
        Else
            sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.Dragged, False)
            If sleep_behavior.Allowed_Movement <> Pony.Allowed_Moves.Dragged Then
                sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.Sleep, False)
                If sleep_behavior.Allowed_Movement <> Pony.Allowed_Moves.Sleep Then
                    sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.MouseOver, False)
                    If sleep_behavior.Allowed_Movement <> Pony.Allowed_Moves.MouseOver Then
                        sleep_behavior = GetAppropriateBehavior(Pony.Allowed_Moves.None, False)
                    End If
                End If
            End If
        End If

        SelectBehavior(sleep_behavior)
        current_behavior.end_time = Now().AddHours(8)
        Paint()
        sleeping = True
    End Sub

    Friend Sub wake_up()
        sleeping = False
        'If the user dragged us when all ponies were asleep and the timer wasn't running ("sleep all")
        'then the precision coordinates weren't updated.  Do that now.
        Precise_X_Location = location.X
        Precise_Y_Location = location.Y

        Cursor_Halt = False

        'Ponies added during sleep will not be initialized yet, so don't paint them.
        If Not IsNothing(current_behavior) Then
            current_behavior.end_time = Now
            Paint()
        End If

    End Sub

    'You can place effects at an offset to the pony, and also set them to the left or the right of themselves for big effects.
    Friend Function GetEffectLocation(ByRef EffectImageSize As Size, ByRef direction As Directions, ByRef ParentLocation As Point, ByRef ParentSize As Size, ByRef centering As Directions) As Point

        Dim point As Point = Nothing

        With New Size(ParentSize.Width * GetScale(), ParentSize.Height * GetScale())
            Select Case direction
                Case Directions.bottom
                    point = New Point(ParentLocation.X + .Width / 2, ParentLocation.Y + .Height)
                Case Directions.bottom_left
                    point = New Point(ParentLocation.X, ParentLocation.Y + .Height)
                Case Directions.bottom_right
                    point = New Point(ParentLocation.X + .Width, ParentLocation.Y + .Height)
                Case Directions.center
                    point = New Point(ParentLocation.X + .Width / 2, ParentLocation.Y + .Height / 2)
                Case Directions.left
                    point = New Point(ParentLocation.X, ParentLocation.Y + .Height / 2)
                Case Directions.right
                    point = New Point(ParentLocation.X + .Width, ParentLocation.Y + .Height / 2)
                Case Directions.top
                    point = New Point(ParentLocation.X + .Width / 2, ParentLocation.Y)
                Case Directions.top_left
                    point = New Point(ParentLocation.X, ParentLocation.Y)
                Case Directions.top_right
                    point = New Point(ParentLocation.X + .Width, ParentLocation.Y)
            End Select

        End With

        Dim effectscaling = My.Forms.Main.PonyScale

        Select Case centering
            Case Directions.bottom
                point = New Point(point.X - (effectscaling * EffectImageSize.Width) / 2, point.Y - (effectscaling * EffectImageSize.Height))
            Case Directions.bottom_left
                point = New Point(point.X, point.Y - (effectscaling * EffectImageSize.Height))
            Case Directions.bottom_right
                point = New Point(point.X - (effectscaling * EffectImageSize.Width), point.Y - (effectscaling * EffectImageSize.Height))
            Case Directions.center
                point = New Point(point.X - (effectscaling * EffectImageSize.Width) / 2, point.Y - (effectscaling * EffectImageSize.Height) / 2)
            Case Directions.left
                point = New Point(point.X, point.Y - (effectscaling * EffectImageSize.Height) / 2)
            Case Directions.right
                point = New Point(point.X - (effectscaling * EffectImageSize.Width), point.Y - (effectscaling * EffectImageSize.Height) / 2)
            Case Directions.top
                point = New Point(point.X - (effectscaling * EffectImageSize.Width) / 2, point.Y)
            Case Directions.top_left
                'no change
            Case Directions.top_right
                point = New Point(point.X - (effectscaling * EffectImageSize.Width), point.Y)
        End Select


        Return point

    End Function


    'Pick a behavior that matches the speed (fast or slow) and direction we want to go in.
    'Use the specified behavior if it works.
    Friend Function GetAppropriateBehavior(ByRef movement As Allowed_Moves, ByRef speed As Boolean, Optional ByRef specified_behavior As Behavior = Nothing) As Behavior

        Dim selected_behavior_speed As Integer = 0
        Dim selected_behavior As Behavior = current_behavior


        'does the current behavior work?
        If Not IsNothing(current_behavior) Then
            If (current_behavior.Allowed_Movement And movement) = movement OrElse movement = Allowed_Moves.All Then
                If current_behavior.speed = 0 AndAlso movement = Allowed_Moves.None Then
                    Return current_behavior
                End If
                If current_behavior.speed <> 0 AndAlso movement = Allowed_Moves.All Then
                    Return current_behavior
                End If
            End If
        Else
            selected_behavior = Behaviors(0)
        End If

        For Each Behavior As Behavior In Behaviors

            If Behavior.Group <> Current_BehaviorGroup Then Continue For

            If Behavior.Allowed_Movement = Allowed_Moves.Sleep AndAlso movement <> Allowed_Moves.Sleep AndAlso movement <> Allowed_Moves.Dragged Then
                Continue For
            End If

            'skip behaviors that are parts of a chain and shouldn't be used individually
            'however, when being dragged or sleeping, we may still need to consider these.
            If Behavior.Skip = True AndAlso movement <> Allowed_Moves.Dragged AndAlso movement <> Allowed_Moves.Sleep Then Continue For

            If (Behavior.Allowed_Movement And movement) = movement OrElse movement = Allowed_Moves.All Then

                If Behavior.speed = 0 AndAlso movement <> Allowed_Moves.All Then

                    If IsNothing(current_behavior) OrElse current_behavior.right Then
                        Behavior.right = True
                    Else
                        Behavior.right = False
                    End If

                    Return Behavior

                Else

                    'see if the specified behavior works.  If not, we'll find another.
                    If Not IsNothing(specified_behavior) Then
                        If (specified_behavior.Allowed_Movement And movement) = movement OrElse movement = Allowed_Moves.All Then

                            If Destination = New Point Then
                                If current_behavior.right = True Then
                                    specified_behavior.right = True
                                Else
                                    specified_behavior.right = False
                                End If
                            Else
                                If Get_Destination_Direction(Destination)(0) = Directions.right Then
                                    specified_behavior.right = True
                                Else
                                    specified_behavior.right = False
                                End If
                            End If

                            Return specified_behavior

                        End If
                    End If

                    'if this behavior as a destination or an object to follow, don't use it.
                    If (Behavior.destination_xcoord <> 0 OrElse Behavior.destination_ycoord <> 0 OrElse _
                        Behavior.follow_object_name <> "") AndAlso Not Playing_Game AndAlso Not Moving_Onscreen Then
                        Continue For
                    End If

                    'If the user is pressing shift while "taking control"
                    If speed Then
                        If Math.Abs(Behavior.speed) > selected_behavior_speed Then
                            selected_behavior = Behavior
                            selected_behavior_speed = Math.Abs(Behavior.speed)
                        End If
                    Else
                        If Behavior.speed <> 0 AndAlso (Math.Abs(Behavior.speed) < selected_behavior_speed OrElse (selected_behavior_speed = 0)) Then
                            selected_behavior_speed = Math.Abs(Behavior.speed)
                            selected_behavior = Behavior
                        End If
                    End If
                End If


            End If
        Next

        Return selected_behavior

    End Function

    Private Function Get_Current_Screen() As Screen

        For Each monitor In Screen.AllScreens
            If (Center.X >= monitor.Bounds.Left AndAlso Center.X <= monitor.Bounds.Right) AndAlso _
              (Center.Y >= monitor.Bounds.Top AndAlso Center.Y <= monitor.Bounds.Bottom) Then
                Return monitor
            End If
        Next
        Return Nothing
    End Function

    Function get_screen_by_point(point As Point) As Screen

        For Each Screen In My.Forms.Main.screens_to_use
            If (point.X >= Screen.Bounds.Left AndAlso point.X <= Screen.Bounds.Right) AndAlso _
              (point.Y >= Screen.Bounds.Top AndAlso point.Y <= Screen.Bounds.Bottom) Then
                Return Screen
            End If
        Next

        Return (My.Forms.Main.screens_to_use(0))

    End Function

    'Is the pony at least partially on any of the supplied screens?
    Friend Function IsPonyOnScreen(ByRef new_location As System.Drawing.Point, ByRef AllScreens As List(Of System.Windows.Forms.Screen)) As Boolean

        If My.Forms.Main.Preview_Mode Then
            Return True
        End If

        'we add or subtract ones to handle the case where the pony's speed is less than 1 and they are at a border.
        Dim points As New List(Of Point)

        Dim scale = GetScale()

        'add center (or upper right if no center is defined)
        points.Add(New Point(new_location.X + current_image_center.X, new_location.Y + current_image_center.Y))

        If current_behavior.up AndAlso current_behavior.right Then
            'add upper right corner
            points.Add(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y))
        End If

        If current_behavior.up AndAlso current_behavior.right = False Then
            'top left
            points.Add(new_location)
        End If

        If current_behavior.up = False AndAlso current_behavior.right Then
            'bottom right
            points.Add(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y + (scale * current_behavior.current_image.Size.Height)))
        End If

        If current_behavior.up = False AndAlso current_behavior.right = False Then
            'bottom left
            points.Add(New Point(new_location.X, new_location.Y + (scale * current_behavior.current_image.Size.Height)))
        End If

        For Each Point In points
            Dim ok = False
            For Each Screen In AllScreens
                If (Point.X >= Screen.Bounds.Left AndAlso Point.X <= Screen.Bounds.Right) AndAlso _
                  (Point.Y >= Screen.Bounds.Top AndAlso Point.Y <= Screen.Bounds.Bottom) Then
                    ok = True
                    Exit For
                End If
            Next
            If ok = False Then
                Return False
            End If
        Next

        'All still ok, on screen.
        Return True

    End Function

    'Is the pony at least partially on this screen?
    Friend Function IsPonyOnScreen(ByRef new_location As System.Drawing.Point, ByRef screen As Screen) As Boolean

        If My.Forms.Main.Preview_Mode Then
            Return True
        End If

        If IsNothing(current_behavior) Then Return False

        'we add or subtract ones to handle the case where the pony's speed is less than 1 and they are at a border.
        Dim points As New List(Of Point)

        Dim scale = GetScale()

        'add center (or upper right if no center is defined)
        points.Add(New Point(new_location.X + current_image_center.X, new_location.Y + current_image_center.Y))

        'add upper right corner
        points.Add(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y))


        'top left
        points.Add(new_location)

        'bottom right
        points.Add(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y + (scale * current_behavior.current_image.Size.Height)))


        'bottom left
        points.Add(New Point(new_location.X, new_location.Y + (scale * current_behavior.current_image.Size.Height)))

        Dim ok = False

        For Each Point In points
            If (Point.X >= screen.Bounds.Left AndAlso Point.X <= screen.Bounds.Right) AndAlso _
              (Point.Y >= screen.Bounds.Top AndAlso Point.Y <= screen.Bounds.Bottom) Then
                ok = True
                Exit For
            End If
        Next

        If ok = False Then
            Return False
        End If


        'All still ok, on screen.
        Return True

    End Function


    'Test to see if we overlapp with another application's window.
    Function IsPonyEnteringWindow(ByRef current_location As Point, ByRef new_location As Point, ByRef x_movement As Integer, ByRef y_movement As Integer) As Boolean

        Try
            If My.Forms.Main.Preview_Mode Then Return False
            If My.Forms.Options.Window_Avoidance_Enabled.Checked = False Then Return False

            If x_movement = 0 AndAlso y_movement = 0 Then Return False

            Dim scale = GetScale()

            Dim current_window_1 = WindowFromPoint(current_location)
            Dim current_window_2 = WindowFromPoint(New Point(current_location.X + (scale * current_behavior.current_image.Size.Width), current_location.Y + (scale * current_behavior.current_image.Size.Height)))
            Dim current_window_3 = WindowFromPoint(New Point(current_location.X + (scale * current_behavior.current_image.Size.Width), current_location.Y))
            Dim current_window_4 = WindowFromPoint(New Point(current_location.X, current_location.Y + (scale * current_behavior.current_image.Size.Height)))

            'the current position is already half-way between windows.  don't worry about it
            If current_window_1 <> current_window_2 OrElse current_window_1 <> current_window_3 OrElse current_window_1 <> current_window_4 Then
                Return False
            End If

            'find out where we are going
            Dim new_window_1 = 0  'top_left
            Dim new_window_2 = 0  'bottom_right
            Dim new_window_3 = 0  'top_right
            Dim new_window_4 = 0  'bottom_left

            Select Case x_movement
                Case Is > 0
                    new_window_2 = WindowFromPoint(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y + (scale * current_behavior.current_image.Size.Height)))
                    new_window_3 = WindowFromPoint(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y))
                Case Is < 0
                    new_window_1 = WindowFromPoint(new_location)
                    new_window_4 = WindowFromPoint(New Point(new_location.X, new_location.Y + (scale * current_behavior.current_image.Size.Height)))
            End Select

            Select Case y_movement
                Case Is > 0
                    If (new_window_2) = 0 Then new_window_2 = WindowFromPoint(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y + (scale * current_behavior.current_image.Size.Height)))
                    If (new_window_4) = 0 Then new_window_4 = WindowFromPoint(New Point(new_location.X, new_location.Y + (scale * current_behavior.current_image.Size.Height)))
                Case Is < 0
                    If (new_window_1) = 0 Then new_window_1 = WindowFromPoint(new_location)
                    If (new_window_3) = 0 Then new_window_3 = WindowFromPoint(New Point(new_location.X + (scale * current_behavior.current_image.Size.Width), new_location.Y))
            End Select


            Dim collision_windows As New List(Of Integer)

            If (new_window_1 <> 0 AndAlso new_window_1 <> current_window_1) Then collision_windows.Add(new_window_1)
            If (new_window_2 <> 0 AndAlso new_window_2 <> current_window_2) Then collision_windows.Add(new_window_2)
            If (new_window_3 <> 0 AndAlso new_window_3 <> current_window_3) Then collision_windows.Add(new_window_3)
            If (new_window_4 <> 0 AndAlso new_window_4 <> current_window_4) Then collision_windows.Add(new_window_4)

            If collision_windows.Count <> 0 Then

                Dim pony_collision_count = 0
                Dim ignored_collision_count = 0

                For Each collision In collision_windows

                    If Options.PoniesAvoidPonies.Checked AndAlso Options.PoniesStayInBoxes.Checked Then
                        Exit For
                    End If

                    Dim process_id As Integer = 0
                    GetWindowThreadProcessId(collision, process_id)

                    'ignore collisions with other ponies or effects
                    If Options.PoniesAvoidPonies.Checked AndAlso process_id = My.Forms.Main.process_id Then
                        pony_collision_count += 1
                    Else

                        'we are colliding with another window boundy.
                        'are we already inside of it, and therefore should go through to the outside?
                        'or are we on the outside, and need to stay out?

                        If Options.PoniesStayInBoxes.Checked Then Continue For

                        Dim Collision_RECT As New RECT
                        GetWindowRect(collision, Collision_RECT)

                        If IsPonyInBox(current_location, Collision_RECT) Then
                            ignored_collision_count += 1
                        End If

                    End If

                Next

                If pony_collision_count + ignored_collision_count = collision_windows.Count Then
                    Return False
                End If

                Return True
            Else
                Return False
            End If

        Catch ex As Exception
            My.Forms.Options.Window_Avoidance_Enabled.Checked = False
            MsgBox("Warning:  Error attempting to avoid windows.  Window avoidance disabled.  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
            Return False
        End Try

    End Function

    'is the current location insize the specified box?
    Function IsPonyInBox(ByRef location As Point, ByRef Box As RECT) As Boolean

        If Box.Bottom = 0 AndAlso Box.Left = 0 AndAlso Box.Top = 0 AndAlso Box.Right = 0 Then
            'empty box - don't consider it
            Return True
        End If

        If location.Y > Box.Top AndAlso location.Y < Box.Bottom Then
            If location.X > Box.Left AndAlso location.X < Box.Right Then
                Return True
            End If
        End If

        Return False
    End Function

    Shared Function IsPonyInBox(ByRef location As Point, ByRef Box As Rectangle) As Boolean

        If Box.Bottom = 0 AndAlso Box.Left = 0 AndAlso Box.Top = 0 AndAlso Box.Right = 0 Then
            'empty box - don't consider it
            Return True
        End If

        If location.Y > Box.Top AndAlso location.Y < Box.Bottom Then
            If location.X > Box.Left AndAlso location.X < Box.Right Then
                Return True
            End If
        End If

        Return False
    End Function

    ''are we inside the user specified "everfree forest"?
    Function IsPonyInAvoidanceArea(ByRef new_location As System.Drawing.Point) As Boolean

        If My.Forms.Main.Preview_Mode Then

            Dim Preview_Box As New RECT

            Dim preview_location = My.Forms.Pony_Editor.GetPreviewWindow_Location()

            If current_behavior.current_image.Size.Height > My.Forms.Pony_Editor.Pony_Preview_Panel.Size.Height OrElse _
                current_behavior.current_image.Size.Width > My.Forms.Pony_Editor.Pony_Preview_Panel.Size.Width Then
                Return False
            End If

            With My.Forms.Pony_Editor.Pony_Preview_Panel
                Preview_Box.Top = preview_location.Y
                Preview_Box.Bottom = preview_location.Y + .Size.Height
                Preview_Box.Left = preview_location.X
                Preview_Box.Right = preview_location.X + .Size.Width
            End With


            If IsPonyInBox(new_location, Preview_Box) AndAlso _
               IsPonyInBox(New Point(new_location.X, new_location.Y + current_behavior.current_image.Size.Height), Preview_Box) AndAlso _
               IsPonyInBox(New Point(new_location.X + current_behavior.current_image.Size.Width, new_location.Y), Preview_Box) AndAlso _
               IsPonyInBox(New Point(new_location.X + current_behavior.current_image.Size.Width, new_location.Y + current_behavior.current_image.Size.Height), Preview_Box) Then

                Return False
            Else
                Return True
            End If

        End If


        If IsNothing(current_behavior) Then Return False
        If IsNothing(Current_Screen) Then Return False

        If My.Forms.Options.Avoidance_Loc_X.Value = 0 AndAlso My.Forms.Options.Avoidance_Loc_Y.Value = 0 AndAlso _
           My.Forms.Options.Avoidance_Size_X.Value = 0 AndAlso My.Forms.Options.Avoidance_Size_Y.Value = 0 Then
            Return False
        End If

        Dim points As New List(Of Point)

        Dim scale = GetScale()

        'add center (or upper right if no center is defined)
        Dim center As Point = New Point(new_location.X + (scale * current_image_center.X), new_location.Y + (scale * current_image_center.Y))

        points.Add(New Point(center.X - 45, center.Y - 45)) 'top left
        points.Add(New Point(center.X + 45, center.Y - 45)) ' top right
        points.Add(New Point(center.X - 45, center.Y + 45)) 'bottom left
        points.Add(New Point(center.X + 45, center.Y + 45)) 'bottom right

        'return true if any of the points hit the bad area
        For Each Point In points

            Dim screen = get_screen_by_point(Point)

            Dim area As New Rectangle((0.01 * My.Forms.Options.Avoidance_Loc_X.Value) * screen.WorkingArea.Width + screen.WorkingArea.X, _
                                                 (0.01 * My.Forms.Options.Avoidance_Loc_Y.Value) * screen.WorkingArea.Height + screen.WorkingArea.Y, _
                                                 (0.01 * My.Forms.Options.Avoidance_Size_X.Value) * screen.WorkingArea.Width,
                                                 (0.01 * My.Forms.Options.Avoidance_Size_Y.Value) * screen.WorkingArea.Height)

            If ((Point.X > area.Left AndAlso Point.X < area.Right) AndAlso _
              (Point.Y > area.Top AndAlso Point.Y < area.Bottom)) Then
                Return True
            End If
        Next

        Return False
    End Function

    Function IsPonyNearMouseCursor(ByRef location As System.Drawing.Point) As Boolean

        If My.Forms.Options.Cursor_Avoidance_Enabled.Checked = False Then Return False
        If My.Forms.Main.screen_saver_mode = True Then Return False

        If Cursor_Immunity > 0 Then Return False

        'ignore this if we are interacting - we don't want to cancel it.
        If Me.Is_Interacting = True Then Return False

        If ManualControl_P1 OrElse ManualControl_P2 Then Return False

        With My.Forms.Main

            Dim forbidden_zone As New Point(Cursor.Position.X, Cursor.Position.Y)

            Dim pony_locations = MouseOverCenters(location)

            For Each pony_location In pony_locations
                Dim distance = Math.Sqrt((pony_location.X - forbidden_zone.X) ^ 2 + (pony_location.Y - forbidden_zone.Y) ^ 2)

                If distance <= .cursor_zone_size Then
                    Return True
                End If
            Next

        End With

        Return False

    End Function

    'We don't use me.location here as we may be testing another location! (the next or current one)
    Friend Function MouseOverCenters(ByVal testing_point As Point) As List(Of Point)

        Dim points As New List(Of Point)

        Dim scale = GetScale()

        For Each behavior In Behaviors
            If behavior.Allowed_Movement = Pony.Allowed_Moves.MouseOver Then
                If current_behavior.right AndAlso behavior.right_image_center <> New Point() Then
                    points.Add(New Point(testing_point.X + (scale * (behavior.right_image_center.X)), testing_point.Y + (scale * (behavior.right_image_center.Y))))
                Else
                    points.Add(New Point(testing_point.X + (scale * (Behaviors(0).RightImage.Size.Width)) / 2, _
                      testing_point.Y + (scale * (Behaviors(0).RightImage.Size.Height)) / 2))
                End If

                If Not current_behavior.right AndAlso behavior.left_image_center <> New Point() Then
                    points.Add(New Point(testing_point.X + (scale * (behavior.left_image_center.X)), testing_point.Y + (scale * (behavior.left_image_center.Y))))
                Else
                    points.Add(New Point(testing_point.X + (scale * (Behaviors(0).LeftImage.Size.Width)) / 2, _
                          testing_point.Y + (scale * (Behaviors(0).LeftImage.Size.Height)) / 2))
                End If
            End If
        Next

        Return points


    End Function

    Friend Sub Teleport()

        If My.Forms.Main.Preview_Mode Then
            Dim preview_center = My.Forms.Pony_Editor.GetPreviewWindow_Location()
            location = New Point(preview_center.X + 10, preview_center.Y + 10)
            Precise_X_Location = preview_center.X + 10
            Precise_Y_Location = preview_center.Y + 10
            Exit Sub
        End If

        Dim UsableScreens = My.Forms.Main.screens_to_use

        Dim dice = 0
        Dim random_screen As Screen = Nothing
        Dim teleport_location As Point = New Point()


        For tries = 0 To 300
            dice = Math.Round(Rnd() * (UsableScreens.Count - 1), 0)

            random_screen = UsableScreens(dice)
            teleport_location = New Point(random_screen.WorkingArea.X + Math.Round(Rnd() * random_screen.WorkingArea.Width, 0), random_screen.WorkingArea.Y + Math.Round(Rnd() * random_screen.WorkingArea.Height, 0))

            If IsPonyInAvoidanceArea(teleport_location) = False Then
                Exit For
            End If

        Next

        location = teleport_location
        Precise_X_Location = location.X
        Precise_Y_Location = location.Y

    End Sub


    'Find a spot on the screen that the pony is allowed to be (similar to teleport, but just reports the point found).
    Friend Function FindSafeDestination() As Point

        If My.Forms.Main.Preview_Mode Then
            Dim preview_center = My.Forms.Pony_Editor.GetPreviewWindow_Location()
            Return New Point(preview_center.X + 10, preview_center.Y + 10)
        End If

        Dim UsableScreens = My.Forms.Main.screens_to_use

        Dim teleport_location As Point = Nothing

        Dim closest As Integer = Integer.MaxValue

        If teleport_location = Nothing Then

            Dim dice = 0
            Dim random_screen As Screen = Nothing
            teleport_location = New Point()


            For tries = 0 To 300
                dice = Math.Round(Rnd() * (UsableScreens.Count - 1), 0)

                random_screen = UsableScreens(dice)
                teleport_location = New Point(random_screen.WorkingArea.X + Math.Round(Rnd() * random_screen.WorkingArea.Width, 0), random_screen.WorkingArea.Y + Math.Round(Rnd() * random_screen.WorkingArea.Height, 0))

                If IsPonyInAvoidanceArea(teleport_location) = False Then Exit For
            Next
        End If

        Return teleport_location

    End Function

    Friend Sub SetLines(ByVal speaking_lines As List(Of Pony.Behavior.Speaking_Line))

        Lines_Specific.Clear()
        Lines_Random.Clear()

        For Each line In speaking_lines

            If line.Skip = True Then
                Lines_Specific.Add(line)
            Else
                Lines_Random.Add(line)
            End If

        Next

    End Sub

    'New ponies are duplicated from the master copies created when loading the files.
    Friend Function Duplicate() As Pony

        Dim newpony As New Pony(Name, New List(Of Behavior.Speaking_Line), Path_to_Files, PonyScale, ID, BehaviorGroups)

        Dim new_speaking_lines As New List(Of Pony.Behavior.Speaking_Line)

        For Each line In Speaking_Lines
            new_speaking_lines.Add(line.duplicate)
        Next

        newpony.SetLines(new_speaking_lines)
        newpony.Speaking_Lines = new_speaking_lines

        For Each Behavior In Behaviors
            With Behavior
                'note that the first parameter is true to note that we should load all images this time.
                'the "selectable_ponies" are just templates with only 1 image loaded for the menu.
                'Ponies created through .duplicate will be true ponies that need all their images.
                newpony.Add_Behavior(True, .Name, .chance_of_occurance, .MaxDuration_d, .MinDuration_d, .speed_d, .right_image_path, .left_image_path, .Allowed_Movement, .Linked_Behavior_Name, .Start_Line_Name, .End_Line_Name, _
                                     .Skip, .destination_xcoord, .destination_ycoord, .follow_object_name, .Auto_Select_Images_On_Follow, .follow_stopped_Behavior_name, .follow_moving_behavior_name, .right_image_center, .left_image_center, .dont_repeat_image_animations, .Group)
            End With
        Next

        newpony.Link_Behaviors()

        For Each Behavior In Behaviors
            For Each new_behavior In newpony.Behaviors
                If Behavior.Name = new_behavior.Name Then
                    For Each effect In Behavior.Effects
                        Try
                            new_behavior.Effects.Add(effect.duplicate())
                        Catch ex As Exception
                            MsgBox("Unable to load images for effect: " & effect.name & " Details: " & ex.Message)
                        End Try
                    Next
                    Exit For
                End If
            Next
        Next

        For Each Interaction In Interactions
            With Interaction

                Dim targets = .Targets_String
                Dim behaviors = .getBehaviors

                If targets = "" OrElse behaviors = "" Then
                    Continue For
                End If

                newpony.add_Interaction(Interaction.Name, newpony.Name, .Probability, .Proximity_Activation_Distance, targets, .Select_All_Targets, behaviors, .Reactivation_Delay, True)
            End With
        Next

        For Each category In Tags
            newpony.Tags.Add(category)
        Next

        Return newpony

    End Function

    Friend Function Get_Destination_Direction(ByRef destination As Point) As List(Of Directions)

        Dim direction As New List(Of Directions)

        Dim scale = GetScale()

        Dim right_image_center = New Point(location.X + (scale * current_behavior.right_image_center.X), location.Y + (scale * current_behavior.right_image_center.Y))
        Dim left_image_center = New Point(location.X + (scale * current_behavior.left_image_center.X), location.Y + (scale * current_behavior.left_image_center.Y))

        If right_image_center.X > destination.X AndAlso left_image_center.X < destination.X Then
            direction.Add(Directions.left)
        Else
            If destination.X - Center.X <= 0 Then
                direction.Add(Directions.left)
            Else
                direction.Add(Directions.right)
            End If
        End If

        If (right_image_center.Y > destination.Y AndAlso left_image_center.Y < destination.Y) OrElse _
           (right_image_center.Y < destination.Y AndAlso left_image_center.Y > destination.Y) Then
            direction.Add(Directions.top)
        Else
            If destination.Y - Center.Y <= 0 Then
                direction.Add(Directions.top)
            Else
                direction.Add(Directions.bottom)
            End If
        End If
        direction.Add(Directions.left)
        direction.Add(Directions.top)
        Return direction

    End Function

    Friend Function Center() As Point

        Dim image_center As Point = GetImageCenter()

        If image_center = New Point AndAlso Not IsNothing(current_behavior) AndAlso Not IsNothing(current_behavior.current_image) Then
            Dim scale = GetScale()
            image_center = New Point((scale * (current_behavior.current_image.Size.Width) / 2), (scale * (current_behavior.current_image.Size.Height) / 2))
        End If

        Return New Point(Me.location.X + image_center.X, Me.location.Y + image_center.Y)

    End Function

    Friend Sub add_Interaction(ByVal interaction_name As String, ByVal name As String, ByVal probability As Double, ByVal proximity As String, _
                               ByVal target_list As String, ByVal target_selection As String, _
                               ByVal behaviorlist As String, ByVal repeat_delay As Integer, ByVal displaywarnings As Boolean)

        Dim new_interaction As New Interaction

        new_interaction.Name = interaction_name
        new_interaction.Targets_String = target_list
        new_interaction.PonyName = name
        new_interaction.Probability = probability
        new_interaction.Reactivation_Delay = repeat_delay

        Select Case LCase(Trim(target_selection))
            Case "all"
                new_interaction.Select_All_Targets = True
            Case "random"
                new_interaction.Select_All_Targets = False
            Case "true"
                new_interaction.Select_All_Targets = True
            Case "false"
                new_interaction.Select_All_Targets = False
            Case Else
                If Not My.Forms.Main.screen_saver_mode Then
                    Throw New Exception("Invalid option for target selection. Use either 'random' or 'all'." _
                                        & ControlChars.NewLine & " Interaction file specified: " & target_selection & _
                                        " for interaction named: " & interaction_name)
                Else
                    Exit Sub
                End If

        End Select

        Select Case LCase(Trim(proximity))
            Case "default"
            Case Else
                If IsNumeric(proximity) Then
                    new_interaction.Proximity_Activation_Distance = proximity
                Else
                    If Not My.Forms.Main.screen_saver_mode Then
                        Throw New Exception("Invalid option for proximity. Enter either a number or 'default'." _
                                    & " Interaction file specified: '" & proximity & "'")
                    Else
                        Exit Sub
                    End If
                End If
        End Select

        Dim targets = SplitWithQualifiers(target_list, ",", ControlChars.Quote)
        Dim interaction_behaviors = SplitWithQualifiers(behaviorlist, ",", ControlChars.Quote)

        For Each iBehavior In interaction_behaviors

            Dim found = False

            For Each Behavior In Me.Behaviors
                If LCase(Trim(Behavior.Name)) = LCase(Trim(iBehavior)) Then
                    new_interaction.Behavior_List.Add(Behavior)
                    found = True
                End If
            Next
            If found = False AndAlso My.Forms.Options.Interaction_Errors_Displayed.Checked AndAlso Not My.Forms.Main.screen_saver_mode Then
                MsgBox("Warning: Pony '" & Me.Name & "' does not have required behavior '" & iBehavior & "' for interaction: '" & _
                       interaction_name & "'. This interaction is disabled.")
                Exit Sub
            End If
        Next

        Dim ok_targets As New List(Of String)

        For Each target In targets

            Dim ponyfound = False

            For Each Pony In Main.Selectable_Ponies

                If LCase(Trim(target)) = LCase(Trim(Pony.Name)) Then
                    ponyfound = True

                    ok_targets.Add(Pony.Name)

                    For Each Behavior In interaction_behaviors

                        Dim found = False

                        For Each ponybehavior In Pony.Behaviors
                            If Trim(LCase(Behavior)) = Trim(LCase(ponybehavior.Name)) Then
                                found = True
                                Exit For
                            End If
                        Next

                        If found = False Then
                            ok_targets.Remove(Pony.Name)
                            If displaywarnings AndAlso Not My.Forms.Main.screen_saver_mode Then
                                MsgBox("Warning:  Pony " & Pony.Name & " (" & Pony.Path_to_Files & ") " & _
                                " does not have required behavior '" & _
                               Behavior & "' as specified in interaction " & interaction_name & _
                               ControlChars.NewLine & "Interaction is disabled for this pony.")
                            End If
                        End If

                    Next
                End If
            Next

            If ponyfound = False AndAlso displaywarnings AndAlso Not My.Forms.Main.screen_saver_mode Then

                MsgBox("Warning: There is no pony with name " & target & " loaded.  Interaction '" & name & _
                       "' has this pony listed as a target.")
            End If
        Next

        'the displaywarnings = false part of the next line handles the case when we are viewing one pony in the editor.
        If (ok_targets.Count <> 0 AndAlso new_interaction.Behavior_List.Count <> 0) OrElse displaywarnings = False Then
            For Each PonyName In ok_targets
                new_interaction.Interacts_With_Names.Add(PonyName)
            Next

            Interactions.Add(new_interaction)
        End If

    End Sub

    'Make a lists of targest from what ponies exist, and get their references.
    Friend Sub Initialize_Interactions()

        For Each Interaction In Interactions

            Interaction.Interacts_With.Clear()

            For Each Name As String In Interaction.Interacts_With_Names
                For Each Pony In Main.Active_Ponies
                    If Name = Pony.Name Then

                        Dim already_added = False
                        For Each other_Pony In Interaction.Interacts_With
                            If ReferenceEquals(other_Pony, Pony) Then
                                already_added = True
                                Exit For
                            End If
                        Next

                        If already_added = True Then
                            Continue For
                        End If

                        Interaction.Interacts_With.Add(Pony)
                    End If
                Next
            Next
        Next

    End Sub

    Sub Cancel_Interaction()

        Is_Interacting = False

        If IsNothing(Current_Interaction) Then Exit Sub

        If Me.Is_Interaction_Initiator Then
            For Each Pony In Current_Interaction.Interacts_With

                'Check to see if we are interacting with ourselves.  If so, avoid an infinite loop
                If ReferenceEquals(Me, Pony) Then
                    Continue For
                End If

                'check that the other pony is actually in an interaction
                If IsNothing(Pony.Current_Interaction) Then
                    Continue For
                End If

                'check to make sure that I am the initiator of the interation that this pony is running
                'Note:  Without this check, multiple sets of the same pony interacting with themselves will cause
                'an infinite recusion.
                If Not IsNothing(Pony.Current_Interaction.Initiator) AndAlso ReferenceEquals(Pony.Current_Interaction.Initiator, Me) Then
                    Pony.Cancel_Interaction()
                End If
            Next
        End If

        Interaction_Delay_Until = Now.AddSeconds(Current_Interaction.Reactivation_Delay)

        Current_Interaction = Nothing
        Is_Interaction_Initiator = False

    End Sub

    Friend Sub Start_Interaction(ByRef interaction As Interaction)

        Is_Interaction_Initiator = True
        Current_Interaction = interaction
        Me.SelectBehavior(interaction.Behavior_List(Math.Round(Rnd() * (interaction.Behavior_List.Count - 1))))

        'do we interact with ALL targets, including copies, or just the pony that we ran into?
        If interaction.Select_All_Targets = True Then
            For Each Pony In interaction.Interacts_With
                Pony.Start_Interaction_As_Target(current_behavior.Name, Me, interaction)
            Next
        Else
            interaction.Trigger.Start_Interaction_As_Target(current_behavior.Name, Me, interaction)
        End If


        Is_Interacting = True

    End Sub

    Friend Sub Start_Interaction_As_Target(ByRef BehaviorName As String, ByRef initiator As Pony, ByVal interaction As Interaction)


        For Each Behavior In Behaviors
            If BehaviorName = Behavior.Name Then
                Me.SelectBehavior(Behavior)
                Exit For
            End If
        Next

        interaction.Initiator = initiator
        Is_Interaction_Initiator = False
        Current_Interaction = interaction
        Is_Interacting = True

    End Sub

    Function Is_In_Interaction_Range() As Interaction

        'If we recently ran an interaction, don't start a new one until the delay expires.
        If DateDiff(DateInterval.Second, Now(), Interaction_Delay_Until) > 0 Then
            Return Nothing
        End If


        For Each Interaction As Interaction In Interactions

            For Each target As Pony In Interaction.Interacts_With

                'don't start an interaction if we or the target haven't finished loading yet
                If IsNothing(current_behavior.current_image) OrElse IsNothing(target.current_behavior) OrElse IsNothing(target.current_behavior.current_image) Then
                    Continue For
                End If

                'Don't start a new interaction for ponies aready in one.
                If target.Is_Interacting = True Then
                    Continue For
                End If

                'Ponies shouldn't interact with themselves
                If ReferenceEquals(target, Me) = True Then
                    Continue For
                End If

                Dim distance = Math.Sqrt(((location.X + (current_behavior.current_image.Size.Width / 2)) - (target.location.X + (target.current_behavior.current_image.Width / 2))) ^ 2 _
                                         + ((location.Y + (current_behavior.current_image.Size.Height / 2)) - (target.location.Y + (target.current_behavior.current_image.Height / 2))) ^ 2)

                If distance <= Interaction.Proximity_Activation_Distance Then

                    Dim dice = Rnd()

                    If dice <= Interaction.Probability Then
                        Interaction.Trigger = target
                        Return Interaction
                    End If

                End If

            Next

        Next

        Return Nothing

    End Function

    'The oversize option overestimates the size of the image by a %, used for the pre and post update areas to avoid clipping
    Friend Function ImageScale(ByVal size As Size, Optional oversize As Boolean = False) As Size

        Dim scale = GetScale()

        If oversize Then
            scale *= 1 + Oversize_Factor_For_Clipping 'normally gives 50% buffer
        End If

        Return New Size(size.Width * scale, size.Height * scale)

    End Function

    Friend Function GetScale() As Double

        Dim scale As Double = 1

        If PonyScale <> 0 Then
            scale = Me.PonyScale
        Else
            scale = My.Forms.Main.PonyScale
        End If

        Return scale

    End Function

    Friend Function GetImageCenter() As Point

        Dim scale = GetScale()

        If current_image_center = New Point Then
            If Not IsNothing(current_behavior) AndAlso Not IsNothing(current_behavior.current_image) Then
                Return New Point(scale * (current_behavior.current_image.Size.Width / 2), scale * (current_behavior.current_image.Size.Height / 2))
            End If
        Else

            Return New Point(current_image_center.X, current_image_center.Y)
        End If



    End Function

    Class Interaction

        Friend Name As String
        Friend PonyName As String
        Friend Probability As Double
        Friend Proximity_Activation_Distance As Double = 125 'the distance to the target inside of which we start the interaction.

        Friend Targets_String As String = ""

        Friend Select_All_Targets As Boolean
        Friend Behavior_List As New List(Of Behavior)

        Friend Interacts_With As New List(Of Pony)
        Friend Interacts_With_Names As New List(Of String)

        Friend Trigger As Pony = Nothing  'The pony we ran into that cause us to start
        Friend Initiator As Pony = Nothing 'The main pony than runs around waiting until she runs into a target.


        Friend Reactivation_Delay As Integer = 60 'in seconds

        Function getBehaviors() As String

            If Behavior_List.Count = 0 Then Return ""

            Dim behaviors_list As String = ""

            For Each behavior As Behavior In Behavior_List
                behaviors_list += behavior.Name & ","
            Next

            Return Mid(behaviors_list, 1, behaviors_list.Length - 1)

        End Function



    End Class


    Class Behavior

        Friend Name As String
        Friend Pony_Name As String
        Friend chance_of_occurance As Double
        Friend MaxDuration_d As Double 'seconds
        Friend MinDuration_d As Double 'seconds

        Friend Property MaxDuration() As Double
            Get
                Return MaxDuration_d * My.Forms.Options.SlowDownFactor
            End Get
            Set(value As Double)
                MaxDuration_d = value
            End Set
        End Property

        Friend Property MinDuration() As Double
            Get
                Return MinDuration_d * My.Forms.Options.SlowDownFactor
            End Get
            Set(value As Double)
                MinDuration_d = value
            End Set
        End Property

        Friend speed_d As Double

        Friend Property Speed() As Double
            Get
                Return speed_d / My.Forms.Options.SlowDownFactor
            End Get
            Set(value As Double)
                speed_d = value
            End Set
        End Property

        Friend original_speed As Double

        Friend current_image As AnimatedImage

        Friend right_image_path As String
        Friend right_image_center As Point
        Friend left_image_path As String
        Friend left_image_center As Point
        Friend use_alternate_image As Boolean = False
        Friend alternate_image As AnimatedImage

        Friend dont_repeat_image_animations As Boolean = False

        Friend Allowed_Movement As Byte 'See the enumeration of the same name for more information.

        Friend end_time As DateTime = Now()
        Friend vertical As Boolean = False
        Friend horizontal As Boolean = False
        Friend up As Boolean = False
        Friend right As Boolean = True
        Friend diagonal As Double = 0 'the angle to travel in, if moving diagonally (in radians)

        Friend Linked_Behavior_Name As String = ""
        Friend Linked_Behavior As Behavior = Nothing

        Friend Start_Line_Name As String = ""
        Friend End_Line_Name As String = ""

        Friend Start_Line As Speaking_Line = Nothing
        Friend End_Line As Speaking_Line = Nothing

        Friend Skip As Boolean = False

        Friend destination_xcoord As Integer = 0
        Friend destination_ycoord As Integer = 0
        Friend follow_object_name As String = ""
        Friend follow_object As Object

        Friend original_destination_xcoord As Integer = 0
        Friend original_destination_ycoord As Integer = 0
        Friend original_follow_object_name As String = ""

        Friend follow_stopped_Behavior_name As String = ""
        Friend follow_moving_behavior_name As String = ""
        Friend follow_stopped_Behavior As Behavior = Nothing
        Friend follow_moving_behavior As Behavior = Nothing
        Friend Auto_Select_Images_On_Follow As Boolean = True
        Friend Group As Integer = 0 'the group # this behavior belongs to

        'Try to get the point where an object is going to, and go to that instead of where it is currently at.
        Friend lead_target As Boolean = False

        'Used when following.
        Friend delay As Integer = 0
        Friend blocked = False

        Friend CS_choseNewBehaviour = False

        Friend Effects As New List(Of effect)

        ''' <summary>
        ''' Indicates the manager handling images on behalf of this action, if set.
        ''' </summary>
        Friend Manager As ImageManager
        ''' <summary>
        ''' Indicates if the images for this action have been loaded.
        ''' </summary>
        Friend ImagesLoaded As Boolean
        ''' <summary>
        ''' The filename for the image used when the pony is facing left.
        ''' </summary>
        Public ReadOnly LeftImageName As String
        ''' <summary>
        ''' The image used when the pony is facing left.
        ''' </summary>
        Public LeftImage As AnimatedImage
        ''' <summary>
        ''' The filename for the image used when the pony is facing right.
        ''' </summary>
        Public ReadOnly RightImageName As String
        ''' <summary>
        ''' The image used when the pony is facing right.
        ''' </summary>
        Public RightImage As AnimatedImage


        ''' <summary>
        ''' Loads the left and right images for the action, if they have not been loaded.
        ''' </summary>
        Public Sub LoadImages()
            If (ImagesLoaded = False) Then
                If (Manager IsNot Nothing) Then
                    LeftImage = Manager.ImageFromFile(left_image_path)
                    RightImage = Manager.ImageFromFile(right_image_path)
                Else
                    LeftImage = New animatedimage(left_image_path)
                    RightImage = New animatedimage(right_image_path)
                End If
                ImagesLoaded = True
            End If
        End Sub

        ''' <summary>
        ''' Unloads the left and right images for the action, if they have been loaded.
        ''' </summary>
        Public Sub UnloadImages()
            If (ImagesLoaded) Then
                If (Manager IsNot Nothing) Then
                    Manager.UnloadImages()
                Else
                    LeftImage.Dispose()
                    RightImage.Dispose()
                End If
                LeftImage = Nothing
                RightImage = Nothing
                ImagesLoaded = False
            End If
        End Sub

        ''' <summary>
        ''' Draws the image for the current action with given parameters.
        ''' </summary>
        ''' <param name="g">The graphics context onto which to draw the pony.</param>
        ''' <param name="x">The x co-ordinate of the location to draw the left corner of the image.</param>
        ''' <param name="y">The y co-ordinate of the location to draw the left corner of the image.</param>
        ''' <param name="elaspedTime">The image time to use, which determines the frame selected in an animated image.</param>
        ''' <param name="facingLeft">The direction the pony is currently facing.</param>
        Function Draw(ByVal g As Graphics, ByVal x As Integer, ByVal y As Integer, ByVal elaspedTime As TimeSpan, ByVal facingLeft As Boolean, scale As Double, ponyform As PonyGraphicsForm) As Bitmap

            Dim bitmap As Bitmap = Nothing

            If use_alternate_image Then
                bitmap = alternate_image.Draw(g, x, y, elaspedTime, False, scale, dont_repeat_image_animations)
            Else
                If (facingLeft) Then
                    bitmap = LeftImage.Draw(g, x, y, elaspedTime, False, scale, dont_repeat_image_animations)
                Else
                    bitmap = RightImage.Draw(g, x, y, elaspedTime, False, scale, dont_repeat_image_animations)
                End If
            End If

            Return bitmap

        End Function

        'reverse directions as if we were bouncing off a boundry.
        Friend Sub Bounce(ByRef pony As Pony, ByRef current_location As Point, ByRef new_location As Point, ByVal x_movement As Double, ByVal y_movement As Double, ByRef current_screen As Screen)

            If x_movement = 0 AndAlso y_movement = 0 Then
                Exit Sub
            End If

            'if we are moving in a simple direction (up/down, left/right) just reverse direction
            If x_movement = 0 AndAlso y_movement <> 0 Then
                up = Not up
                If diagonal <> 0 Then
                    diagonal = 2 * Math.PI - diagonal
                End If
                Exit Sub
            End If
            If x_movement <> 0 AndAlso y_movement = 0 Then
                right = Not right
                If diagonal <> 0 Then
                    diagonal = Math.PI - diagonal
                End If
                Exit Sub
            End If

            'if we were moving in a composite direction, we need to determine which component is bad

            Dim x_bad = False
            Dim y_bad = False


            Dim new_location_x As New Point(new_location.X, current_location.Y)
            Dim new_location_y As New Point(current_location.X, new_location.Y)


            If x_movement AndAlso y_movement Then

                If Not pony.IsPonyOnScreen(new_location_x, My.Forms.Main.screens_to_use) OrElse pony.IsPonyInAvoidanceArea(new_location_x) _
                    OrElse pony.IsPonyEnteringWindow(current_location, new_location_x, x_movement, 0) Then
                    x_bad = True
                End If

                If Not pony.IsPonyOnScreen(new_location_y, My.Forms.Main.screens_to_use) OrElse pony.IsPonyInAvoidanceArea(new_location_y) _
                    OrElse pony.IsPonyEnteringWindow(current_location, new_location_y, 0, y_movement) Then
                    y_bad = True
                End If

            End If

            If Not x_bad AndAlso Not y_bad Then
                up = Not up
                right = Not right
                If diagonal <> 0 Then
                    diagonal = Math.PI - diagonal
                    diagonal = 2 * Math.PI - diagonal
                End If
                Exit Sub
            End If

            If x_bad AndAlso y_bad Then
                up = Not up
                right = Not right
                If diagonal <> 0 Then
                    diagonal = Math.PI - diagonal
                    diagonal = 2 * Math.PI - diagonal
                End If
                Exit Sub
            End If

            If x_bad Then
                right = Not right
                If diagonal <> 0 Then
                    diagonal = Math.PI - diagonal
                End If
                Exit Sub
            End If
            If y_bad Then
                up = Not up
                If diagonal <> 0 Then
                    diagonal = 2 * Math.PI - diagonal
                End If
            End If

        End Sub

        Friend Function Get_Destination(ByRef screen As Screen, ByRef pony As Pony) As Point

            'if we are offscreen and trying to get back on, just return the pre-calculated coordinates.
            If pony.Moving_Onscreen Then
                Return New Point(destination_xcoord, destination_ycoord)
            End If

            'If being recalled to a house
            If pony.Going_Home Then
                Return pony.Destination
            End If

            'If we should be following something, but we don't know what yet, select a pony/effect to follow
            If (follow_object_name <> "" AndAlso IsNothing(follow_object)) Then

                'If we are interacting, and the name of the pony we should be followig matches that of the trigger, follow that one.
                'Otherwise, we may end up following the wrong copy if there are more than one.
                If pony.Is_Interacting AndAlso Trim(LCase(follow_object_name)) = Trim(LCase(pony.Current_Interaction.Trigger.Name)) Then
                    follow_object = pony.Current_Interaction.Trigger
                    Return New Point(pony.Current_Interaction.Trigger.Center.X + destination_xcoord, pony.Current_Interaction.Trigger.Center.Y + destination_ycoord)
                End If
                'For the reverse case of a trigger pony trying to find out which initiator to follow when interacting.
                If pony.Is_Interacting AndAlso Not IsNothing(pony.Current_Interaction.Initiator) AndAlso Trim(LCase(follow_object_name)) = Trim(LCase(pony.Current_Interaction.Initiator.Name)) Then
                    follow_object = pony.Current_Interaction.Initiator
                    Return New Point(pony.Current_Interaction.Initiator.location.X + destination_xcoord, pony.Current_Interaction.Initiator.location.Y + destination_ycoord)
                End If

                'If not interacting, or following a different pony, we need to figure out which one.

                Dim ponies_to_follow As New List(Of Pony)

                With My.Forms.Main

                    Dim found = False

                    For Each pony In .Active_Ponies
                        If LCase(pony.Name) = LCase(follow_object_name) Then
                            ponies_to_follow.Add(pony)
                            found = True
                        End If
                    Next

                    If ponies_to_follow.Count <> 0 Then

                        'pick a random copy if there is more than one.
                        Dim dice = Math.Round(Rnd() * (ponies_to_follow.Count - 1), 0)
                        follow_object = ponies_to_follow(dice)
                        Return New Point(ponies_to_follow(dice).location.X + destination_xcoord, ponies_to_follow(dice).location.Y + destination_ycoord)

                    End If

                    'Apparently we are not following a pony, but an effect...

                    Dim effects_to_follow As New List(Of effect)

                    For Each effect In My.Forms.Main.Active_Effects
                        If LCase(effect.name) = follow_object_name Then
                            effects_to_follow.Add(effect)
                            found = True
                        End If
                    Next

                    If found = False Then

                        'We didn't find a match, so stop.
                        Return New Point()

                    End If

                    If effects_to_follow.Count <> 0 Then

                        Dim dice = Math.Round(Rnd() * (effects_to_follow.Count - 1), 0)
                        follow_object = effects_to_follow(dice)
                        Return New Point(effects_to_follow(dice).location.X + destination_xcoord, effects_to_follow(dice).location.Y + destination_ycoord)

                    End If

                End With
            End If

            If Not IsNothing(follow_object) Then
                'We've already selected an object to follow previously.
                If follow_object.GetType() Is GetType(Pony) Then
                    Dim follow_pony As Pony = DirectCast(follow_object, Pony)
                    If lead_target Then
                        Return follow_pony.Future_Location()
                    Else
                        Return New Point(follow_pony.Center.X + (follow_pony.GetScale() * destination_xcoord), _
                                         follow_pony.Center.Y + (follow_pony.GetScale() * destination_ycoord))
                    End If

                Else
                    Dim follow_effect As effect = DirectCast(follow_object, Pony.Behavior.effect)
                    Return New Point(follow_effect.Center.X + destination_xcoord, follow_effect.Center.Y + destination_ycoord)
                End If
            End If

            'We are not following an object, but going to a point on the screen.
            If Not IsNothing(screen) AndAlso destination_xcoord <> 0 AndAlso destination_ycoord <> 0 Then
                Return New Point(0.01 * destination_xcoord * screen.WorkingArea.Width + screen.WorkingArea.X, _
                                 0.01 * destination_ycoord * screen.WorkingArea.Height + screen.WorkingArea.Y)
            End If

            'no destination
            Return New Point()

        End Function

        Friend Sub AddEffect(ByVal effectname As String, ByVal right_path As String, ByVal left_path As String, ByVal duration As Double, ByVal repeat_delay As Double, _
                             ByVal direction_right As Directions, ByVal centering_right As Directions, _
                             ByVal direction_left As Directions, ByVal centering_left As Directions, ByVal follow As Boolean, _dont_repeat_image_animations As Boolean, _
                             Optional ByVal load_images_now As Boolean = False)

            Dim new_effect As New effect

            new_effect.behavior_name = Me.Name
            new_effect.Pony_Name = Me.Pony_Name
            new_effect.name = effectname
            new_effect.right_image_path = right_path
            new_effect.left_image_path = left_path
            new_effect.Duration = duration
            new_effect.Repeat_Delay = repeat_delay
            new_effect.placement_direction_right = direction_right
            new_effect.centering_right = centering_right
            new_effect.placement_direction_left = direction_left
            new_effect.centering_left = centering_left
            new_effect.follow = follow
            new_effect.dont_repeat_image_animations = _dont_repeat_image_animations

            If load_images_now = True Then
                new_effect.Manager = My.Forms.Main.manager
                new_effect.LoadImages()
            End If

            Effects.Add(new_effect)

        End Sub


        Class Speaking_Line

            Friend Name As String = ""
            Friend Text As String = ""
            Friend SoundFile As String = ""
            Friend Skip As Boolean = False 'don't use randomly if true
            Friend Group As Integer = 0 'the behavior group that this line is assigned to.  0 = all

            Friend Sub New(ByVal ponyname As String, ByVal _name As String, ByVal _text As String, ByVal _path As String, ByVal _soundfile As String, ByVal _skip As Boolean, _group As Integer)

                Name = _name
                Text = _text
                Skip = _skip
                Group = _group

                If _soundfile <> "" AndAlso Not My.Computer.FileSystem.FileExists(_path & _soundfile) Then
                    MsgBox("Error loading sound file for speaking line " & Name & " for pony " & ponyname & ControlChars.NewLine _
                           & "Sound file: " & SoundFile & " does not exist. (Speaking_Line.New())")
                    Exit Sub
                End If

                If _soundfile <> "" Then
                    SoundFile = _path & _soundfile
                End If

            End Sub

            Friend Function duplicate() As Speaking_Line
                Return New Speaking_Line("", Name, Text, "", SoundFile, Skip, Group)
            End Function

        End Class

        Class effect

            Friend name As String = ""
            Friend location As New Point()
            Friend translated_location As New Point()

            Friend beingDragged As Boolean = False

            Friend PreUpdate_DrawAreas As Region() = New Region(Screen.AllScreens.Count - 1) {}
            Friend PostUpdate_DrawAreas As Region() = New Region(Screen.AllScreens.Count - 1) {}

            Friend current_image As AnimatedImage

            Friend dont_repeat_image_animations As Boolean = False

            Friend behavior_name As String
            Friend Pony_Name As String
            Friend Owning_Pony As Pony
          
            Friend right_image_path As String
            Friend left_image_path As String
            Friend duration_d As Double

            Friend Property Duration() As Double
                Get
                    Return duration_d * My.Forms.Options.SlowDownFactor
                End Get
                Set(value As Double)
                    duration_d = value
                End Set
            End Property

            Friend repeat_delay_d As Double

            Friend Property Repeat_Delay() As Double
                Get
                    Return repeat_delay_d * My.Forms.Options.SlowDownFactor
                End Get
                Set(value As Double)
                    repeat_delay_d = value
                End Set
            End Property



            Friend placement_direction_right As Directions
            Friend centering_right As Directions
            Friend placement_direction_left As Directions
            Friend centering_left As Directions

            Friend centering As Directions
            Friend direction As Directions

            Friend Facing_Left As Boolean = False

            Friend current_bitmap As Bitmap

            Friend start_time As TimeSpan
            Friend end_time As DateTime
            Friend Close_On_New_Behavior As Boolean = False

            Friend follow = False

            Friend last_used As DateTime = Now()
            Friend already_played_for_currentbehavior As Boolean = False

            ''' <summary>
            ''' Indicates the manager handling images on behalf of this action, if set.
            ''' </summary>
            Friend Manager As ImageManager
            ''' <summary>
            ''' Indicates if the images for this action have been loaded.
            ''' </summary>
            Friend ImagesLoaded As Boolean
            ''' <summary>
            ''' The filename for the image used when the pony is facing left.
            ''' </summary>
            Public ReadOnly LeftImageName As String
            ''' <summary>
            ''' The image used when the pony is facing left.
            ''' </summary>
            Public Leftanimatedimage As AnimatedImage
            ''' <summary>
            ''' The filename for the image used when the pony is facing right.
            ''' </summary>
            Public ReadOnly RightImageName As String
            ''' <summary>
            ''' The image used when the pony is facing right.
            ''' </summary>
            Public Rightanimatedimage As AnimatedImage

            ''' <summary>
            ''' Draws the image for the current action with given parameters.
            ''' </summary>
            ''' <param name="g">The graphics context onto which to draw the pony.</param>
            Sub Draw(ByVal g As Graphics, elapsedTime As TimeSpan, scale As Double)

                Dim bitmap As Bitmap = Nothing

                If (Facing_Left) Then
                    bitmap = Leftanimatedimage.Draw(g, translated_location.X, translated_location.Y, elapsedTime.Subtract(start_time), False, scale, dont_repeat_image_animations)
                Else
                    bitmap = Rightanimatedimage.Draw(g, translated_location.X, translated_location.Y, elapsedTime.Subtract(start_time), False, scale, dont_repeat_image_animations)
                End If

                Me.current_bitmap = bitmap
            End Sub

            Sub Teleport()

                Dim UsableScreens = My.Forms.Main.screens_to_use

                Dim dice = 0
                Dim random_screen As Screen = Nothing
                Dim teleport_location As Point = New Point()


                '  For tries = 0 To 300
                dice = Math.Round(Rnd() * (UsableScreens.Count - 1), 0)

                random_screen = UsableScreens(dice)
                teleport_location = New Point(random_screen.WorkingArea.X + Math.Round(Rnd() * (random_screen.WorkingArea.Width - Leftanimatedimage.Size.Width), 0), random_screen.WorkingArea.Y + Math.Round(Rnd() * (random_screen.WorkingArea.Height - Leftanimatedimage.Size.Height), 0))

                'If IsPonyOnScreen(teleport_location) = False Then
                '    Exit For
                'End If

                'Next

                location = teleport_location

            End Sub

            ''' <summary>
            ''' Loads the left and right images for the action, if they have not been loaded.
            ''' </summary>
            Public Sub LoadImages()
                If (ImagesLoaded = False) Then
                    If (Manager IsNot Nothing) Then
                        Leftanimatedimage = Manager.ImageFromFile(left_image_path)
                        Rightanimatedimage = Manager.ImageFromFile(right_image_path)
                    Else
                        Leftanimatedimage = New animatedimage(left_image_path)
                        Rightanimatedimage = New animatedimage(right_image_path)
                    End If
                    ImagesLoaded = True
                End If
            End Sub

            ''' <summary>
            ''' Unloads the left and right images for the action, if they have been loaded.
            ''' </summary>
            Public Sub UnloadImages()
                If (ImagesLoaded) Then
                    If (Manager IsNot Nothing) Then
                        Manager.UnloadImages()

                    Else
                        Leftanimatedimage.Dispose()
                        Rightanimatedimage.Dispose()
                    End If
                    Leftanimatedimage = Nothing
                    Rightanimatedimage = Nothing
                    ImagesLoaded = False
                End If
            End Sub

            Overridable Function duplicate() As effect

                Dim new_effect As New effect

                new_effect.name = name
                new_effect.behavior_name = behavior_name

                new_effect.Pony_Name = Pony_Name
            
                new_effect.right_image_path = right_image_path
                new_effect.left_image_path = left_image_path
                new_effect.Duration = duration_d
                new_effect.Repeat_Delay = repeat_delay_d
                new_effect.placement_direction_right = placement_direction_right
                new_effect.centering_right = centering_right
                new_effect.placement_direction_left = placement_direction_left
                new_effect.centering_left = centering_left

                new_effect.dont_repeat_image_animations = dont_repeat_image_animations

                new_effect.follow = follow

                new_effect.last_used = last_used
                new_effect.already_played_for_currentbehavior = already_played_for_currentbehavior

                Dim already_loaded As Boolean = False
                For Each Pony In My.Forms.Main.Active_Ponies
                    If Pony.Name <> new_effect.Pony_Name Then Continue For

                    For Each Behavior In Pony.Behaviors
                        For Each effect In Behavior.Effects
                            If effect.name <> new_effect.name Then
                                Continue For
                            End If

                            If effect.ImagesLoaded Then
                                already_loaded = True

                                new_effect.Manager = effect.Manager
                                new_effect.Rightanimatedimage = effect.Rightanimatedimage
                                new_effect.Leftanimatedimage = effect.Leftanimatedimage

                                Exit For
                            End If

                        Next
                        If already_loaded = True Then
                            Exit For
                        End If
                    Next
                    If already_loaded = True Then
                        Exit For
                    End If
                Next

                If already_loaded = False Then
                    new_effect.Manager = My.Forms.Main.manager
                    new_effect.LoadImages()
                End If

                Return new_effect

            End Function

            Friend Function Center() As Point
                Dim scale As Double

                If Not IsNothing(Owning_Pony) Then
                    scale = Owning_Pony.GetScale()
                Else
                    scale = 1
                End If

                If IsNothing(current_image) Then

                    If Not IsNothing(Leftanimatedimage) Then
                        Return New Point(Me.location.X + ((scale * Leftanimatedimage.Size.Width) / 2), Me.location.Y + ((scale * Leftanimatedimage.Size.Height) / 2))
                    End If

                    If Not IsNothing(Rightanimatedimage) Then
                        Return New Point(Me.location.X + ((scale * Rightanimatedimage.Size.Width) / 2), Me.location.Y + ((scale * Rightanimatedimage.Size.Height) / 2))
                    End If

                    Return location
                End If


                Return New Point(Me.location.X + ((scale * current_image.Size.Width) / 2), Me.location.Y + ((scale * current_image.Size.Height) / 2))
            End Function

        End Class

    End Class

   

    Friend Class PonyComparer_ScreenHeight
        Implements IEqualityComparer(Of Pony)
        Implements IComparer(Of Pony)


        Public Function Equals1(ByVal Pony As Pony, ByVal OtherPony As Pony) As Boolean Implements IEqualityComparer(Of Pony).Equals

            If IsNothing(Pony.current_behavior) Then Return True
            If IsNothing(OtherPony.current_behavior) Then Return True

            If Pony.ID = OtherPony.ID Then
                Return True
            End If

            Return False

        End Function

        Public Function IEquals1(ByVal Pony As Pony, ByVal OtherPony As Pony) As Integer Implements IComparer(Of Pony).Compare

            If IsNothing(Pony.current_behavior) Then Return 0
            If IsNothing(OtherPony.current_behavior) Then Return 0

            Dim Pony1 = Pony.Precise_Y_Location + Pony.ImageScale(Pony.current_behavior.current_image.Size).Height
            Dim Pony2 = OtherPony.Precise_Y_Location + OtherPony.ImageScale(Pony.current_behavior.current_image.Size).Height

            If Pony1 > Pony2 Then
                Return 1
            End If

            If Pony1 < Pony2 Then
                Return -1
            End If

            If Pony.ID > OtherPony.ID Then
                Return 1
            End If

            If Pony.ID < OtherPony.ID Then
                Return -1
            End If

            Return 0

        End Function

        Public Function GetHashCode1(ByVal Pony As Pony) As Integer Implements IEqualityComparer(Of Pony).GetHashCode
            Return Pony.ID
        End Function

    End Class

    Friend Class PonyComparer_Name
        Implements IEqualityComparer(Of Pony)
        Implements IComparer(Of Pony)


        Public Function Equals1(ByVal Pony As Pony, ByVal OtherPony As Pony) As Boolean Implements IEqualityComparer(Of Pony).Equals

            If Pony.Name = OtherPony.Name Then
                Return True
            End If

            Return False

        End Function

        Public Function IEquals1(ByVal Pony As Pony, ByVal OtherPony As Pony) As Integer Implements IComparer(Of Pony).Compare

            Return String.Compare(Pony.Name, OtherPony.Name)

        End Function

        Public Function GetHashCode1(ByVal Pony As Pony) As Integer Implements IEqualityComparer(Of Pony).GetHashCode
            Return Pony.ID
        End Function

    End Class

    Class House
        Inherits Pony.Behavior.effect

        Friend Door As Point = New Point
        Friend Active As Boolean = False

        Friend Instances As New List(Of Pony.Behavior.effect)

        Friend visitors As New List(Of String) 'Pony names.

        Friend File_path As String
        Friend ImageFileName As String

        Friend timer As Integer = 300 ' seconds
        Friend last_cycle_time As DateTime = Now()

        Sub New(_name As String, folder_path As String, image_file As String, image_path As String, door_point As Point, cycletime As Integer, pony_name_list As List(Of String), load_images_now As Boolean)

            behavior_name = "N/A"
            Pony_Name = "N/A"
            name = _name
            right_image_path = image_path
            left_image_path = image_path
            Duration = 99
            Repeat_Delay = Repeat_Delay
            placement_direction_right = Directions.center
            centering_right = Directions.center
            placement_direction_left = Directions.center
            centering_left = Directions.center
            follow = follow
            timer = cycletime

            Door = door_point
            visitors = pony_name_list
            File_path = folder_path
            ImageFileName = image_file

            If load_images_now = True Then
                Manager = My.Forms.Main.manager
                LoadImages()
                My.Forms.Main.Active_Effects.Add(Me)
            End If

        End Sub

        Friend Shared Function ImageScale(ByVal size As Size) As Size

            Dim scale = My.Forms.Main.PonyScale

            Return New Size(size.Width * scale, size.Height * scale)

        End Function

        Overrides Function duplicate() As Pony.Behavior.effect

            Dim new_effect As New Pony.Behavior.effect()

            new_effect.name = name
            new_effect.behavior_name = behavior_name

            new_effect.Pony_Name = Pony_Name
            new_effect.Owning_Pony = Nothing

            'new_effect.right_image = Image.FromFile(right_image_path)
            'new_effect.left_image = Image.FromFile(left_image_path)
            new_effect.right_image_path = right_image_path
            new_effect.left_image_path = left_image_path
            new_effect.Duration = 0
            new_effect.Repeat_Delay = 0
            new_effect.placement_direction_right = placement_direction_right
            new_effect.centering_right = centering_right
            new_effect.placement_direction_left = placement_direction_left
            new_effect.centering_left = centering_left

            new_effect.follow = Nothing

            new_effect.last_used = last_used
            new_effect.already_played_for_currentbehavior = already_played_for_currentbehavior

            new_effect.Manager = My.Forms.Main.manager
            new_effect.LoadImages()

            Return new_effect

        End Function


        'Checks to see if it is time to deploy/recall a pony and does so. 
        Friend Sub Cycle()

            If DateDiff(DateInterval.Second, last_cycle_time, Now()) > timer Then
                last_cycle_time = Now()

                If Instances.Count = 0 Then
                    Me.Active = False
                    Exit Sub
                End If


                Dim instance = Instances(Rnd() * (Instances.Count - 1))

                If My.Forms.Main.Active_Ponies.Count = 1 Then
                    deploy_pony(instance)
                    Exit Sub
                End If

                If My.Forms.Main.Active_Ponies.Count > My.Forms.Options.Max_Pony_Counter.Value Then
                    Recall_Pony(instance)
                    Exit Sub
                End If

                If Rnd() > 0.5 Then
                    'skip this round
                    Console.WriteLine("Did nothing")
                    Exit Sub
                End If

                If Rnd() > 0.5 Then
                    deploy_pony(instance)
                Else
                    Recall_Pony(instance)
                End If

            End If

        End Sub

        Sub deploy_pony(instance As Pony.Behavior.effect)

            Dim choices As New List(Of String)

            Dim ALL As Boolean = False

            For Each entry In visitors
                If LCase(entry) = "all" Then
                    For Each Pony In My.Forms.Main.Selectable_Ponies
                        choices.Add(Pony.Name)
                    Next
                    ALL = True
                    Exit For
                End If
            Next

            If ALL = False Then
                For Each Pony In visitors
                    choices.Add(Pony)
                Next
            End If

            For Each Pony In My.Forms.Main.Active_Ponies
                choices.Remove(Pony.Name)
            Next

            choices.Remove("Random Pony")

            If choices.Count = 0 Then
                Exit Sub
            End If


            Dim selected_name = choices(Rnd() * (choices.Count - 1))

            For Each Pony In My.Forms.Main.Selectable_Ponies
                If Pony.Name = selected_name Then

                    Dim deployed_pony = Pony.Duplicate()

                    deployed_pony.SelectBehavior()

                    deployed_pony.location = instance.location + Door - deployed_pony.GetImageCenter()
                    deployed_pony.Precise_X_Location = deployed_pony.location.X
                    deployed_pony.Precise_Y_Location = deployed_pony.location.Y
                    deployed_pony.initialized = True

                    Dim groups As New List(Of Integer)
                    Dim Alternate_Group_Behaviors As New List(Of Pony.Behavior)

                    For Each Behavior In deployed_pony.Behaviors
                        If Not groups.Contains(Behavior.Group) Then groups.Add(Behavior.Group)

                        If Behavior.Group <> 0 AndAlso Behavior.Skip = False Then
                            Alternate_Group_Behaviors.Add(Behavior)
                        End If
                    Next

                    Dim selected_group = Rnd() * (groups.Count - 1)

                    If selected_group <> 0 AndAlso Alternate_Group_Behaviors.Count > 0 Then
                        deployed_pony.SelectBehavior(Alternate_Group_Behaviors(Rnd() * (Alternate_Group_Behaviors.Count - 1)))
                    End If

                    My.Forms.Main.Active_Ponies.Add(deployed_pony)

                    Console.WriteLine("Deployed " & Pony.Name)

                    For Each other_Pony In Main.Active_Ponies
                        'we need to set up interactions again to account for new ponies.
                        other_Pony.Initialize_Interactions()
                    Next

                    Exit Sub
                End If
            Next

        End Sub

        Sub Recall_Pony(instance As Pony.Behavior.effect)

            Dim choices As New List(Of String)

            Dim ALL As Boolean = False

            For Each entry In visitors
                If LCase(entry) = "all" Then
                    For Each Pony In My.Forms.Main.Active_Ponies
                        choices.Add(Pony.Name)
                    Next
                    ALL = True
                    Exit For
                End If
            Next

            If ALL = False Then
                For Each Pony In My.Forms.Main.Active_Ponies
                    For Each otherpony In visitors
                        If LCase(Pony.Name) = LCase(otherpony) Then
                            choices.Add(Pony.Name)
                            Exit For
                        End If
                    Next
                Next
            End If

            If choices.Count = 0 Then Exit Sub

            Dim selected_name = choices(Rnd() * (choices.Count - 1))

            For Each Pony In My.Forms.Main.Active_Ponies
                If Pony.Name = selected_name Then

                    If Pony.Is_Interacting Then Exit Sub
                    If Pony.dragging Then Exit Sub

                    If Pony.sleeping Then Pony.wake_up()

                    Pony.Destination = instance.location + Door
                    Pony.Going_Home = True
                    Pony.current_behavior = Pony.GetAppropriateBehavior(Pony.Allowed_Moves.All, False)
                    Pony.current_behavior.end_time = DateAdd(DateInterval.Minute, 5, Now())

                    Console.WriteLine("Recalled " & Pony.Name)

                    Exit Sub
                End If
            Next

        End Sub

    End Class

    Class BehaviorGroup

        Friend Name As String = ""
        Friend Number As Integer = -1

        Sub New(_name As String, _number As Integer)
            Name = _name
            Number = _number
        End Sub

    End Class

End Class