﻿Imports System.Windows.Forms

Public Class New_Interaction

    Dim change_existing_interaction = False
    Dim existing_interaction As Pony.Interaction = Nothing

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Trim(Name_Textbox.Text) = "" Then
            MsgBox("You must enter a name for the new behavior.")
            Exit Sub
        End If

        If InStr(Name_Textbox.Text, ",") <> 0 Then
            MsgBox("The interaction name can't have a comma in it.")
            Exit Sub
        End If

        For Each Interaction In My.Forms.Pony_Editor.Preview_Pony.Interactions
            If LCase(Interaction.Name) = LCase(Trim(Name_Textbox.Text)) Then
                MsgBox("Interaction with name '" & Interaction.Name & "' already exists.  Please select a different name.")
                Exit Sub
            End If
        Next


        Dim chance = Trim(Replace(Chance_Box.Text, "%", ""))

        If Not IsNumeric(chance) Then
            MsgBox("You need to enter a % chance that the behavior has to occur (or you may have entered an invalid one).")
            Exit Sub
        End If

        If Not IsNumeric(Proximity_Box.Text) Then
            MsgBox("You need to enter a number for proximity.")
            Exit Sub
        End If

        If Not IsNumeric(Reactivation_Delay_Textbox.Text) Then
            MsgBox("You need to enter a number for the reactivation delay.")
            Exit Sub
        End If

        If CDbl(chance) < 0 Then
            MsgBox("You entered a negative value for % chance.  Please correct this.")
            Exit Sub
        End If

        If CDbl(Proximity_Box.Text) < 0 Then
            MsgBox("You entered a negative value for activation distance.  Please correct this.")
            Exit Sub
        End If

        If CDbl(Reactivation_Delay_Textbox.Text) < 0 Then
            MsgBox("You entered a negative value for reactivation delay.  Please correct this.")
            Exit Sub
        End If

        Dim linked_behavior = ""
        Dim skip = False


        If Targets_Box.CheckedItems.Count = 0 Then
            MsgBox("You need to select at least one pony to interact with.")
            Exit Sub
        End If

        If Behaviors_Box.CheckedItems.Count = 0 Then
            MsgBox("You need to select at least one behavior to trigger.")
            Exit Sub
        End If

        Dim targetlist As String = ""

        For Each Pony In Targets_Box.CheckedItems
            targetlist += My.Forms.Pony_Editor.quotes(Pony) & ","
        Next

        targetlist = Mid(targetlist, 1, targetlist.Length - 1)

        Dim behaviorlist As String = ""
        For Each behavior In Behaviors_Box.CheckedItems
            behaviorlist += behavior & ","
        Next

        behaviorlist = Mid(behaviorlist, 1, behaviorlist.Length - 1)

        If change_existing_interaction Then
            Dim old_interaction As Pony.Interaction = Nothing
            For Each Interaction As Pony.Interaction In My.Forms.Pony_Editor.Preview_Pony.Interactions
                If Name_Textbox.Text = Interaction.Name Then
                    old_interaction = Interaction
                End If
            Next

            If Not IsNothing(old_interaction) Then
                My.Forms.Pony_Editor.Preview_Pony.Interactions.Remove(old_interaction)
            End If
        End If


        My.Forms.Pony_Editor.Preview_Pony.add_Interaction(Name_Textbox.Text,
                                                          My.Forms.Pony_Editor.Preview_Pony.Name, _
                                                          CDbl(chance / 100),
                                                          Proximity_Box.Text, _
                                                          targetlist, _
                                                          TargetMode_Checkbox.Checked, _
                                                          behaviorlist, _
                                                          Reactivation_Delay_Textbox.Text, _
                                                          False)

        MsgBox("Important note!:  You will need to make sure that the initiating pony and EACH target pony have all the behaviors selected, with those names.")

        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click

        Me.Close()
    End Sub


    Friend Sub Change_Interaction(ByVal interaction As Pony.Interaction)

        Targets_Box.Items.Clear()
        Behaviors_Box.Items.Clear()

        With My.Forms.Pony_Editor

            Dim linked_behavior_list As DataGridViewComboBoxColumn = .Pony_Behaviors_Grid.Columns(My.Forms.Pony_Editor.B_Grid.Link)
            For Each item In linked_behavior_list.Items
                Behaviors_Box.Items.Add(item)
            Next

            For Each Pony In My.Forms.Main.Selectable_Ponies
                Targets_Box.Items.Add(Pony.Name)
            Next

        End With

        Behaviors_Box.Items.Remove("None")

        Me.Text = "Create new interaction..."

        TargetMode_Checkbox.Checked = False

        Chance_Box.Text = ""
        Proximity_Box.Text = "300"
        Name_Textbox.Text = ""

        If IsNothing(interaction) Then
            change_existing_interaction = False
            Name_Textbox.Enabled = True
            existing_interaction = Nothing
            Exit Sub
        End If

        Name_Textbox.Enabled = False
        change_existing_interaction = True
        existing_interaction = interaction
        TargetMode_Checkbox.Checked = interaction.Select_All_Targets

        Chance_Box.Text = interaction.Probability * 100
        Name_Textbox.Text = interaction.Name
        Proximity_Box.Text = interaction.Proximity_Activation_Distance
        Me.Text = "Edit interaction..."

        Dim targets = SplitWithQualifiers(interaction.Targets_String, ",", ControlChars.Quote)

        Dim target_index_list As New List(Of Integer)

        For Each target In targets
            For Each item In Targets_Box.Items
                If LCase(Trim(target)) = LCase(Trim(item)) Then
                    target_index_list.Add(Targets_Box.Items.IndexOf(item))
                End If
            Next
        Next

        Dim behaviors_index_list As New List(Of Integer)

        For Each behavior In interaction.Behavior_List
            For Each item In Behaviors_Box.Items
                If LCase(Trim(behavior.Name)) = LCase(Trim(item)) Then
                    behaviors_index_list.Add(Behaviors_Box.Items.IndexOf(item))
                End If
            Next
        Next

        For Each index In target_index_list
            Targets_Box.SetItemChecked(index, True)
        Next

        For Each index In behaviors_index_list
            Behaviors_Box.SetItemChecked(index, True)
        Next

    End Sub

End Class
