﻿Public Class Options

    Dim ScreenAvoidancePreviewBox As Rectangle = New Rectangle(New  _
        Point(0, 0), New Size(0, 0))
    Dim Avoidance_Preview_Graphics As Graphics = Nothing

    Dim already_loaded = False

    Friend Sound_Volume As Integer = -10000
    Friend SlowDownFactor As Double = 1.0

    Friend ScreenSaverBackgroundColor As Color = Nothing
    Friend ScreenSaverBackgroundImagePath As String = ""

    'Store ponycounts here as when ponies are active, the menu is disposed.
    Friend ponycounts As New List(Of String())

    Private Sub Avoidance_Size_X_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Avoidance_Size_X.ValueChanged


        If IsNothing(Avoidance_Preview_Image.Image) Then Exit Sub

        ScreenAvoidancePreviewBox.Size = New Size((0.01 * Avoidance_Size_X.Value) * Avoidance_Preview_Image.Image.Size.Width, ScreenAvoidancePreviewBox.Size.Height)

        ReDraw_Avoidance_Zone()

    End Sub

    Private Sub Avoidance_Size_Y_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Avoidance_Size_Y.ValueChanged

        If IsNothing(Avoidance_Preview_Image.Image) Then Exit Sub

        ScreenAvoidancePreviewBox.Size = New Size(ScreenAvoidancePreviewBox.Size.Width, (Avoidance_Size_Y.Value * 0.01) * Avoidance_Preview_Image.Image.Size.Height)

        ReDraw_Avoidance_Zone()

    End Sub

    Private Sub Avoidance_Loc_X_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Avoidance_Loc_X.ValueChanged

        If IsNothing(Avoidance_Preview_Image.Image) Then Exit Sub

        ScreenAvoidancePreviewBox.Location = New Point((0.01 * Avoidance_Loc_X.Value) * Avoidance_Preview_Image.Image.Size.Width, ScreenAvoidancePreviewBox.Location.Y)

        ReDraw_Avoidance_Zone()

    End Sub

    Private Sub Avoidance_Loc_Y_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Avoidance_Loc_Y.ValueChanged

        If IsNothing(Avoidance_Preview_Image.Image) Then Exit Sub

        ScreenAvoidancePreviewBox.Location = New Point(ScreenAvoidancePreviewBox.Location.X, (Avoidance_Loc_Y.Value * 0.01) * Avoidance_Preview_Image.Image.Size.Height)

        ReDraw_Avoidance_Zone()

    End Sub

    Sub ReDraw_Avoidance_Zone()

        If Not IsNothing(Avoidance_Preview_Graphics) Then
            Avoidance_Preview_Graphics.Clear(Color.White)

            Avoidance_Preview_Graphics.FillRectangle(New System.Drawing.SolidBrush(Color.ForestGreen), ScreenAvoidancePreviewBox)

            Avoidance_Preview_Image.Invalidate()
        End If

    End Sub

    Private Sub ScreenSelection_Box_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ScreenSelection_Box.SelectedIndexChanged

        If ScreenSelection_Box.SelectedItems.Count = 0 Then
            No_Monitor_Warning.Visible = True
            Exit Sub
        Else
            No_Monitor_Warning.Visible = False
        End If


        My.Forms.Main.screens_to_use.Clear()

        For i = 0 To ScreenSelection_Box.SelectedItems.Count - 1

            For Each monitor In Screen.AllScreens
                If monitor.DeviceName = ScreenSelection_Box.SelectedItems(i) Then
                    My.Forms.Main.screens_to_use.Add(monitor)
                End If
            Next

        Next

        If My.Forms.Main.PonyForms.Count = 0 Then
            'done
            Exit Sub
        End If

        'if we are actively running, we need to shut down the ponies and recreate the PonyForm

        My.Forms.Main.Pony_Shutdown(False)

        My.Forms.Main.Pony_Startup()


    End Sub


    Private Sub Options_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        If already_loaded = True Then Exit Sub

        ScreenSaverBackgroundColor = Nothing
        ScreenSaverBackgroundImagePath = ""
        Screensaver_Transparent_Checkbox.Checked = True
        Teleport_Checkbox.Checked = False

        'setup avoidance area

        Cursor_zone_counter.Value = My.Forms.Main.cursor_zone_size

        ScreenAvoidancePreviewBox = New Rectangle(New Point(0, 0), New Size(0, 0))

        Dim bitmap As New Bitmap(Avoidance_Preview_Image.Size.Width, Avoidance_Preview_Image.Size.Height)

        Avoidance_Preview_Image.Image = bitmap

        Avoidance_Preview_Graphics = Graphics.FromImage(Avoidance_Preview_Image.Image)


        Avoidance_Loc_X.Value = 0 '40
        Avoidance_Loc_Y.Value = 0 '40
        Avoidance_Size_X.Value = 0 '20
        Avoidance_Size_Y.Value = 0 '20

        'get monitor names

        ScreenSelection_Box.Items.Clear()

        For Each monitor In Screen.AllScreens
            ScreenSelection_Box.Items.Add(monitor.DeviceName)
            My.Forms.Main.screens_to_use.Add(monitor)
        Next

        For i = 0 To ScreenSelection_Box.Items.Count - 1
            ScreenSelection_Box.SetSelected(i, True)
        Next

        Max_Pony_Counter.Value = 300

        SlowDownFactor_Slider.Value = 10
        SlowDownFactor = 1
        slowdown_label.Text = "1x"

        Cursor_Avoidance_Enabled.Checked = True
        Pony_Dragging_Enabled.Checked = True
        Effects_Enabled.Checked = True

        If My.Forms.Main.DisableSoundsDueToDirectXFailure = True Then
            Sounds_Disabled_Label.Visible = True
            Sounds_Enabled.Checked = False
            Sounds_Enabled.Enabled = False
            ScreenSaver_Sounds_Checkbox.Enabled = False
        Else
            Sounds_Disabled_Label.Visible = False
            Sounds_Enabled.Checked = True
        End If

        ScreenSaver_Sounds_Checkbox.Checked = True

        PoniesAlwaysOnTop_Checkbox.Checked = True

        Suspend_on_Fullscreen_Checkbox.Checked = True

        Sounds_Per_Pony_Radio.Checked = True
        My.Forms.Main.NoRandomDuplicates_Option.Checked = True
        Interactions_Enabled.Checked = True
        Cursor_zone_counter.Value = 100
        Window_Avoidance_Enabled.Checked = False
        Pony_Speak_Chance_Counter.Value = 1
        Disable_Speech.Checked = False
        Interaction_Errors_Displayed.Checked = False
        PoniesAvoidPonies.Checked = False
        PoniesStayInBoxes.Checked = False
        Window_Avoidance_Enabled_CheckedChanged(Nothing, Nothing)
        My.Forms.Main.PonyFilter_Box.Items.Clear()

        SetDefaultFilterCategories()

        Scale_Slider.Value = 100
        Sound_Volume = -7500 '~25% volume
        Volume_Control.Value = 650

        already_loaded = True

    End Sub

    Private Sub SetDefaultFilterCategories()

        My.Forms.Main.PonyFilter_Box.Items.Clear()

        My.Forms.Main.PonyFilter_Box.Items.Add("Main Ponies")
        My.Forms.Main.PonyFilter_Box.Items.Add("Supporting Ponies")
        My.Forms.Main.PonyFilter_Box.Items.Add("Alternate Art")
        My.Forms.Main.PonyFilter_Box.Items.Add("Fillies")
        My.Forms.Main.PonyFilter_Box.Items.Add("Colts")
        My.Forms.Main.PonyFilter_Box.Items.Add("Pets")
        My.Forms.Main.PonyFilter_Box.Items.Add("Stallions")
        My.Forms.Main.PonyFilter_Box.Items.Add("Mares")
        My.Forms.Main.PonyFilter_Box.Items.Add("Alicorns")
        My.Forms.Main.PonyFilter_Box.Items.Add("Unicorns")
        My.Forms.Main.PonyFilter_Box.Items.Add("Pegasi")
        My.Forms.Main.PonyFilter_Box.Items.Add("Earth Ponies")
        My.Forms.Main.PonyFilter_Box.Items.Add("Non-Ponies")
        My.Forms.Main.PonyFilter_Box.Items.Add("Not Tagged")

    End Sub

    Private Sub Cursor_zone_counter_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cursor_zone_counter.ValueChanged
        My.Forms.Main.cursor_zone_size = Cursor_zone_counter.Value
    End Sub

    Private Sub Close_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Close_Button.Click

        Me.Visible = False

    End Sub


    Enum Settings_Categories

        Options = 1
        Monitors = 2
        PonyCount = 3
        FilterCategories = 4

    End Enum

    Enum Settings

        Cursor_Avoidance_Size = 1
        Forest_L_X = 2
        Forest_L_Y = 3
        Forest_S_X = 4
        Forest_S_Y = 5
        Max_Ponies = 6
        Pony_Drag = 7
        Pony_Cursor_Avoid = 8
        Pony_Speak_Chance = 9
        Effects_Enabled = 10
        Sounds_Enabled = 11
        Interactions_Enabled = 12
        Window_Avoidance_Enabled = 13
        Speech_Disabled = 14
        Show_Interaction_Errors = 15
        Ponies_Avoid_Ponies = 16
        Ponies_stayin_Boxes = 17
        Pony_Scale = 18
        ScreenSaver_Sounds = 19
        Limit_Sounds = 20
        No_Duplicate_Random_Ponies = 21
        Teleport_Enabled = 22
        ScreenSaver_SolidColor = 23
        ScreenSaver_BGImage = 24
        ScreenSaver_Style = 25
        PoniesAlwaysOnTop = 26
        SuspendOnFullScreen = 27
        Sound_Volume = 28
        Slowdown_Factor = 29

    End Enum


    Friend Sub Save_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Save_Button.Click

        If ScreenSelection_Box.SelectedItems.Count = 0 Then
            MsgBox("You need to select at least one monitor.")
            Exit Sub
        End If

        Try
            'we use unicode instead of the default encoding so that characters in other languages can be saved
            'otherwise, you may get a "character could not be written in the current code page!" exception.
            Dim Settings_file As New System.IO.StreamWriter(My.Forms.Main.Install_Location & System.IO.Path.DirectorySeparatorChar & "Settings.ini", False, System.Text.Encoding.UTF8)

            Dim options_line = Settings_Categories.Options & ","
            options_line += Cursor_zone_counter.Value & ","
            options_line += Avoidance_Loc_X.Value & ","
            options_line += Avoidance_Loc_Y.Value & ","
            options_line += Avoidance_Size_X.Value & ","
            options_line += Avoidance_Size_Y.Value & ","
            options_line += Max_Pony_Counter.Value & ","
            options_line += Pony_Dragging_Enabled.Checked & ","
            options_line += Cursor_Avoidance_Enabled.Checked & ","
            options_line += Pony_Speak_Chance_Counter.Value & ","
            options_line += Effects_Enabled.Checked & ","
            options_line += Sounds_Enabled.Checked & ","
            options_line += Interactions_Enabled.Checked & ","
            options_line += Window_Avoidance_Enabled.Checked & ","
            options_line += Disable_Speech.Checked & ","
            options_line += Interaction_Errors_Displayed.Checked & ","
            options_line += PoniesAvoidPonies.Checked & ","
            options_line += PoniesStayInBoxes.Checked & ","
            options_line += Scale_Slider.Value & ","
            options_line += ScreenSaver_Sounds_Checkbox.Checked & ","
            options_line += Sounds_Limit1_Radio.Checked & ","
            options_line += My.Forms.Main.NoRandomDuplicates_Option.Checked & ","
            options_line += Teleport_Checkbox.Checked & ","
            options_line += ScreenSaverBackgroundColor.ToArgb & ","
            options_line += ScreenSaverBackgroundImagePath & ","
            If Screensaver_Transparent_Checkbox.Checked Then
                options_line += "transparent" & ","
            End If
            If Screensaver_solidcolor_checkbox.Checked Then
                options_line += "solidcolor" & ","
            End If
            If Screensaver_use_bgimage_checkbox.Checked Then
                options_line += "image" & ","
            End If
            options_line += PoniesAlwaysOnTop_Checkbox.Checked & ","
            options_line += Suspend_on_Fullscreen_Checkbox.Checked & ","
            options_line += Volume_Control.Value & ","
            options_line += SlowDownFactor & ","
           

            Settings_file.WriteLine(options_line)

            For Each monitor In ScreenSelection_Box.SelectedItems
                Settings_file.WriteLine(Settings_Categories.Monitors & "," & ControlChars.Quote & monitor.ToString & ControlChars.Quote)
            Next

            Try
                For Each ponycount In ponycounts
                    Settings_file.WriteLine(Settings_Categories.PonyCount & "," & ControlChars.Quote & ponycount(1) & ControlChars.Quote & "," & ponycount(2))
                Next
            Catch ex2 As Exception
                MsgBox("Error: Too much pony!" & ControlChars.NewLine & _
                        "Details: You entered something crazy in one of the ponies' boxes." & ControlChars.NewLine & _
                        "Real Details: " & ex2.Message)
            End Try

            For Each category In My.Forms.Main.PonyFilter_Box.Items
                Settings_file.WriteLine(Settings_Categories.FilterCategories & "," & ControlChars.Quote & category & ControlChars.Quote)
            Next

            Settings_file.Flush()
            Settings_file.Close()

        Catch ex As Exception
            MsgBox("Can't save to disk.  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)
            Exit Sub
        End Try

        MsgBox("Save completed!")

    End Sub


    Friend Sub Reset_Click(ByVal sender As System.Object, ByVal e As System.EventArgs, Optional ByVal counts_only As Boolean = False) Handles Reset_Button.Click

        If counts_only = False Then
            already_loaded = False

            Options_Load(Nothing, Nothing)
        End If

        ponycounts = New List(Of String())

        For Each PonyPanel In My.Forms.Main.SplitContainer1.Panel1.Controls

            If PonyPanel.GetType Is GetType(Panel) Then
                For Each Control In PonyPanel.Controls
                    If Control.GetType Is GetType(TextBox) Then
                        Dim textbox As TextBox = Control
                        textbox.Text = "1"
                    End If
                Next
            End If
        Next

        Scale_Slider_Scroll(Nothing, Nothing)

        If My.Forms.Main.Visible = True Then
            My.Forms.Main.Redraw_Menu()
        End If

    End Sub

    Friend Sub Load_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs, Optional ByVal silent As Boolean = False, Optional ByVal counts_only As Boolean = False) Handles Load_Button.Click

        Try

            If Not My.Computer.FileSystem.FileExists(My.Forms.Main.Install_Location & System.IO.Path.DirectorySeparatorChar & "Settings.ini") Then
                If Not silent Then
                    MsgBox("Settings file (Settings.ini) not found.")
                End If

                Exit Sub
            End If

            Dim Settings_File As New System.IO.StreamReader(My.Forms.Main.Install_Location & System.IO.Path.DirectorySeparatorChar & "Settings.ini")

            Dim options As String() = Nothing
            Dim Monitors As New List(Of String)
            ponycounts = New List(Of String())
            If counts_only = False Then My.Forms.Main.PonyFilter_Box.Items.Clear()

            Do Until Settings_File.EndOfStream

                Dim Settings_Line = Settings_File.ReadLine()

                Dim columns = SplitWithQualifiers(Settings_Line, ",", ControlChars.Quote)

                Select Case columns(0)

                    Case Settings_Categories.Options
                        options = columns
                    Case Settings_Categories.Monitors
                        Monitors.Add(columns(1))
                    Case Settings_Categories.PonyCount
                        PonyCounts.Add(columns)
                    Case Settings_Categories.FilterCategories
                        If counts_only = False Then My.Forms.Main.PonyFilter_Box.Items.Add(columns(1))
                    Case Else
                        If silent = False Then
                            MsgBox("Warning:  Unknown setting category in settings file: " & columns(0))
                        End If
                End Select
            Loop

            Settings_File.Close()

            If counts_only = False Then
                If Not IsNothing(options) Then Load_Options(options)
                Load_Monitors(Monitors)
                If My.Forms.Main.PonyFilter_Box.Items.Count = 0 Then
                    SetDefaultFilterCategories()
                End If
            End If

            Load_PonyCounts(PonyCounts)

            Scale_Slider_Scroll(Nothing, Nothing)

        Catch ex As Exception

            MsgBox("Can't load settings from disk (settings.ini).  Details: " & ex.Message & ControlChars.NewLine & ex.StackTrace)

        End Try

    End Sub


    Sub Load_Options(ByVal options As String())

        For i = 1 To UBound(options) - 1

            Dim setting = options(i)

            Select Case i

                Case Settings.Cursor_Avoidance_Size
                    Cursor_zone_counter.Value = setting
                Case Settings.Forest_L_X
                    Avoidance_Loc_X.Value = setting
                Case Settings.Forest_L_Y
                    Avoidance_Loc_Y.Value = setting
                Case Settings.Forest_S_X
                    Avoidance_Size_X.Value = setting
                Case Settings.Forest_S_Y
                    Avoidance_Size_Y.Value = setting
                Case Settings.Max_Ponies
                    Max_Pony_Counter.Value = setting
                Case Settings.Pony_Cursor_Avoid
                    Cursor_Avoidance_Enabled.Checked = CBool(setting)
                Case Settings.Pony_Drag
                    Pony_Dragging_Enabled.Checked = CBool(setting)
                Case Settings.Pony_Speak_Chance
                    Pony_Speak_Chance_Counter.Value = setting
                Case Settings.Effects_Enabled
                    Effects_Enabled.Checked = CBool(setting)
                Case Settings.Sounds_Enabled
                    If My.Forms.Main.DisableSoundsDueToDirectXFailure = True Then
                        Sounds_Disabled_Label.Visible = True
                        Sounds_Enabled.Checked = False
                        Sounds_Enabled.Enabled = False
                    Else
                        Sounds_Enabled.Checked = CBool(setting)
                    End If
                Case Settings.Interactions_Enabled
                    Interactions_Enabled.Checked = CBool(setting)
                Case Settings.Window_Avoidance_Enabled
                    Window_Avoidance_Enabled.Checked = CBool(setting)
                Case Settings.Speech_Disabled
                    Disable_Speech.Checked = CBool(setting)
                Case Settings.Show_Interaction_Errors
                    Interaction_Errors_Displayed.Checked = CBool(setting)
                Case Settings.Ponies_Avoid_Ponies
                    PoniesAvoidPonies.Checked = CBool(setting)
                Case Settings.Ponies_stayin_Boxes
                    PoniesStayInBoxes.Checked = CBool(setting)
                Case Settings.Pony_Scale
                    Scale_Slider.Value = CDbl(setting)
                Case Settings.ScreenSaver_Sounds
                    ScreenSaver_Sounds_Checkbox.Checked = CBool(setting)
                Case Settings.Limit_Sounds
                    Sounds_Limit1_Radio.Checked = CBool(setting)
                    Sounds_Per_Pony_Radio.Checked = Not CBool(setting)
                Case Settings.No_Duplicate_Random_Ponies
                    My.Forms.Main.NoRandomDuplicates_Option.Checked = CBool(setting)
                Case Settings.Teleport_Enabled
                    Teleport_Checkbox.Checked = CBool(setting)
                Case Settings.ScreenSaver_SolidColor
                    ScreenSaverBackgroundColor = Color.FromArgb(setting)
                Case Settings.ScreenSaver_BGImage
                    If System.IO.File.Exists(setting) Then
                        ScreenSaverBackgroundImagePath = setting
                    End If
                Case Settings.ScreenSaver_Style
                    Select Case setting
                        Case "transparent"
                            Screensaver_Transparent_Checkbox.Checked = True
                        Case "solidcolor"
                            Screensaver_solidcolor_checkbox.Checked = True
                        Case "image"
                            Screensaver_use_bgimage_checkbox.Checked = True
                    End Select
                Case Settings.PoniesAlwaysOnTop
                    PoniesAlwaysOnTop_Checkbox.Checked = CBool(setting)
                Case Settings.SuspendOnFullScreen
                    Suspend_on_Fullscreen_Checkbox.Checked = CBool(setting)
                Case Settings.Sound_Volume
                    Volume_Control.Value = CInt(setting)
                Case Settings.Slowdown_Factor
                    SlowDownFactor_Slider.Value = CInt(setting) * 10
                    SlowDownFactor = CInt(setting)
                Case Else
                    MsgBox("Warning:  Unknown option type in settings file (settings.ini): " & i & ", value: " & setting)
            End Select

        Next

    End Sub


    Sub Load_Monitors(ByVal monitors As List(Of String))

        ScreenSelection_Box.SelectedItems.Clear()

        For Each monitor As String In monitors
            For i = 0 To ScreenSelection_Box.Items.Count - 1
                If ScreenSelection_Box.Items(i) = monitor Then
                    ScreenSelection_Box.SetSelected(i, True)
                End If
            Next
        Next

        If ScreenSelection_Box.SelectedItems.Count = 0 Then
            ScreenSelection_Box.SetSelected(0, True)
        End If

    End Sub

    Sub Load_PonyCounts(ByVal PonyCounts As List(Of String()))

        If My.Forms.Main.Ponies_Have_Launched = True Then Exit Sub

        My.Forms.Main.Zero_Ponies_Button_Click(Nothing, Nothing)

        For Each ponycount In PonyCounts

            For Each PonyPanel In My.Forms.Main.SplitContainer1.Panel1.Controls
                If PonyPanel.GetType Is GetType(Panel) Then

                    Dim textbox As TextBox = Nothing
                    Dim label As Label = Nothing

                    For Each Control In PonyPanel.Controls

                        If Control.GetType Is GetType(Label) Then
                            If Control.Text <> "How many?" Then
                                label = Control
                            End If
                        End If

                        If Control.GetType Is GetType(TextBox) Then
                            textbox = Control
                        End If
                    Next

                    If label.Text = ponycount(1) Then
                        textbox.Text = ponycount(2)
                        Exit For
                    End If

                End If
            Next
        Next

    End Sub

    Private Sub Window_Avoidance_Enabled_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Window_Avoidance_Enabled.CheckedChanged

        If Window_Avoidance_Enabled.Checked = False Then
            PoniesAvoidPonies.Enabled = False
            PoniesStayInBoxes.Enabled = False
        Else
            PoniesAvoidPonies.Enabled = True
            PoniesStayInBoxes.Enabled = True
        End If

    End Sub

  
    Private Sub Scale_Slider_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Scale_Slider.ValueChanged

        Dim scale = Scale_Slider.Value / 100
        scale = Math.Round(scale, 2)
        ImageScale_Label.Text = scale & "x"
        My.Forms.Main.PonyScale = scale

    End Sub

    Private Sub Scale_Slider_MouseUp(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Scale_Slider.MouseUp
        If My.Forms.Main.Visible = True Then
            My.Forms.Main.Redraw_Menu()
        End If
    End Sub

    Private Sub Volume_Control_Change(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Volume_Control.ValueChanged

        'The slider is in %, we need to convert that to the volume that an
        'Microsoft.DirectX.AudioVideoPlayback.Audio.volume would take.
        'which is from -10000 to 0 (0 being the loudest), on a logarithmic scale.

        Sound_Volume = 4342 * Math.Log(Volume_Control.Value / 100) - 10000

        Volume_Label.Text = Volume_Control.Value / 100

        If My.Forms.Main.DisableSoundsDueToDirectXFailure = False Then
            Change_Active_Sound_Volume(Sound_Volume)
        End If

    End Sub

    Private Sub Change_Active_Sound_Volume(Volume As Integer)
        For Each sound As Microsoft.DirectX.AudioVideoPlayback.Audio In My.Forms.Main.Active_Sounds
            sound.Volume = Volume
        Next
    End Sub

    Private Sub Custom_Filters_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Custom_Filters_Button.Click

        Filters_Form.ShowDialog()

    End Sub

  
    Private Sub Color_Select_Button_Click(sender As System.Object, e As System.EventArgs) Handles Color_Select_Button.Click

        Dim colorpicker As New System.Windows.Forms.ColorDialog

        If colorpicker.ShowDialog() = Windows.Forms.DialogResult.OK Then
            screensaver_color_warning_label.Visible = False

            ScreenSaverBackgroundColor = colorpicker.Color
            screensaver_color_warning_label.Visible = False
        End If

    End Sub

    Private Sub Screensaver_solidcolor_checkbox_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles Screensaver_solidcolor_checkbox.CheckedChanged

        If Screensaver_solidcolor_checkbox.Checked Then
            If IsNothing(ScreenSaverBackgroundColor) OrElse ScreenSaverBackgroundColor = New Color Then
                screensaver_color_warning_label.Visible = True
            End If
        Else
            screensaver_color_warning_label.Visible = False
        End If
      

    End Sub

  
    Private Sub Screensaver_use_bgimage_checkbox_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles Screensaver_use_bgimage_checkbox.CheckedChanged

        If Screensaver_use_bgimage_checkbox.Checked Then
            If ScreenSaverBackgroundImagePath = "" OrElse Not System.IO.File.Exists(ScreenSaverBackgroundImagePath) Then
                screensaver_image_warning_label.Visible = True
            End If
        Else
            screensaver_image_warning_label.Visible = False
        End If

    End Sub

    Private Sub Screensaver_background_image_select_button_Click(sender As System.Object, e As System.EventArgs) Handles Screensaver_background_image_select_button.Click

        Dim image_file_selection As New System.Windows.Forms.OpenFileDialog

        image_file_selection.Title = "Select your screensaver background image..."
        image_file_selection.Filter = "GIF Files (*.gif)|*.gif|PNG Files (*.png)|*.png|JPG Files (*.jpg)|*.jpg|All Files (*.*)|*.*"
        image_file_selection.FilterIndex = 4
        image_file_selection.Multiselect = False

        If image_file_selection.ShowDialog() = Windows.Forms.DialogResult.OK Then

            If System.IO.File.Exists(image_file_selection.FileName) Then

                Try
                    Dim test_image = Image.FromFile(image_file_selection.FileName)
                Catch ex As Exception
                    MsgBox("Error:  Could not load image '" & image_file_selection.FileName & "'.  Details: " & ex.Message)
                    Exit Sub
                End Try

                ScreenSaverBackgroundImagePath = image_file_selection.FileName
                screensaver_image_warning_label.Visible = False
            End If

        End If


    End Sub

    Private Sub PoniesAlwaysOnTop_Checkbox_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles PoniesAlwaysOnTop_Checkbox.CheckedChanged

        For Each ponyform As PonyGraphicsForm In My.Forms.Main.PonyForms
            ponyform.TopMost = PoniesAlwaysOnTop_Checkbox.Checked
        Next

    End Sub

    Private Sub SlowDownFactor_Slider_Scroll(sender As System.Object, e As System.EventArgs) Handles SlowDownFactor_Slider.Scroll
        SlowDownFactor = SlowDownFactor_Slider.Value / 10
        slowdown_label.Text = SlowDownFactor & "x"
    End Sub
End Class