﻿Imports System.Windows.Forms

Public Class Follow_Object

    Dim PreviewPoint As Point = New Point(0, 0)
    Dim Point_Preview_Graphics As Graphics = Nothing
    Dim pony_thumbnail As Image = Nothing
    Friend behavior_to_change As Pony.Behavior = Nothing


    Private Sub Loc_X_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Point_Loc_X.ValueChanged
        If IsNothing(Point_Preview_Image.Image) Then Exit Sub

        Set_PreviewPoint()

        ReDraw_Follow_Point()
    End Sub

    Private Sub Loc_Y_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Point_Loc_Y.ValueChanged
        If IsNothing(Point_Preview_Image.Image) Then Exit Sub

        Set_PreviewPoint()

        ReDraw_Follow_Point()
    End Sub

    Sub Set_PreviewPoint()

        'do X
        If Pony_Radio.Checked Then
            PreviewPoint = New Point((Point_Preview_Image.Image.Size.Width / 2) + Point_Loc_X.Value, _
                         (Point_Preview_Image.Image.Size.Height / 2) + Point_Loc_Y.Value)
        Else
            PreviewPoint = New Point((0.01 * Point_Loc_X.Value) * Point_Preview_Image.Image.Size.Width, PreviewPoint.Y)
        End If

        'do Y
        If Pony_Radio.Checked Then
            PreviewPoint = New Point((Point_Preview_Image.Image.Size.Width / 2) + Point_Loc_X.Value, _
                         (Point_Preview_Image.Image.Size.Height / 2) + Point_Loc_Y.Value)
        Else
            PreviewPoint = New Point(PreviewPoint.X, (Point_Loc_Y.Value * 0.01) * Point_Preview_Image.Image.Size.Height)
        End If
    End Sub

    Sub ReDraw_Follow_Point()
        If Not IsNothing(Point_Preview_Graphics) Then

            Set_PreviewPoint()

            Point_Preview_Graphics.Clear(Color.White)

            If Not IsNothing(pony_thumbnail) Then
                Point_Preview_Graphics.DrawImage(pony_thumbnail, New Point((Point_Preview_Image.Image.Size.Width / 2) - (pony_thumbnail.Size.Width / 2), _
                         (Point_Preview_Image.Image.Size.Height / 2) - (pony_thumbnail.Size.Height / 2)))
            End If

            Point_Preview_Graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                            New Point(PreviewPoint.X - 5, PreviewPoint.Y - 5), _
                                            New Point(PreviewPoint.X + 5, PreviewPoint.Y + 5))
            Point_Preview_Graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                           New Point(PreviewPoint.X + 5, PreviewPoint.Y - 5), _
                                           New Point(PreviewPoint.X - 5, PreviewPoint.Y + 5))
            Point_Preview_Image.Invalidate()
        End If
    End Sub


    Private Sub Form_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        If IsNothing(behavior_to_change) Then
            Throw New Exception("Behavior to modify is not set.  Call Change_Behavior() first before loading this form.")
        End If

        Dim bitmap As New Bitmap(Point_Preview_Image.Size.Width, Point_Preview_Image.Size.Height)

        Point_Preview_Image.Image = bitmap

        Point_Preview_Graphics = Graphics.FromImage(Point_Preview_Image.Image)

        ReDraw_Follow_Point()

    End Sub

    Friend Sub Change_Behavior(ByVal behavior As Pony.Behavior)

        If IsNothing(behavior) Then
            Throw New Exception("Passed behavior is empty when trying to update follow settings.")
        End If

        behavior_to_change = behavior

        Follow_ComboBox.Items.Clear()

        Dim effects_list = My.Forms.Pony_Editor.get_effect_list()

        For Each Available_Pony As Pony In My.Forms.Main.Selectable_Ponies
            Follow_ComboBox.Items.Add(Available_Pony.Name)
        Next

        For Each effect In effects_list
            Follow_ComboBox.Items.Add(effect.Pony_Name & "'s " & effect.name)
        Next

        moving_behavior_box.Items.Clear()
        stopped_behavior_box.Items.Clear()

        For Each otherbehavior In My.Forms.Pony_Editor.Preview_Pony.Behaviors
            moving_behavior_box.Items.Add(otherbehavior.Name)
            stopped_behavior_box.Items.Add(otherbehavior.Name)
        Next

        If behavior.Auto_Select_Images_On_Follow = False Then
            Auto_Select_Images_Checkbox.Checked = False
        Else
            Auto_Select_Images_Checkbox.Checked = True
        End If

        Dim point As Boolean = False
        Dim pony As Boolean = False

        If (behavior.destination_xcoord <> 0 OrElse behavior.destination_ycoord <> 0) Then
            point = True
        End If

        If (Not IsNothing(behavior.follow_object_name) AndAlso behavior.follow_object_name <> "") Then
            pony = True
            For Each item In Follow_ComboBox.Items
                If LCase(string_to_effectname(item)) = LCase(behavior_to_change.follow_object_name) Then
                    Follow_ComboBox.SelectedItem = item
                End If
            Next
        End If

        If (Not IsNothing(behavior.follow_moving_behavior) AndAlso behavior.follow_moving_behavior_name <> "") Then
            For Each item In moving_behavior_box.Items
                If LCase(item) = LCase(behavior.follow_moving_behavior_name) Then
                    moving_behavior_box.SelectedItem = item
                End If
            Next
        End If

        If (Not IsNothing(behavior.follow_stopped_Behavior) AndAlso behavior.follow_stopped_Behavior_name <> "") Then
            For Each item In stopped_behavior_box.Items
                If LCase(item) = LCase(behavior.follow_stopped_Behavior_name) Then
                    stopped_behavior_box.SelectedItem = item
                End If
            Next
        End If

        If pony AndAlso Not point Then
            Pony_Radio.Checked = True
            PreviewPoint = (New Point((0.01 * 50) * Point_Preview_Image.Size.Width, (50 * 0.01) * Point_Preview_Image.Size.Height))
        End If

        If point AndAlso Not pony Then
            Point_Radio.Checked = True
            Point_Loc_X.Value = behavior.destination_xcoord
            Point_Loc_Y.Value = behavior.destination_ycoord
        End If

        If pony AndAlso point Then
            Pony_Radio.Checked = True
            Point_Loc_X.Value = behavior.destination_xcoord
            Point_Loc_Y.Value = behavior.destination_ycoord
        End If

        If Not pony AndAlso Not point Then
            Pony_Radio.Checked = True
            pony_thumbnail = Nothing
            PreviewPoint = (New Point((0.01 * 50) * Point_Preview_Image.Size.Width, (50 * 0.01) * Point_Preview_Image.Size.Height))
        End If

        Me.Text = "Select following parameters for " & behavior.Name

    End Sub


    Private Sub Pony_Radio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Pony_Radio.CheckedChanged, Point_Radio.CheckedChanged

        Point_Loc_X.Enabled = True
        Point_Loc_Y.Enabled = True

        If Pony_Radio.Checked Then
            Point_Loc_X.Maximum = 500
            Point_Loc_X.Minimum = -500
            Point_Loc_X.Value = 0
            Point_Loc_Y.Maximum = 500
            Point_Loc_Y.Minimum = -500
            Point_Loc_Y.Value = 0
            Follow_ComboBox.Enabled = True
            relativeto_label.Text = "(Relative to pony/effect center)"
            units_label.Text = "Location (X/Y) (in pixels)"
        Else
            If Point_Radio.Checked Then

                pony_thumbnail = Nothing
                Point_Loc_X.Maximum = 100
                Point_Loc_X.Minimum = 0
                Point_Loc_X.Value = 50
                Point_Loc_Y.Maximum = 100
                Point_Loc_Y.Minimum = 0
                Point_Loc_Y.Value = 50
                Follow_ComboBox.Enabled = False
                relativeto_label.Text = "(Relative to top right of screen)"
                units_label.Text = "Location (X/Y) (in % of screen height/width)"

            Else

                Follow_ComboBox.Enabled = False
                Point_Loc_X.Enabled = False
                Point_Loc_Y.Enabled = False

            End If

        End If

    End Sub


    Private Sub Follow_ComboBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Follow_ComboBox.SelectedIndexChanged

        For Each Pony In My.Forms.Main.Selectable_Ponies
            If Pony.Name = Follow_ComboBox.SelectedItem Then
                Try
                    pony_thumbnail = Image.FromFile(Pony.Behaviors(0).right_image_path)
                Catch ex As Exception
                    MsgBox("Note:  Failed to load image for pony " & Pony.Name)
                End Try

                ReDraw_Follow_Point()
                Exit Sub
            End If
        Next

        For Each effect In My.Forms.Pony_Editor.get_effect_list()
            If effect.name = string_to_effectname(Follow_ComboBox.SelectedItem) Then
                Try
                    pony_thumbnail = Image.FromFile(effect.right_image_path)
                Catch ex As Exception
                    MsgBox("Note:  Failed to load image for effect " & effect.name)
                End Try
                ReDraw_Follow_Point()
                Exit Sub
            End If
        Next

    End Sub


    Private Function string_to_effectname(ByVal name As String) As String
        For Each effect In My.Forms.Pony_Editor.get_effect_list()

            If (effect.Pony_Name & "'s " & effect.name) = name Then
                Return effect.name
            End If

        Next

        Return name
    End Function

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.Close()
    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Auto_Select_Images_Checkbox.Checked = False AndAlso (moving_behavior_box.SelectedItem = "" OrElse stopped_behavior_box.SelectedItem = "") Then
            MsgBox("If you disable auto-selection of images, then you must specifiy a moving behavior and a stopped behavior to get the images from." _
                   & ControlChars.NewLine & "(You can select the behavior you are editing once you have saved it first.)")
            Exit Sub
        End If

        If Not DisableRadio.Checked Then
            behavior_to_change.destination_xcoord = Point_Loc_X.Value
            behavior_to_change.destination_ycoord = Point_Loc_Y.Value
        Else
            behavior_to_change.destination_xcoord = 0
            behavior_to_change.destination_ycoord = 0
        End If

        If Pony_Radio.Checked Then
            behavior_to_change.follow_object_name = string_to_effectname(Follow_ComboBox.SelectedItem)
        Else
            behavior_to_change.follow_object_name = ""
        End If

        If Auto_Select_Images_Checkbox.Checked = True Then
            behavior_to_change.Auto_Select_Images_On_Follow = True
        Else
            behavior_to_change.Auto_Select_Images_On_Follow = False
            behavior_to_change.follow_moving_behavior_name = moving_behavior_box.SelectedItem
            behavior_to_change.follow_stopped_Behavior_name = stopped_behavior_box.SelectedItem
        End If

        Me.Close()

    End Sub

    Private Sub Auto_Select_Images_Checkbox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Auto_Select_Images_Checkbox.CheckedChanged
        If Auto_Select_Images_Checkbox.Checked = True Then
            moving_behavior_box.Enabled = False
            stopped_behavior_box.Enabled = False
        Else
            moving_behavior_box.Enabled = True
            stopped_behavior_box.Enabled = True
        End If
    End Sub
End Class
