﻿Public Class Image_Centers_Form

    Dim previewpony As Pony
    Dim behavior_index = 0
    Dim animation_index = 0
    Dim max_frame = 0

    Dim left_previous_center As New Point
    Dim right_previous_center As New Point
    Dim right_center = New Point
    Dim left_center = New Point

    Dim right_image As Image
    Dim left_image As Image
    Dim left_graphics As Graphics = Nothing
    Dim right_graphics As Graphics = Nothing

    Dim right_image_framedimensions
    Dim right_image_framecount
    Dim left_image_framedimensions
    Dim left_image_framecount

    Private Sub Image_Centers_Form_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        previewpony = My.Forms.Pony_Editor.Preview_Pony
        Me.Text = "Image Centering for " & previewpony.Name

        behavior_index = 0
        animation_index = 0
        left_previous_center = New Point()
        right_previous_center = New Point()

        Left_ImageBox.Image = New Bitmap(Left_ImageBox.Width, Left_ImageBox.Height)
        Right_ImageBox.Image = New Bitmap(Right_ImageBox.Width, Right_ImageBox.Height)

        left_graphics = Graphics.FromImage(Left_ImageBox.Image)
        right_graphics = Graphics.FromImage(Right_ImageBox.Image)

        load_behavior(behavior_index)

    End Sub


    Sub Redraw_Marker()
        If Not IsNothing(left_graphics) AndAlso Not IsNothing(right_graphics) Then

            If BG_Black_Radio.Checked = True Then
                right_graphics.Clear(Color.Black)
                left_graphics.Clear(Color.Black)
            Else
                right_graphics.Clear(Color.White)
                left_graphics.Clear(Color.White)
            End If
         

            right_graphics.DrawImage(right_image, New Point(0, 0))
            left_graphics.DrawImage(left_image, New Point(0, 0))

            left_graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                            New Point(left_center.X - 5, left_center.Y - 5), _
                                            New Point(left_center.X + 5, left_center.Y + 5))
            left_graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                           New Point(left_center.X + 5, left_center.Y - 5), _
                                           New Point(left_center.X - 5, left_center.Y + 5))
            right_graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                          New Point(right_center.X - 5, right_center.Y - 5), _
                                          New Point(right_center.X + 5, right_center.Y + 5))
            right_graphics.DrawLine(New System.Drawing.Pen(Color.Red, 2), _
                                           New Point(right_center.X + 5, right_center.Y - 5), _
                                           New Point(right_center.X - 5, right_center.Y + 5))

            Left_ImageBox.Invalidate()
            Right_ImageBox.Invalidate()

            left_center_label.Text = left_center.ToString()
            right_center_label.Text = right_center.ToString()

        End If
    End Sub

    Private Sub Left_ImageBox_Click(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Left_ImageBox.Click

        left_center = e.Location
        previewpony.Behaviors(behavior_index).left_image_center = left_center
        Redraw_Marker()

    End Sub

    Private Sub Right_ImageBox_Click(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Right_ImageBox.Click

        right_center = e.Location
        previewpony.Behaviors(behavior_index).right_image_center = right_center
        Redraw_Marker()

    End Sub

    Sub load_behavior(ByVal index As Integer)

        animation_index = 0

        left_image = Image.FromFile(previewpony.Behaviors(index).left_image_path)
        right_image = Image.FromFile(previewpony.Behaviors(index).right_image_path)

        Try
            left_image_framedimensions = New System.Drawing.Imaging.FrameDimension(left_image.FrameDimensionsList(0))
            left_image_framecount = left_image.GetFrameCount(left_image_framedimensions)
            left_image.SelectActiveFrame(left_image_framedimensions, animation_index)

            right_image_framedimensions = New System.Drawing.Imaging.FrameDimension(right_image.FrameDimensionsList(0))
            right_image_framecount = right_image.GetFrameCount(right_image_framedimensions)
            right_image.SelectActiveFrame(right_image_framedimensions, animation_index)
        Catch ex As Exception
            left_image_framedimensions = Nothing
            right_image_framedimensions = Nothing
            left_image_framecount = 0
            right_image_framecount = 0
        End Try

        left_center = previewpony.Behaviors(index).left_image_center
        right_center = previewpony.Behaviors(index).right_image_center
        left_previous_center = left_center
        right_previous_center = right_center

        left_center_label.Text = left_center.ToString()
        right_center_label.Text = right_center.ToString()

        behavior_name_label.Text = previewpony.Behaviors(index).Name

        frame_label.Text = animation_index

        If left_image_framecount < right_image_framecount Then
            max_frame = left_image_framecount
        Else
            max_frame = right_image_framecount
        End If

        frame_slider.Value = 0
        If max_frame = 0 Then
            frame_slider.Maximum = 0
        Else
            frame_slider.Maximum = max_frame - 1
        End If

        Redraw_Marker()

    End Sub

    Private Sub Next_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Next_Button.Click

        If behavior_index = previewpony.Behaviors.Count - 1 Then
            behavior_index = 0
        Else
            behavior_index += 1
        End If

        load_behavior(behavior_index)

    End Sub

    Private Sub Prev_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Prev_Button.Click

        If behavior_index = 0 Then
            behavior_index = previewpony.Behaviors.Count - 1
        Else
            behavior_index -= 1
        End If

        load_behavior(behavior_index)

    End Sub

    Private Sub Frame_Slider_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles frame_slider.Scroll

        animation_index = frame_slider.Value
        frame_label.Text = animation_index

        right_image.SelectActiveFrame(right_image_framedimensions, animation_index)
        left_image.SelectActiveFrame(left_image_framedimensions, animation_index)

        Redraw_Marker()

    End Sub

    Private Sub Right_Image_Set_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Right_Image_Set_Button.Click
        right_center = right_previous_center
        previewpony.Behaviors(behavior_index).right_image_center = right_center
        Redraw_Marker()
    End Sub

    Private Sub Left_Image_Set_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Left_Image_Set_Button.Click
        left_center = left_previous_center
        previewpony.Behaviors(behavior_index).left_image_center = left_center
        Redraw_Marker()
    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        Me.Close()
    End Sub

    Private Sub BG_Black_Radio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BG_Black_Radio.CheckedChanged
        Redraw_Marker()
    End Sub
End Class